/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.jaspi.impl;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.auth.message.callback.PasswordValidationCallback;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.ServerAuthConfig;
import java.io.IOException;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.CallbackUtil;
import org.wildfly.security.auth.jaspi._private.ElytronMessages;
import org.wildfly.security.auth.jaspi.impl.WrappingServerAuthConfig;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.permission.ElytronPermission;

public class JaspiAuthenticationContext {
    static final ElytronPermission CREATE_AUTH_CONTEXT = ElytronPermission.forName((String)"createServerAuthenticationContext");
    private final SecurityDomain securityDomain;
    private final boolean integrated;
    private CachedIdentity cachedIdentity = null;
    private volatile SecurityIdentity securityIdentity = null;
    private final Set<String> roles = new HashSet<String>();

    JaspiAuthenticationContext(SecurityDomain securityDomain, boolean integrated, SecurityIdentity securityIdentity) {
        this.securityDomain = securityDomain;
        this.integrated = integrated;
        this.securityIdentity = securityIdentity;
        if (securityIdentity != null) {
            this.cachedIdentity = new CachedIdentity("JASPI", true, securityIdentity);
        }
    }

    JaspiAuthenticationContext(SecurityDomain securityDomain, boolean integrated, CachedIdentity cachedIdentity) {
        this.securityDomain = securityDomain;
        this.integrated = integrated;
        this.cachedIdentity = cachedIdentity;
    }

    @Deprecated
    public static JaspiAuthenticationContext newInstance(SecurityDomain securityDomain, boolean integrated) {
        return JaspiAuthenticationContext.newInstance(securityDomain, integrated, (SecurityIdentity)null);
    }

    public static JaspiAuthenticationContext newInstance(SecurityDomain securityDomain, boolean integrated, CachedIdentity cachedIdentity) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)CREATE_AUTH_CONTEXT);
        }
        return new JaspiAuthenticationContext((SecurityDomain)Assert.checkNotNullParam((String)"securityDomain", (Object)securityDomain), integrated, cachedIdentity);
    }

    public static JaspiAuthenticationContext newInstance(SecurityDomain securityDomain, boolean integrated, SecurityIdentity cachedIdentity) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)CREATE_AUTH_CONTEXT);
        }
        return new JaspiAuthenticationContext((SecurityDomain)Assert.checkNotNullParam((String)"securityDomain", (Object)securityDomain), integrated, cachedIdentity);
    }

    public ServerAuthConfig getServerAuthConfig(AuthConfigProvider authConfigProvider, String layer, String appContext) throws AuthException {
        return WrappingServerAuthConfig.getServerAuthConfig(authConfigProvider, layer, appContext, this.createCallbackHandler());
    }

    public CallbackHandler createCallbackHandler() {
        return this.createCommonCallbackHandler(this.integrated);
    }

    private CallbackHandler createCommonCallbackHandler(final boolean integrated) {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                try {
                    this.handleOne(callbacks, 0);
                }
                catch (Exception e) {
                    if (e instanceof PrivilegedActionException) {
                        if (e.getCause() instanceof UnsupportedCallbackException) {
                            throw (UnsupportedCallbackException)e.getCause();
                        }
                        if (e.getCause() instanceof IOException) {
                            throw (IOException)e.getCause();
                        }
                    }
                    throw new IOException(e);
                }
            }

            /*
             * Unable to fully structure code
             */
            private void handleOne(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
                block44: {
                    block43: {
                        if (callbacks.length == index) {
                            return;
                        }
                        callback = callbacks[index];
                        if (!(callback instanceof PasswordValidationCallback)) break block43;
                        pvc = (PasswordValidationCallback)callback;
                        if (JaspiAuthenticationContext.this.cachedIdentity != null) {
                            JaspiAuthenticationContext.this.cachedIdentity = null;
                        }
                        username = pvc.getUsername();
                        ElytronMessages.log.tracef("Handling PasswordValidationCallback for '%s'", username);
                        evidence = new PasswordGuessEvidence(pvc.getPassword());
                        try {
                            authenticated = JaspiAuthenticationContext.this.securityDomain.authenticate(username, (Evidence)evidence);
                            pvc.setResult(true);
                            JaspiAuthenticationContext.this.securityIdentity = authenticated;
                            JaspiAuthenticationContext.this.cachedIdentity = new CachedIdentity("JASPI", true, authenticated);
                        }
                        catch (Exception e) {
                            ElytronMessages.log.trace("Authentication failed", e);
                            pvc.setResult(false);
                        }
                        break block44;
                    }
                    if (!(callback instanceof CallerPrincipalCallback)) ** GOTO lbl97
                    ElytronMessages.log.trace("Handling CallerPrincipalCallback");
                    cpc = (CallerPrincipalCallback)callback;
                    originalPrincipal = cpc.getPrincipal();
                    callerName = cpc.getName();
                    callerPrincipal = originalPrincipal != null ? originalPrincipal : (callerName != null ? new NamePrincipal(callerName) : null);
                    ElytronMessages.log.tracef("Original Principal = '%s', Caller Name = '%s', Resulting Principal = '%s'", originalPrincipal, callerName, callerPrincipal);
                    authorizedIdentity = null;
                    securityIdentityToImport = null;
                    if (JaspiAuthenticationContext.this.cachedIdentity != null) {
                        securityIdentityToImport = JaspiAuthenticationContext.this.cachedIdentity.getSecurityIdentity() == null ? JaspiAuthenticationContext.this.securityDomain.createAdHocIdentity(JaspiAuthenticationContext.this.cachedIdentity.getName()) : JaspiAuthenticationContext.this.cachedIdentity.getSecurityIdentity();
                        if (securityIdentityToImport.getPrincipal().equals(callerPrincipal)) {
                            if (integrated) {
                                sac = JaspiAuthenticationContext.this.securityDomain.createNewAuthenticationContext();
                                try {
                                    sac.importIdentity(securityIdentityToImport);
                                    sac.authorize();
                                    authorizedIdentity = sac.getAuthorizedIdentity();
                                }
                                finally {
                                    if (sac != null) {
                                        sac.close();
                                    }
                                }
                            } else {
                                authorizedIdentity = JaspiAuthenticationContext.this.securityDomain.createAdHocIdentity(callerPrincipal);
                                for (String role : JaspiAuthenticationContext.this.cachedIdentity.getRoles()) {
                                    JaspiAuthenticationContext.this.roles.add(role);
                                }
                            }
                        }
                        JaspiAuthenticationContext.this.cachedIdentity = null;
                    }
                    if (authorizedIdentity == null) {
                        if (JaspiAuthenticationContext.this.securityIdentity != null) {
                            if (callerPrincipal != null) {
                                authorizationRequired = integrated != false && JaspiAuthenticationContext.this.securityIdentity.getPrincipal().equals(callerPrincipal) == false;
                                authorizedIdentity = JaspiAuthenticationContext.this.securityIdentity.createRunAsIdentity(callerPrincipal, authorizationRequired);
                            } else if (integrated) {
                                sac = JaspiAuthenticationContext.this.securityDomain.createNewAuthenticationContext();
                                try {
                                    sac.importIdentity(JaspiAuthenticationContext.this.securityIdentity);
                                    sac.authorize();
                                    authorizedIdentity = sac.getAuthorizedIdentity();
                                }
                                finally {
                                    if (sac != null) {
                                        sac.close();
                                    }
                                }
                            } else {
                                authorizedIdentity = JaspiAuthenticationContext.this.securityIdentity;
                            }
                        } else {
                            if (callerPrincipal == null) {
                                this.handleOne(callbacks, index + 1);
                                return;
                            }
                            if (integrated) {
                                sac = JaspiAuthenticationContext.this.securityDomain.createNewAuthenticationContext();
                                try {
                                    sac.setAuthenticationPrincipal(callerPrincipal);
                                    if (!sac.authorize()) ** GOTO lbl89
                                    authorizedIdentity = sac.getAuthorizedIdentity();
                                }
                                finally {
                                    if (sac != null) {
                                        sac.close();
                                    }
                                }
                            } else {
                                authorizedIdentity = JaspiAuthenticationContext.this.securityDomain.createAdHocIdentity(callerPrincipal);
                            }
                        }
                    }
lbl89:
                    // 8 sources

                    if (authorizedIdentity != null) {
                        JaspiAuthenticationContext.this.securityIdentity = authorizedIdentity;
                        subject = cpc.getSubject();
                        if (subject != null && !subject.isReadOnly()) {
                            subject.getPrincipals().add(authorizedIdentity.getPrincipal());
                        }
                    } else {
                        throw ElytronMessages.log.authorizationFailed();
lbl97:
                        // 1 sources

                        if (callback instanceof GroupPrincipalCallback) {
                            ElytronMessages.log.trace("Handling GroupPrincipalCallback");
                            ElytronMessages.log.trace("Handling GroupPrincipalCallback");
                            gpc = (GroupPrincipalCallback)callback;
                            groups = gpc.getGroups();
                            if (groups != null && groups.length > 0) {
                                JaspiAuthenticationContext.this.roles.addAll(Arrays.asList(groups));
                            }
                        } else {
                            CallbackUtil.unsupported((Callback)callback);
                            this.handleOne(callbacks, index + 1);
                        }
                    }
                }
                this.handleOne(callbacks, index + 1);
            }
        };
    }

    public SecurityIdentity getAuthorizedIdentity() throws IllegalStateException {
        SecurityIdentity securityIdentity = this.securityIdentity;
        if (securityIdentity != null && this.roles.size() > 0) {
            if (ElytronMessages.log.isTraceEnabled()) {
                Iterator<String> rolesIterator = this.roles.iterator();
                StringBuilder sb = new StringBuilder(rolesIterator.next());
                while (rolesIterator.hasNext()) {
                    sb.append(",").append(rolesIterator.next());
                }
                ElytronMessages.log.tracef("Assigning roles '%s' to resulting SecurityIdentity", sb.toString());
            }
            Roles roles = Roles.fromSet(this.roles);
            RoleMapper roleMapper = RoleMapper.constant((Roles)roles);
            SecurityIdentity temp = securityIdentity;
            securityIdentity = temp.withDefaultRoleMapper(roleMapper);
        } else {
            ElytronMessages.log.trace("No roles request of CallbackHandler.");
        }
        return securityIdentity;
    }
}

