package org.wildfly.security.authz.jacc;

import java.util.Locale;
import java.security.ProtectionDomain;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.SecurityException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.security.Permission;
import java.lang.Throwable;
import jakarta.security.jacc.PolicyContextException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2025-09-30T15:24:37+0100")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String readOnlyPermissionCollection$str() {
        return "ELY03018: Cannot add permissions to a read-only permission collection";
    }
    @Override
    public final SecurityException readOnlyPermissionCollection() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), readOnlyPermissionCollection$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void authzFailedToCheckPermission(final ProtectionDomain domain, final Permission permission, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, authzFailedToCheckPermission$str(), domain, permission);
    }
    protected String authzFailedToCheckPermission$str() {
        return "ELY08500: Failed to check permissions for protection domain [%s] and permission [%s].";
    }
    protected String authzInvalidStateForOperation$str() {
        return "ELY08501: Invalid state [%s] for operation.";
    }
    @Override
    public final UnsupportedOperationException authzInvalidStateForOperation(final String actualState) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), authzInvalidStateForOperation$str(), actualState));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authzLinkSamePolicyConfiguration$str() {
        return "ELY08502: Can't link policy configuration [%s] to itself.";
    }
    @Override
    public final IllegalArgumentException authzLinkSamePolicyConfiguration(final String contextID) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), authzLinkSamePolicyConfiguration$str(), contextID));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authzContextIdentifierNotSet$str() {
        return "ELY08503: ContextID not set. Check if the context id was set using PolicyContext.setContextID.";
    }
    @Override
    public final IllegalStateException authzContextIdentifierNotSet() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), authzContextIdentifierNotSet$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authzInvalidPolicyContextIdentifier$str() {
        return "ELY08504: Invalid policy context identifier [%s].";
    }
    @Override
    public final IllegalArgumentException authzInvalidPolicyContextIdentifier(final String contextID) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), authzInvalidPolicyContextIdentifier$str(), contextID));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authzUnableToObtainPolicyConfiguration$str() {
        return "ELY08505: Could not obtain PolicyConfiguration for contextID [%s].";
    }
    @Override
    public final PolicyContextException authzUnableToObtainPolicyConfiguration(final String contextId, final Throwable cause) {
        final PolicyContextException result = new PolicyContextException(String.format(getLoggingLocale(), authzUnableToObtainPolicyConfiguration$str(), contextId), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authzPolicyConfigurationNotInService$str() {
        return "ELY08506: Policy configuration with contextID [%s] is not in service state.";
    }
    @Override
    public final IllegalStateException authzPolicyConfigurationNotInService(final String contextID) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), authzPolicyConfigurationNotInService$str(), contextID));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void authzCouldNotObtainSecurityIdentity(final Throwable cause) {
        super.log.logf(FQCN, DEBUG, cause, authzCouldNotObtainSecurityIdentity$str());
    }
    protected String authzCouldNotObtainSecurityIdentity$str() {
        return "ELY08508: Could not obtain authorized identity.";
    }
}
