/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz.jacc;

import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.PolicyContextHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;

public class DelegatingPolicyContextHandler
implements PolicyContextHandler {
    private final String key;
    private final PolicyContextHandler preferred;
    private final PolicyContextHandler fallBack;

    public DelegatingPolicyContextHandler(String key, PolicyContextHandler preferred, PolicyContextHandler fallBack) {
        this.key = (String)Assert.checkNotNullParam((String)"key", (Object)key);
        this.preferred = (PolicyContextHandler)Assert.checkNotNullParam((String)"preferred", (Object)preferred);
        this.fallBack = (PolicyContextHandler)Assert.checkNotNullParam((String)"fallBack", (Object)fallBack);
    }

    public boolean supports(String key) throws PolicyContextException {
        return this.preferred.supports(key);
    }

    public String[] getKeys() throws PolicyContextException {
        return new String[]{this.key};
    }

    public Object getContext(String key, Object data) throws PolicyContextException {
        return DelegatingPolicyContextHandler.getSecurityIdentity() != null ? this.preferred.getContext(key, data) : this.fallBack.getContext(key, data);
    }

    private static SecurityIdentity getSecurityIdentity() {
        SecurityDomain securityDomain = SecurityDomain.getCurrent();
        if (securityDomain != null) {
            return securityDomain.getCurrentSecurityIdentity();
        }
        return null;
    }
}

