/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz.jacc;

import jakarta.security.jacc.EJBMethodPermission;
import jakarta.security.jacc.EJBRoleRefPermission;
import jakarta.security.jacc.Policy;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.PrincipalMapper;
import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebRoleRefPermission;
import jakarta.security.jacc.WebUserDataPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.jacc.ElytronMessages;
import org.wildfly.security.authz.jacc.ElytronPolicyConfiguration;
import org.wildfly.security.authz.jacc.ElytronPolicyConfigurationFactory;
import org.wildfly.security.authz.jacc.SecurityIdentityHandler;

public class ElytronPolicy
implements Policy {
    private static final String ANY_AUTHENTICATED_USER_ROLE = "**";
    private final Set<Class<? extends Permission>> supportedPermissionTypes = new HashSet<Class<? extends Permission>>();

    public ElytronPolicy() {
        this.supportedPermissionTypes.add(WebResourcePermission.class);
        this.supportedPermissionTypes.add(WebRoleRefPermission.class);
        this.supportedPermissionTypes.add(WebUserDataPermission.class);
        this.supportedPermissionTypes.add(EJBMethodPermission.class);
        this.supportedPermissionTypes.add(EJBRoleRefPermission.class);
    }

    public boolean implies(Permission permission, Subject subject) {
        try {
            if (this.isJaccPermission(permission)) {
                ElytronPolicyConfiguration policyConfiguration = (ElytronPolicyConfiguration)ElytronPolicyConfigurationFactory.getCurrentPolicyConfiguration();
                if (this.impliesExcludedPermission(permission, policyConfiguration)) {
                    return false;
                }
                if (this.impliesUncheckedPermission(permission, policyConfiguration)) {
                    return true;
                }
                if (this.impliesRolePermission(subject, permission, policyConfiguration)) {
                    return true;
                }
            }
            if (this.impliesIdentityPermission(permission)) {
                return true;
            }
        }
        catch (Exception e) {
            ElytronMessages.log.authzFailedToCheckPermission(ElytronPolicy.toPrincipal(subject), permission, e);
        }
        return false;
    }

    private static Principal toPrincipal(Subject subject) {
        if (subject == null) {
            return null;
        }
        PrincipalMapper principalMapper = (PrincipalMapper)PolicyContext.get((String)"jakarta.security.jacc.PrincipalMapper");
        return principalMapper.getCallerPrincipal(subject);
    }

    public PermissionCollection getPermissionCollection(final Subject subject) {
        return new PermissionCollection(){

            @Override
            public void add(Permission permission) {
                throw ElytronMessages.log.readOnlyPermissionCollection();
            }

            @Override
            public boolean implies(Permission permission) {
                return ElytronPolicy.this.implies(permission, subject);
            }

            @Override
            public Enumeration<Permission> elements() {
                return Collections.emptyEnumeration();
            }
        };
    }

    private boolean impliesIdentityPermission(Permission permission) {
        SecurityIdentity actualIdentity = this.getCurrentSecurityIdentity();
        return actualIdentity != null && actualIdentity.implies(permission);
    }

    private SecurityIdentity getCurrentSecurityIdentity() {
        try {
            return (SecurityIdentity)PolicyContext.getContext((String)SecurityIdentityHandler.KEY);
        }
        catch (Exception cause) {
            ElytronMessages.log.authzCouldNotObtainSecurityIdentity(cause);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean impliesRolePermission(Subject subject, Permission permission, ElytronPolicyConfiguration policyConfiguration) throws PolicyContextException, ClassNotFoundException {
        Map<String, PermissionCollection> rolePermissions;
        PrincipalMapper principalMapper = (PrincipalMapper)PolicyContext.get((String)"jakarta.security.jacc.PrincipalMapper");
        Set roles = principalMapper.getMappedRoles(subject);
        roles.add(ANY_AUTHENTICATED_USER_ROLE);
        Map<String, PermissionCollection> map = rolePermissions = policyConfiguration.getPerRolePermissions();
        synchronized (map) {
            for (String roleName : roles) {
                PermissionCollection permissions = rolePermissions.get(roleName);
                if (permissions == null || !permissions.implies(permission)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean impliesUncheckedPermission(Permission permission, ElytronPolicyConfiguration policyConfiguration) {
        PermissionCollection uncheckedPermissions;
        PermissionCollection permissionCollection = uncheckedPermissions = policyConfiguration.getUncheckedPermissions();
        synchronized (permissionCollection) {
            return uncheckedPermissions.implies(permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean impliesExcludedPermission(Permission permission, ElytronPolicyConfiguration policyConfiguration) {
        PermissionCollection excludedPermissions;
        PermissionCollection permissionCollection = excludedPermissions = policyConfiguration.getExcludedPermissions();
        synchronized (permissionCollection) {
            return excludedPermissions.implies(permission);
        }
    }

    private boolean isJaccPermission(Permission permission) {
        return this.supportedPermissionTypes.contains(permission.getClass());
    }
}

