/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz.jacc;

import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyConfigurationFactory;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wildfly.common.Assert;
import org.wildfly.security.authz.jacc.ElytronMessages;
import org.wildfly.security.authz.jacc.ElytronPolicyConfiguration;

public class ElytronPolicyConfigurationFactory
extends PolicyConfigurationFactory {
    private static final Map<String, ElytronPolicyConfiguration> configurationRegistry = new ConcurrentHashMap<String, ElytronPolicyConfiguration>();

    static <P extends PolicyConfiguration> P getCurrentPolicyConfiguration() throws PolicyContextException {
        String contextID = PolicyContext.getContextID();
        if (contextID == null) {
            throw ElytronMessages.log.authzContextIdentifierNotSet();
        }
        try {
            PolicyConfiguration policyConfiguration = configurationRegistry.get(contextID);
            if (policyConfiguration == null) {
                throw ElytronMessages.log.authzInvalidPolicyContextIdentifier(contextID);
            }
            if (!policyConfiguration.inService()) {
                throw ElytronMessages.log.authzPolicyConfigurationNotInService(contextID);
            }
            return (P)policyConfiguration;
        }
        catch (Exception e) {
            throw ElytronMessages.log.authzUnableToObtainPolicyConfiguration(contextID, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolicyConfiguration getPolicyConfiguration(String contextID, boolean create, boolean remove) throws PolicyContextException {
        Assert.checkNotNullParam((String)"contextID", (Object)contextID);
        Map<String, ElytronPolicyConfiguration> map = configurationRegistry;
        synchronized (map) {
            ElytronPolicyConfiguration policyConfiguration = configurationRegistry.get(contextID);
            if (policyConfiguration == null) {
                return create ? this.createPolicyConfiguration(contextID) : null;
            }
            if (remove) {
                policyConfiguration.delete();
            }
            policyConfiguration.transitionTo(ElytronPolicyConfiguration.State.OPEN);
            return policyConfiguration;
        }
    }

    public PolicyConfiguration getPolicyConfiguration(String contextID, boolean remove) throws PolicyContextException {
        return this.getPolicyConfiguration(contextID, true, remove);
    }

    public PolicyConfiguration getPolicyConfiguration(String contextID) {
        try {
            return this.getPolicyConfiguration(contextID, false, false);
        }
        catch (PolicyContextException e) {
            ElytronMessages.log.trace("Unexpected exception caught", e);
            return null;
        }
    }

    public PolicyConfiguration getPolicyConfiguration() {
        try {
            return ElytronPolicyConfigurationFactory.getCurrentPolicyConfiguration();
        }
        catch (PolicyContextException e) {
            ElytronMessages.log.trace("Unable to obtain current policy configuration.", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inService(String contextID) throws PolicyContextException {
        Assert.checkNotNullParam((String)"contextID", (Object)contextID);
        Map<String, ElytronPolicyConfiguration> map = configurationRegistry;
        synchronized (map) {
            PolicyConfiguration policyConfiguration = configurationRegistry.get(contextID);
            if (policyConfiguration == null) {
                return false;
            }
            return policyConfiguration.inService();
        }
    }

    private ElytronPolicyConfiguration createPolicyConfiguration(String contextID) {
        return configurationRegistry.computeIfAbsent(contextID, ElytronPolicyConfiguration::new);
    }
}

