/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz.jacc;

import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.PolicyContextHandler;
import jakarta.security.jacc.PrincipalMapper;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.Roles;

class PrincipalMapperContextHandler
implements PolicyContextHandler {
    private static final PrincipalMapper MAPPER_INSTANCE = new ElytronPrincipalMapper();

    PrincipalMapperContextHandler() {
    }

    public boolean supports(String key) throws PolicyContextException {
        return "jakarta.security.jacc.PrincipalMapper".equals(key);
    }

    public String[] getKeys() throws PolicyContextException {
        return new String[]{"jakarta.security.jacc.PrincipalMapper"};
    }

    public Object getContext(String key, Object data) throws PolicyContextException {
        return this.supports(key) ? MAPPER_INSTANCE : null;
    }

    static class ElytronPrincipalMapper
    implements PrincipalMapper {
        ElytronPrincipalMapper() {
        }

        public Principal getCallerPrincipal(Subject subject) {
            SecurityIdentity securityIdentity = ElytronPrincipalMapper.toSecurityIdentity(subject);
            return securityIdentity != null ? securityIdentity.getPrincipal() : null;
        }

        public Set<String> getMappedRoles(Subject subject) {
            HashSet<String> roles = new HashSet<String>();
            SecurityIdentity securityIdentity = ElytronPrincipalMapper.toSecurityIdentity(subject);
            if (securityIdentity != null) {
                Roles originalRoles = securityIdentity.getRoles();
                for (String currentRole : originalRoles) {
                    roles.add(currentRole);
                }
            }
            return roles;
        }

        private static SecurityIdentity toSecurityIdentity(Subject subject) {
            Set<Object> privateCredentials = subject.getPrivateCredentials();
            for (Object currentCredential : privateCredentials) {
                if (!(currentCredential instanceof SecurityIdentity)) continue;
                return (SecurityIdentity)currentCredential;
            }
            return null;
        }
    }
}

