/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz.jacc;

import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.PolicyContextHandler;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.jacc.SubjectUtil;

class SubjectPolicyContextHandler
implements PolicyContextHandler {
    private static final String KEY = "javax.security.auth.Subject.container";

    SubjectPolicyContextHandler() {
    }

    public boolean supports(String key) throws PolicyContextException {
        return KEY.equalsIgnoreCase(key);
    }

    public String[] getKeys() throws PolicyContextException {
        return new String[]{KEY};
    }

    public Object getContext(String key, Object data) throws PolicyContextException {
        if (!this.supports(key)) {
            return null;
        }
        SecurityIdentity securityIdentity = SubjectPolicyContextHandler.getSecurityIdentity();
        if (securityIdentity != null) {
            return SubjectUtil.fromSecurityIdentity(securityIdentity);
        }
        return null;
    }

    private static SecurityIdentity getSecurityIdentity() {
        SecurityDomain securityDomain = SecurityDomain.getCurrent();
        if (securityDomain != null) {
            return securityDomain.getCurrentSecurityIdentity();
        }
        return null;
    }
}

