/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.jakarta.authz;

import jakarta.security.jacc.PolicyConfigurationFactory;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.PolicyContextHandler;
import jakarta.security.jacc.PolicyFactory;
import java.security.GeneralSecurityException;
import java.util.List;
import org.wildfly.security.authz.jacc.ElytronEEMessages;
import org.wildfly.security.authz.jacc.ElytronPolicyConfigurationFactory;
import org.wildfly.security.authz.jacc.ElytronPolicyContextHandlerFactory;
import org.wildfly.security.authz.jacc.ElytronPolicyFactory;

public class AuthorizationRegistration {
    public static boolean supportsSelfRegistration() {
        return true;
    }

    public static void register() throws GeneralSecurityException {
        PolicyFactory.setPolicyFactory((PolicyFactory)new ElytronPolicyFactory());
        List<PolicyContextHandler> policyContextHandlers = ElytronPolicyContextHandlerFactory.getPolicyContextHandlers();
        for (PolicyContextHandler current : policyContextHandlers) {
            try {
                for (String currentKey : current.getKeys()) {
                    PolicyContext.registerHandler((String)currentKey, (PolicyContextHandler)current, (boolean)true);
                }
            }
            catch (PolicyContextException e) {
                throw ElytronEEMessages.eeLog.unableToCompletePolicyContextHandlerRegistration(e);
            }
        }
        PolicyConfigurationFactory.setPolicyConfigurationFactory((PolicyConfigurationFactory)new ElytronPolicyConfigurationFactory());
    }
}

