/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.jakarta.authz;

import jakarta.security.jacc.Policy;
import jakarta.security.jacc.PolicyFactory;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import org.wildfly.security.OneTimeSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.authz.jacc.ElytronEEMessages;
import org.wildfly.security.authz.jacc.ElytronPolicy;

public class PolicyRegistration {
    private static final String POLICY_PROVIDER = "jakarta.security.jacc.policy.provider";
    private static final SecurityFactory<Policy> policyFactory;

    private static Policy newPolicy(String policyProvider) throws GeneralSecurityException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object policyInstance = classLoader.loadClass(policyProvider).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (policyInstance instanceof Policy) {
                return (Policy)policyInstance;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw ElytronEEMessages.eeLog.unableToCreatePolicy(e);
        }
        throw ElytronEEMessages.eeLog.invalidPolicyClass(policyProvider, Policy.class.getName());
    }

    public static void beginContextPolicy(String contextId, ClassLoader deploymentClassLoader) throws GeneralSecurityException {
        PolicyFactory.getPolicyFactory().setPolicy(contextId, (Policy)policyFactory.create());
    }

    public static void endContextPolicy(String contextId) throws GeneralSecurityException {
        PolicyFactory.getPolicyFactory().setPolicy(contextId, null);
    }

    static {
        String policyProvider = System.getProperty(POLICY_PROVIDER);
        policyFactory = policyProvider == null ? new OneTimeSecurityFactory(ElytronPolicy::new) : () -> PolicyRegistration.newPolicy(policyProvider);
    }
}

