/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.soteria.integration;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.glassfish.soteria.authorization.spi.CallerDetailsResolver;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;

public class ElytronCallerDetailsResolver
implements CallerDetailsResolver {
    public Principal getCallerPrincipal() {
        return ElytronCallerDetailsResolver.currentSecurityIdentity().getPrincipal();
    }

    public <T extends Principal> Set<T> getPrincipalsByType(Class<T> pType) {
        HashSet<Principal> principals = new HashSet<Principal>();
        Principal principal = this.getCallerPrincipal();
        if (principal.getClass().isAssignableFrom(pType)) {
            principals.add((Principal)pType.cast(principal));
        }
        return Collections.unmodifiableSet(principals);
    }

    public boolean isCallerInRole(String role) {
        return ElytronCallerDetailsResolver.currentSecurityIdentity().getRoles().contains(role);
    }

    public Set<String> getAllDeclaredCallerRoles() {
        HashSet<String> allRoles = new HashSet<String>();
        Iterator it = ElytronCallerDetailsResolver.currentSecurityIdentity().getRoles().iterator();
        while (it.hasNext()) {
            allRoles.add((String)it.next());
        }
        return Collections.unmodifiableSet(allRoles);
    }

    private static SecurityIdentity currentSecurityIdentity() {
        return SecurityDomain.getCurrent().getCurrentSecurityIdentity();
    }
}

