/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.soteria.original;

import jakarta.annotation.Priority;
import jakarta.el.ELProcessor;
import jakarta.enterprise.inject.Intercepted;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.authentication.mechanism.http.RememberMe;
import jakarta.security.enterprise.credential.RememberMeCredential;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.RememberMeIdentityStore;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Optional;
import java.util.Set;
import org.glassfish.soteria.Utils;
import org.glassfish.soteria.servlet.CookieHandler;
import org.wildfly.security.soteria.original.CdiUtils;
import org.wildfly.security.soteria.original.RememberMeAnnotationLiteral;

@Interceptor
@RememberMe
@Priority(value=210)
public class RememberMeInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private BeanManager beanManager;
    @Inject
    @Intercepted
    private Bean<?> interceptedBean;

    @AroundInvoke
    public Object intercept(InvocationContext invocationContext) throws Exception {
        if (Utils.isImplementationOf((Method)invocationContext.getMethod(), (Method)Utils.validateRequestMethod)) {
            return this.validateRequest(invocationContext, (HttpServletRequest)Utils.getParam((InvocationContext)invocationContext, (int)0), (HttpServletResponse)Utils.getParam((InvocationContext)invocationContext, (int)1), (HttpMessageContext)Utils.getParam((InvocationContext)invocationContext, (int)2));
        }
        if (Utils.isImplementationOf((Method)invocationContext.getMethod(), (Method)Utils.cleanSubjectMethod)) {
            this.cleanSubject(invocationContext, (HttpServletRequest)Utils.getParam((InvocationContext)invocationContext, (int)0), (HttpServletResponse)Utils.getParam((InvocationContext)invocationContext, (int)1), (HttpMessageContext)Utils.getParam((InvocationContext)invocationContext, (int)2));
        }
        return invocationContext.proceed();
    }

    private AuthenticationStatus validateRequest(InvocationContext invocationContext, HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws Exception {
        AuthenticationStatus authstatus;
        RememberMeIdentityStore rememberMeIdentityStore = CdiUtils.getBeanReference(RememberMeIdentityStore.class, new Annotation[0]);
        RememberMe rememberMeAnnotation = this.getRememberMeFromIntercepted(this.getElProcessor(invocationContext, httpMessageContext), invocationContext);
        Cookie rememberMeCookie = CookieHandler.getCookie((HttpServletRequest)request, (String)rememberMeAnnotation.cookieName());
        if (rememberMeCookie != null) {
            CredentialValidationResult result = rememberMeIdentityStore.validate(new RememberMeCredential(rememberMeCookie.getValue()));
            if (result.getStatus() == CredentialValidationResult.Status.VALID) {
                return httpMessageContext.notifyContainerAboutLogin((Principal)result.getCallerPrincipal(), result.getCallerGroups());
            }
            CookieHandler.removeCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)rememberMeAnnotation.cookieName());
        }
        if ((authstatus = (AuthenticationStatus)invocationContext.proceed()) == AuthenticationStatus.SUCCESS && httpMessageContext.getCallerPrincipal() != null) {
            Boolean isRememberMe = true;
            if (rememberMeAnnotation instanceof RememberMeAnnotationLiteral) {
                isRememberMe = ((RememberMeAnnotationLiteral)rememberMeAnnotation).isRememberMe();
            }
            if (isRememberMe.booleanValue()) {
                String token = rememberMeIdentityStore.generateLoginToken(Utils.toCallerPrincipal((Principal)httpMessageContext.getCallerPrincipal()), httpMessageContext.getGroups());
                CookieHandler.saveCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)rememberMeAnnotation.cookieName(), (String)token, (Integer)rememberMeAnnotation.cookieMaxAgeSeconds(), (boolean)rememberMeAnnotation.cookieSecureOnly(), (boolean)rememberMeAnnotation.cookieHttpOnly());
            }
        }
        return authstatus;
    }

    private void cleanSubject(InvocationContext invocationContext, HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws Exception {
        RememberMeIdentityStore rememberMeIdentityStore = CdiUtils.getBeanReference(RememberMeIdentityStore.class, new Annotation[0]);
        RememberMe rememberMeAnnotation = this.getRememberMeFromIntercepted(this.getElProcessor(invocationContext, httpMessageContext), invocationContext);
        Cookie rememberMeCookie = CookieHandler.getCookie((HttpServletRequest)request, (String)rememberMeAnnotation.cookieName());
        if (rememberMeCookie != null) {
            CookieHandler.removeCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)rememberMeAnnotation.cookieName());
            rememberMeIdentityStore.removeLoginToken(rememberMeCookie.getValue());
        }
        invocationContext.proceed();
    }

    private RememberMe getRememberMeFromIntercepted(ELProcessor elProcessor, InvocationContext invocationContext) {
        Optional<RememberMe> optionalRememberMe = org.glassfish.soteria.cdi.CdiUtils.getAnnotation((BeanManager)this.beanManager, (Class)this.interceptedBean.getBeanClass(), RememberMe.class);
        if (optionalRememberMe.isPresent()) {
            return RememberMeAnnotationLiteral.eval((RememberMe)optionalRememberMe.get(), elProcessor);
        }
        Set bindings = (Set)invocationContext.getContextData().get("org.jboss.weld.interceptor.bindings");
        if (bindings != null && (optionalRememberMe = bindings.stream().filter(annotation -> annotation.annotationType().equals(RememberMe.class)).findAny().map(annotation -> (RememberMe)RememberMe.class.cast(annotation))).isPresent()) {
            return RememberMeAnnotationLiteral.eval(optionalRememberMe.get(), elProcessor);
        }
        throw new IllegalStateException("@RememberMe not present on " + String.valueOf(this.interceptedBean.getBeanClass()));
    }

    private ELProcessor getElProcessor(InvocationContext invocationContext, HttpMessageContext httpMessageContext) {
        ELProcessor elProcessor = new ELProcessor();
        elProcessor.getELManager().addELResolver(this.beanManager.getELResolver());
        elProcessor.defineBean("self", invocationContext.getTarget());
        elProcessor.defineBean("httpMessageContext", (Object)httpMessageContext);
        return elProcessor;
    }
}

