/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.digest;

import java.security.MessageDigestSpi;
import org.wildfly.common.Assert;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.common.iteration.ByteIterator;

public class SHA512_256MessageDigest
extends MessageDigestSpi {
    private static final long[] K = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};
    private static final int BLOCK_SIZE = 128;
    private final byte[] tempByte = new byte[1];
    private final long[] H = new long[8];
    private final long[] W = new long[80];
    private final byte[] block = new byte[128];
    private long messageLength;
    private int bytesLoaded;

    public SHA512_256MessageDigest() {
        this.engineReset();
    }

    @Override
    protected void engineReset() {
        this.bytesLoaded = 0;
        this.messageLength = 0L;
        SHA512_256MessageDigest.resetH(this.H);
    }

    protected static void resetH(long[] H) {
        H[0] = 2463787394917988140L;
        H[1] = -6965556091613846334L;
        H[2] = 2563595384472711505L;
        H[3] = -7622211418569250115L;
        H[4] = -7626776825740460061L;
        H[5] = -4729309413028513390L;
        H[6] = 3098927326965381290L;
        H[7] = 1060366662362279074L;
    }

    protected byte[] resultFromH(long[] H) {
        ByteStringBuilder result = new ByteStringBuilder();
        for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
            result.appendBE(H[i]);
        }
        return result.toArray();
    }

    @Override
    protected void engineUpdate(byte input) {
        this.tempByte[0] = input;
        this.engineUpdate(this.tempByte, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        Assert.checkMinimumParameter((String)"offset", (int)0, (int)offset);
        Assert.checkMinimumParameter((String)"len", (int)0, (int)len);
        Assert.checkMaximumParameter((String)"offset + len", (int)input.length, (int)(offset + len));
        if (len == 0) {
            return;
        }
        this.messageLength += (long)len;
        while (len > 0) {
            int i;
            int loadingBytes = Math.min(len, 128 - this.bytesLoaded);
            System.arraycopy(input, offset, this.block, this.bytesLoaded, loadingBytes);
            this.bytesLoaded += loadingBytes;
            offset += loadingBytes;
            len -= loadingBytes;
            if (this.bytesLoaded != 128) continue;
            ByteIterator bi = ByteIterator.ofBytes((byte[])this.block);
            for (i = 0; i < 16; ++i) {
                this.W[i] = bi.getBE64();
            }
            for (i = 16; i < 80; ++i) {
                long s0 = SHA512_256MessageDigest.rotr(this.W[i - 15], 1) ^ SHA512_256MessageDigest.rotr(this.W[i - 15], 8) ^ this.W[i - 15] >>> 7;
                long s1 = SHA512_256MessageDigest.rotr(this.W[i - 2], 19) ^ SHA512_256MessageDigest.rotr(this.W[i - 2], 61) ^ this.W[i - 2] >>> 6;
                this.W[i] = this.W[i - 16] + s0 + this.W[i - 7] + s1;
            }
            this.processBlock();
            this.bytesLoaded = 0;
        }
    }

    @Override
    protected byte[] engineDigest() {
        int paddingLen = this.bytesLoaded < 112 ? 119 - this.bytesLoaded : 247 - this.bytesLoaded;
        ByteStringBuilder postBuilder = new ByteStringBuilder();
        postBuilder.append((byte)-128);
        postBuilder.append(new byte[paddingLen]);
        postBuilder.appendBE(this.messageLength * 8L);
        byte[] postfix = postBuilder.toArray();
        this.engineUpdate(postfix, 0, postfix.length);
        byte[] result = this.resultFromH(this.H);
        this.engineReset();
        return result;
    }

    private void processBlock() {
        long a = this.H[0];
        long b = this.H[1];
        long c = this.H[2];
        long d = this.H[3];
        long e = this.H[4];
        long f = this.H[5];
        long g = this.H[6];
        long h = this.H[7];
        for (int t = 0; t < 80; ++t) {
            long temp1 = h + SHA512_256MessageDigest.sigma1(e) + SHA512_256MessageDigest.ch(e, f, g) + K[t] + this.W[t];
            long temp2 = SHA512_256MessageDigest.sigma0(a) + SHA512_256MessageDigest.maj(a, b, c);
            h = g;
            g = f;
            f = e;
            e = d + temp1;
            d = c;
            c = b;
            b = a;
            a = temp1 + temp2;
        }
        this.H[0] = this.H[0] + a;
        this.H[1] = this.H[1] + b;
        this.H[2] = this.H[2] + c;
        this.H[3] = this.H[3] + d;
        this.H[4] = this.H[4] + e;
        this.H[5] = this.H[5] + f;
        this.H[6] = this.H[6] + g;
        this.H[7] = this.H[7] + h;
    }

    private static long sigma0(long a) {
        return SHA512_256MessageDigest.rotr(a, 28) ^ SHA512_256MessageDigest.rotr(a, 34) ^ SHA512_256MessageDigest.rotr(a, 39);
    }

    private static long sigma1(long e) {
        return SHA512_256MessageDigest.rotr(e, 14) ^ SHA512_256MessageDigest.rotr(e, 18) ^ SHA512_256MessageDigest.rotr(e, 41);
    }

    private static long ch(long e, long f, long g) {
        return e & f ^ (e ^ 0xFFFFFFFFFFFFFFFFL) & g;
    }

    private static long maj(long a, long b, long c) {
        return a & b ^ a & c ^ b & c;
    }

    private static long rotr(long x, int bits) {
        return x >>> bits | x << 64 - bits;
    }
}

