/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.source;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.spec.AlgorithmParameterSpec;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.GSSKerberosCredential;
import org.wildfly.security.credential.source.CredentialSource;

@Deprecated
public class LocalKerberosCredentialSource
implements CredentialSource {
    private final Oid[] mechanismOids;

    LocalKerberosCredentialSource(Oid[] mechanismOids) {
        this.mechanismOids = mechanismOids;
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
        return credentialType == GSSKerberosCredential.class ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    @Override
    public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
        if (credentialType != GSSKerberosCredential.class) {
            ElytronMessages.log.tracef("Unable to obtain credential of type %s from LocalKerberosCredentialSource", credentialType);
            return null;
        }
        try {
            GSSCredential gssCredential = AccessController.doPrivileged(() -> {
                GSSManager manager = GSSManager.getInstance();
                return manager.createCredential(null, 0, this.mechanismOids, 1);
            });
            ElytronMessages.log.tracef("Obtained local kerberos credential: %s", (Object)gssCredential);
            if (gssCredential == null) {
                return null;
            }
            return (C)((Credential)credentialType.cast(new GSSKerberosCredential(gssCredential)));
        }
        catch (PrivilegedActionException e) {
            try {
                throw e.getCause();
            }
            catch (IOException | Error | RuntimeException e2) {
                throw e2;
            }
            catch (Throwable throwable) {
                throw new UndeclaredThrowableException(throwable);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Oid[] mechanismOids = null;

        public Builder setMechanismOids(Oid[] mechanismOids) {
            this.mechanismOids = mechanismOids;
            return this;
        }

        public LocalKerberosCredentialSource build() {
            return new LocalKerberosCredentialSource(this.mechanismOids);
        }
    }
}

