/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.permission;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.permission.IntersectionPermissionCollection;
import org.wildfly.security.permission.UnionPermissionCollection;

public final class PermissionUtil {
    public static final Permission ALL_PERMISSION = new AllPermission();
    public static final PermissionCollection ALL_PERMISSIONS;
    public static final PermissionCollection EMPTY_PERMISSION_COLLECTION;
    public static final Permission[] NO_PERMISSIONS;

    private PermissionUtil() {
    }

    public static int parseActions(String actionsString, ToIntFunction<String> function) throws IllegalArgumentException {
        Assert.checkNotNullParam((String)"actionsString", (Object)actionsString);
        Assert.checkNotNullParam((String)"function", function);
        int actions = 0;
        int pos = 0;
        int idx = actionsString.indexOf(44);
        while (true) {
            String str;
            if (idx == -1) {
                str = actionsString.substring(pos, actionsString.length()).trim();
                if (!str.isEmpty()) {
                    actions |= function.applyAsInt(str);
                }
                return actions;
            }
            str = actionsString.substring(pos, idx).trim();
            pos = idx + 1;
            if (!str.isEmpty()) {
                actions |= function.applyAsInt(str);
            }
            idx = actionsString.indexOf(44, pos);
        }
    }

    public static long parseActions(String actionsString, ToLongFunction<String> function) throws IllegalArgumentException {
        Assert.checkNotNullParam((String)"actionsString", (Object)actionsString);
        Assert.checkNotNullParam((String)"function", function);
        long actions = 0L;
        int pos = 0;
        int idx = actionsString.indexOf(44);
        while (true) {
            String str;
            if (idx == -1) {
                str = actionsString.substring(pos, actionsString.length()).trim();
                if (!str.isEmpty()) {
                    actions |= function.applyAsLong(str);
                }
                return actions;
            }
            str = actionsString.substring(pos, idx).trim();
            pos = idx + 1;
            if (!str.isEmpty()) {
                actions |= function.applyAsLong(str);
            }
            idx = actionsString.indexOf(44, pos);
        }
    }

    public static String toActionsString(int actionBits, IntFunction<String> mappingFunction) {
        Assert.checkNotNullParam((String)"mappingFunction", mappingFunction);
        StringBuilder sb = new StringBuilder();
        if (actionBits == 0) {
            return "";
        }
        int lb = Integer.highestOneBit(actionBits);
        sb.append(mappingFunction.apply(lb));
        actionBits &= ~lb;
        while (actionBits != 0) {
            lb = Integer.highestOneBit(actionBits);
            sb.append(',').append(mappingFunction.apply(lb));
            actionBits &= ~lb;
        }
        return sb.toString();
    }

    public static String toActionsString(long actionBits, LongFunction<String> mappingFunction) {
        Assert.checkNotNullParam((String)"mappingFunction", mappingFunction);
        StringBuilder sb = new StringBuilder();
        if (actionBits == 0L) {
            return "";
        }
        long lb = Long.highestOneBit(actionBits);
        sb.append(mappingFunction.apply(lb));
        actionBits &= lb ^ 0xFFFFFFFFFFFFFFFFL;
        while (actionBits != 0L) {
            lb = Long.highestOneBit(actionBits);
            sb.append(',').append(mappingFunction.apply(lb));
            actionBits &= lb ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return sb.toString();
    }

    public static Iterable<Permission> iterable(PermissionCollection pc) {
        return () -> {
            final Enumeration<Permission> elements = pc.elements();
            return new Iterator<Permission>(){

                @Override
                public boolean hasNext() {
                    return elements.hasMoreElements();
                }

                @Override
                public Permission next() {
                    return (Permission)elements.nextElement();
                }
            };
        };
    }

    public static void forEachIn(PermissionCollection collection, Consumer<Permission> consumer) {
        Assert.checkNotNullParam((String)"collection", (Object)collection);
        Assert.checkNotNullParam((String)"consumer", consumer);
        Enumeration<Permission> elements = collection.elements();
        while (elements.hasMoreElements()) {
            consumer.accept(elements.nextElement());
        }
    }

    public static <P> P forEachIn(PermissionCollection collection, BiConsumer<P, Permission> consumer, P parameter) {
        Assert.checkNotNullParam((String)"collection", (Object)collection);
        Assert.checkNotNullParam((String)"consumer", consumer);
        Enumeration<Permission> elements = collection.elements();
        while (elements.hasMoreElements()) {
            consumer.accept(parameter, elements.nextElement());
        }
        return parameter;
    }

    public static boolean forEachIn(PermissionCollection collection, Predicate<Permission> predicate) {
        Assert.checkNotNullParam((String)"collection", (Object)collection);
        Assert.checkNotNullParam((String)"predicate", predicate);
        Enumeration<Permission> elements = collection.elements();
        while (elements.hasMoreElements()) {
            if (predicate.test(elements.nextElement())) continue;
            return false;
        }
        return true;
    }

    public static <P> boolean forEachIn(PermissionCollection collection, BiPredicate<P, Permission> predicate, P parameter) {
        Assert.checkNotNullParam((String)"collection", (Object)collection);
        Assert.checkNotNullParam((String)"predicate", predicate);
        Enumeration<Permission> elements = collection.elements();
        while (elements.hasMoreElements()) {
            if (predicate.test(parameter, elements.nextElement())) continue;
            return false;
        }
        return true;
    }

    public static PermissionCollection union(PermissionCollection pc1, PermissionCollection pc2) {
        Assert.checkNotNullParam((String)"pc1", (Object)pc1);
        Assert.checkNotNullParam((String)"pc2", (Object)pc2);
        if (!pc1.isReadOnly() || !pc2.isReadOnly()) {
            throw ElytronMessages.log.permissionCollectionMustBeReadOnly();
        }
        if (pc1.implies(ALL_PERMISSION) || pc2.implies(ALL_PERMISSION)) {
            return ALL_PERMISSIONS;
        }
        return new UnionPermissionCollection(pc1, pc2);
    }

    public static PermissionCollection intersection(PermissionCollection pc1, PermissionCollection pc2) {
        Assert.checkNotNullParam((String)"pc1", (Object)pc1);
        Assert.checkNotNullParam((String)"pc2", (Object)pc2);
        if (!pc1.isReadOnly() || !pc2.isReadOnly()) {
            throw ElytronMessages.log.permissionCollectionMustBeReadOnly();
        }
        if (pc1.implies(ALL_PERMISSION)) {
            return pc2;
        }
        if (pc2.implies(ALL_PERMISSION)) {
            return pc1;
        }
        return new IntersectionPermissionCollection(pc1, pc2);
    }

    public static boolean impliesAll(PermissionCollection collection, PermissionCollection testCollection) {
        return PermissionUtil.forEachIn(collection, PermissionCollection::implies, testCollection);
    }

    public static boolean equals(PermissionCollection pc1, PermissionCollection pc2) {
        return PermissionUtil.impliesAll(pc1, pc2) && PermissionUtil.impliesAll(pc2, pc1);
    }

    public static PermissionCollection addAll(PermissionCollection target, PermissionCollection source) {
        return PermissionUtil.forEachIn(source, PermissionCollection::add, target);
    }

    public static PermissionCollection addAll(PermissionCollection target, Collection<Permission> source) {
        source.forEach(target::add);
        return target;
    }

    public static PermissionCollection add(PermissionCollection target, Permission source) {
        Assert.checkNotNullParam((String)"target", (Object)target);
        if (source != null) {
            target.add(source);
        }
        return target;
    }

    public static Permission createPermission(ClassLoader classLoader, String className, String name, String actions) {
        Class<Permission> permissionClass;
        Assert.checkNotNullParam((String)"className", (Object)className);
        try {
            permissionClass = Class.forName(className, true, classLoader).asSubclass(Permission.class);
        }
        catch (ClassNotFoundException e) {
            throw ElytronMessages.log.permissionClassMissing(className, e);
        }
        return PermissionUtil.createPermission(permissionClass, name, actions);
    }

    public static Permission createPermission(Class<? extends Permission> permissionClass, String name, String actions) {
        Assert.checkNotNullParam((String)"permissionClass", permissionClass);
        Constructor<?> noArgs = null;
        Constructor<?> oneArg = null;
        Constructor<?> twoArg = null;
        for (Constructor<?> raw : permissionClass.getConstructors()) {
            Constructor<?> ctor = raw;
            Class<?>[] parameterTypes = ctor.getParameterTypes();
            if (parameterTypes.length == 2 && parameterTypes[0] == String.class && parameterTypes[1] == String.class) {
                twoArg = ctor;
                continue;
            }
            if (parameterTypes.length == 1 && parameterTypes[0] == String.class) {
                oneArg = ctor;
                continue;
            }
            if (parameterTypes.length != 0) continue;
            noArgs = ctor;
        }
        try {
            if (twoArg != null) {
                return (Permission)twoArg.newInstance(name, actions);
            }
            if (oneArg != null) {
                return (Permission)oneArg.newInstance(name);
            }
            if (noArgs != null) {
                return (Permission)noArgs.newInstance(new Object[0]);
            }
            throw ElytronMessages.log.noPermissionConstructor(permissionClass.getName());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InstantiationException e) {
            throw ElytronMessages.log.permissionInstantiation(permissionClass.getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (Error | RuntimeException cause) {
                throw cause;
            }
            catch (Throwable cause) {
                throw new UndeclaredThrowableException(cause);
            }
        }
    }

    public static PermissionCollection readOnlyCollectionOf(Permission ... permissions) {
        int length = permissions.length;
        if (length == 0) {
            return EMPTY_PERMISSION_COLLECTION;
        }
        Permissions collection = new Permissions();
        PermissionUtil.addAll((PermissionCollection)collection, Arrays.asList(permissions));
        collection.setReadOnly();
        return collection;
    }

    static {
        NO_PERMISSIONS = new Permission[0];
        Permissions permissions = new Permissions();
        permissions.add(ALL_PERMISSION);
        permissions.setReadOnly();
        ALL_PERMISSIONS = permissions;
        permissions = new Permissions();
        permissions.setReadOnly();
        EMPTY_PERMISSION_COLLECTION = permissions;
    }
}

