/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.external;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.util._private.Arrays2;

final class ExternalSaslServer
implements SaslServer {
    private final CallbackHandler cbh;
    private boolean complete;
    private String authorizationID;

    ExternalSaslServer(CallbackHandler cbh) {
        this.cbh = cbh;
    }

    @Override
    public String getMechanismName() {
        return "EXTERNAL";
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        String authorizationId;
        if (this.complete) {
            throw ElytronMessages.saslExternal.mechMessageAfterComplete().toSaslException();
        }
        this.complete = true;
        if (response.length == 0) {
            authorizationId = null;
        } else {
            authorizationId = Normalizer.normalize(new String(response, StandardCharsets.UTF_8), Normalizer.Form.NFKC);
            if (authorizationId.indexOf(0) != -1) {
                throw ElytronMessages.saslExternal.mechUserNameContainsInvalidCharacter().toSaslException();
            }
        }
        AuthorizeCallback authorizeCallback = new AuthorizeCallback(null, authorizationId);
        try {
            this.cbh.handle(Arrays2.of(authorizeCallback));
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException e) {
            throw ElytronMessages.saslExternal.mechAuthorizationFailed((Throwable)e).toSaslException();
        }
        catch (UnsupportedCallbackException e) {
            throw ElytronMessages.saslExternal.mechAuthorizationFailed((Throwable)e).toSaslException();
        }
        if (!authorizeCallback.isAuthorized()) {
            throw ElytronMessages.saslExternal.mechAuthorizationFailed(null, authorizationId).toSaslException();
        }
        this.authorizationID = authorizeCallback.getAuthorizedID();
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public String getAuthorizationID() {
        if (!this.complete) {
            throw ElytronMessages.saslExternal.mechAuthenticationNotComplete();
        }
        return this.authorizationID;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.complete) {
            throw ElytronMessages.saslExternal.mechNoSecurityLayer();
        }
        throw ElytronMessages.saslExternal.mechAuthenticationNotComplete();
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.complete) {
            throw ElytronMessages.saslExternal.mechNoSecurityLayer();
        }
        throw ElytronMessages.saslExternal.mechAuthenticationNotComplete();
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (this.complete) {
            return null;
        }
        throw ElytronMessages.saslExternal.mechAuthenticationNotComplete();
    }

    @Override
    public void dispose() throws SaslException {
    }
}

