/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.scram;

import java.io.IOException;
import java.security.Provider;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.ChannelBindingCallback;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism.scram.ScramMechanism;
import org.wildfly.security.sasl.scram.ScramSaslServer;
import org.wildfly.security.sasl.scram.ScramUtil;
import org.wildfly.security.util.ProviderUtil;

public final class ScramSaslServerFactory
implements SaslServerFactory {
    private final Supplier<Provider[]> providers;

    public ScramSaslServerFactory() {
        this.providers = ProviderUtil.INSTALLED_PROVIDERS;
    }

    public ScramSaslServerFactory(Provider provider) {
        this.providers = () -> new Provider[]{provider};
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        Assert.checkNotNullParam((String)"cbh", (Object)cbh);
        if (props == null) {
            props = Collections.emptyMap();
        }
        ChannelBindingCallback callback = new ChannelBindingCallback();
        try {
            cbh.handle(new Callback[]{callback});
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException e) {
            throw ElytronMessages.saslScram.mechFailedToDetermineChannelBindingStatus((Exception)e).toSaslException();
        }
        catch (UnsupportedCallbackException e) {
            // empty catch block
        }
        String bindingType = callback.getBindingType();
        byte[] bindingData = callback.getBindingData();
        boolean bindingOk = bindingType != null && bindingData != null;
        boolean bindingRequired = "true".equals(props.get("wildfly.sasl.channel-binding-required"));
        int minimumIterationCount = ScramUtil.getIntProperty(props, "wildfly.sasl.scram.min-iteration-count", 4096);
        int maximumIterationCount = ScramUtil.getIntProperty(props, "wildfly.sasl.scram.max-iteration-count", 32768);
        try {
            switch (mechanism) {
                case "SCRAM-SHA-1-PLUS": {
                    if (!bindingOk) {
                        return null;
                    }
                    return new ScramSaslServer(mechanism, protocol, serverName, cbh, ScramMechanism.SCRAM_SHA_1_PLUS.createServer(cbh, ScramUtil.getSecureRandom(props), callback, minimumIterationCount, maximumIterationCount, this.providers), callback);
                }
                case "SCRAM-SHA-1": {
                    if (bindingRequired) {
                        return null;
                    }
                    return new ScramSaslServer(mechanism, protocol, serverName, cbh, ScramMechanism.SCRAM_SHA_1.createServer(cbh, ScramUtil.getSecureRandom(props), callback, minimumIterationCount, maximumIterationCount, this.providers), callback);
                }
                case "SCRAM-SHA-256-PLUS": {
                    if (!bindingOk) {
                        return null;
                    }
                    return new ScramSaslServer(mechanism, protocol, serverName, cbh, ScramMechanism.SCRAM_SHA_256_PLUS.createServer(cbh, ScramUtil.getSecureRandom(props), callback, minimumIterationCount, maximumIterationCount, this.providers), callback);
                }
                case "SCRAM-SHA-256": {
                    if (bindingRequired) {
                        return null;
                    }
                    return new ScramSaslServer(mechanism, protocol, serverName, cbh, ScramMechanism.SCRAM_SHA_256.createServer(cbh, ScramUtil.getSecureRandom(props), callback, minimumIterationCount, maximumIterationCount, this.providers), callback);
                }
                case "SCRAM-SHA-384-PLUS": {
                    if (!bindingOk) {
                        return null;
                    }
                    return new ScramSaslServer(mechanism, protocol, serverName, cbh, ScramMechanism.SCRAM_SHA_384_PLUS.createServer(cbh, ScramUtil.getSecureRandom(props), callback, minimumIterationCount, maximumIterationCount, this.providers), callback);
                }
                case "SCRAM-SHA-384": {
                    if (bindingRequired) {
                        return null;
                    }
                    return new ScramSaslServer(mechanism, protocol, serverName, cbh, ScramMechanism.SCRAM_SHA_384.createServer(cbh, ScramUtil.getSecureRandom(props), callback, minimumIterationCount, maximumIterationCount, this.providers), callback);
                }
                case "SCRAM-SHA-512-PLUS": {
                    if (!bindingOk) {
                        return null;
                    }
                    return new ScramSaslServer(mechanism, protocol, serverName, cbh, ScramMechanism.SCRAM_SHA_512_PLUS.createServer(cbh, ScramUtil.getSecureRandom(props), callback, minimumIterationCount, maximumIterationCount, this.providers), callback);
                }
                case "SCRAM-SHA-512": {
                    if (bindingRequired) {
                        return null;
                    }
                    return new ScramSaslServer(mechanism, protocol, serverName, cbh, ScramMechanism.SCRAM_SHA_512.createServer(cbh, ScramUtil.getSecureRandom(props), callback, minimumIterationCount, maximumIterationCount, this.providers), callback);
                }
            }
            return null;
        }
        catch (AuthenticationMechanismException e) {
            throw e.toSaslException();
        }
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        if (props != null && !"true".equals(props.get("wildfly.sasl.mechanism-query-all")) && "true".equals(props.get("wildfly.sasl.channel-binding-required"))) {
            return new String[]{"SCRAM-SHA-512-PLUS", "SCRAM-SHA-384-PLUS", "SCRAM-SHA-256-PLUS", "SCRAM-SHA-1-PLUS"};
        }
        return new String[]{"SCRAM-SHA-512-PLUS", "SCRAM-SHA-384-PLUS", "SCRAM-SHA-256-PLUS", "SCRAM-SHA-1-PLUS", "SCRAM-SHA-512", "SCRAM-SHA-384", "SCRAM-SHA-256", "SCRAM-SHA-1"};
    }
}

