/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.sasl.util.SaslFactories;
import org.wildfly.security.util.ProviderUtil;

public final class SecurityProviderSaslClientFactory
implements SaslClientFactory {
    private static final String SERVICE_TYPE = SaslClientFactory.class.getSimpleName();
    private final Supplier<Provider[]> providerSupplier;

    public SecurityProviderSaslClientFactory(Supplier<Provider[]> providerSupplier) {
        this.providerSupplier = providerSupplier;
    }

    public SecurityProviderSaslClientFactory() {
        this(ProviderUtil.INSTALLED_PROVIDERS);
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        BiPredicate<String, Provider> mechFilter = SaslFactories.getProviderFilterPredicate(props);
        class Pair {
            final Provider provider;
            final SaslClientFactory saslClientFactory;

            Pair(Provider provider, SaslClientFactory saslClientFactory) {
                this.provider = provider;
                this.saslClientFactory = saslClientFactory;
            }
        }
        ArrayList<Pair> clientFactoryList = new ArrayList<Pair>();
        for (Provider currentProvider : this.providerSupplier.get()) {
            Set<Provider.Service> services;
            if (currentProvider == null || (services = currentProvider.getServices()) == null) continue;
            for (Provider.Service service : currentProvider.getServices()) {
                if (!SERVICE_TYPE.equals(service.getType())) continue;
                try {
                    clientFactoryList.add(new Pair(currentProvider, (SaslClientFactory)service.newInstance(null)));
                }
                catch (ClassCastException | InvalidParameterException | NoSuchAlgorithmException e) {
                    ElytronMessages.log.debug((Object)"Unable to create instance", (Throwable)e);
                }
            }
        }
        String[] mechArray = new String[1];
        String[] stringArray = mechanisms;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String mechanism;
            mechArray[0] = mechanism = stringArray[i];
            for (Pair pair : clientFactoryList) {
                SaslClient saslClient;
                String[] filtered = SaslFactories.filterMechanismsByProvider(mechArray, 0, 0, pair.provider, mechFilter);
                if (filtered.length <= 0 || (saslClient = pair.saslClientFactory.createSaslClient(mechArray, authorizationId, protocol, serverName, props, cbh)) == null) continue;
                if (ElytronMessages.log.isTraceEnabled()) {
                    ElytronMessages.log.tracef("Created SaslClient for mechanism %s, using Provider %s and protocol %s", (Object)saslClient.getMechanismName(), (Object)pair.provider.getName(), (Object)protocol);
                }
                return saslClient;
            }
        }
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("No %s provided by providers in %s: %s", (Object)SERVICE_TYPE, (Object)this.getClass().getSimpleName(), (Object)Arrays.toString(this.providerSupplier.get()));
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        BiPredicate<String, Provider> mechFilter = SaslFactories.getProviderFilterPredicate(props);
        LinkedHashSet names = new LinkedHashSet();
        for (Provider currentProvider : this.providerSupplier.get()) {
            Set<Provider.Service> services = currentProvider.getServices();
            if (services == null) continue;
            for (Provider.Service service : services) {
                if (!SERVICE_TYPE.equals(service.getType())) continue;
                try {
                    String[] mechanismNames = ((SaslClientFactory)service.newInstance(null)).getMechanismNames(props);
                    Collections.addAll(names, SaslFactories.filterMechanismsByProvider(mechanismNames, 0, 0, currentProvider, mechFilter));
                }
                catch (ClassCastException | InvalidParameterException | NoSuchAlgorithmException e) {
                    ElytronMessages.log.debug((Object)"Unable to create instance", (Throwable)e);
                }
            }
        }
        if (names.size() == 0 && ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("No %s provided by providers in %s: %s", (Object)SERVICE_TYPE, (Object)this.getClass().getSimpleName(), (Object)Arrays.toString(this.providerSupplier.get()));
        }
        return names.toArray(new String[names.size()]);
    }
}

