/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.net.Socket;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.credential.X509CertificateChainCredential;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;
import org.wildfly.security.ssl.WrappingX509ExtendedTrustManager;
import org.wildfly.security.x500.util.X500PrincipalUtil;

class SecurityDomainTrustManager
extends X509ExtendedTrustManager {
    private final X509ExtendedTrustManager delegate;
    private final SecurityDomain securityDomain;
    private final boolean authenticationOptional;
    private final MechanismConfigurationSelector mechanismConfigurationSelector;

    SecurityDomainTrustManager(X509ExtendedTrustManager delegate, SecurityDomain securityDomain, boolean authenticationOptional, MechanismConfigurationSelector mechanismConfigurationSelector) {
        this.delegate = delegate;
        this.securityDomain = securityDomain;
        this.authenticationOptional = authenticationOptional;
        this.mechanismConfigurationSelector = mechanismConfigurationSelector;
    }

    SecurityDomainTrustManager(X509TrustManager delegate, SecurityDomain securityDomain, boolean authenticationOptional, MechanismConfigurationSelector mechanismConfigurationSelector) {
        this(delegate instanceof X509ExtendedTrustManager ? (X509ExtendedTrustManager)delegate : new WrappingX509ExtendedTrustManager(delegate), securityDomain, authenticationOptional, mechanismConfigurationSelector);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType, socket);
        this.doClientTrustCheck(chain, authType, ((SSLSocket)socket).getHandshakeSession());
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType, sslEngine);
        this.doClientTrustCheck(chain, authType, sslEngine.getHandshakeSession());
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType);
        this.doClientTrustCheck(chain, authType, null);
    }

    private void doClientTrustCheck(X509Certificate[] chain, String authType, SSLSession handshakeSession) throws CertificateException {
        Assert.checkNotNullParam((String)"chain", (Object)chain);
        Assert.checkNotNullParam((String)"authType", (Object)authType);
        if (chain.length == 0) {
            throw ElytronMessages.log.emptyChainNotTrusted();
        }
        X500Principal principal = X500PrincipalUtil.asX500Principal(chain[0].getSubjectX500Principal());
        if (principal == null) {
            throw ElytronMessages.log.notTrusted(null);
        }
        try (ServerAuthenticationContext authenticationContext = this.securityDomain.createNewAuthenticationContext(this.mechanismConfigurationSelector);){
            X509PeerCertificateChainEvidence evidence;
            authenticationContext.setAuthenticationPrincipal(principal);
            if (!authenticationContext.exists()) {
                if (this.authenticationOptional) {
                    ElytronMessages.log.tracef("Credential validation failed: no identity found for principal [%s], ignoring as authentication is optional", (Object)principal);
                    return;
                }
                throw ElytronMessages.log.notTrusted((Principal)principal);
            }
            if (authenticationContext.getCredentialAcquireSupport(X509CertificateChainCredential.class).mayBeSupported()) {
                X509CertificateChainCredential credential = authenticationContext.getCredential(X509CertificateChainCredential.class);
                if (credential == null) {
                    if (this.authenticationOptional) {
                        ElytronMessages.log.tracef("Credential validation failed: no trusted certificate found for principal [%s], ignoring as authentication is optional", (Object)principal);
                        return;
                    }
                    throw ElytronMessages.log.notTrusted((Principal)principal);
                }
                if (!credential.getFirstCertificate().equals(chain[0])) {
                    if (this.authenticationOptional) {
                        ElytronMessages.log.tracef("Credential validation failed: certificate does not match for principal [%s], ignoring as authentication is optional", (Object)principal);
                        return;
                    }
                    throw ElytronMessages.log.notTrusted((Principal)principal);
                }
            } else if (authenticationContext.getEvidenceVerifySupport(X509PeerCertificateChainEvidence.class).mayBeSupported() && !authenticationContext.verifyEvidence(evidence = new X509PeerCertificateChainEvidence(chain))) {
                if (this.authenticationOptional) {
                    ElytronMessages.log.tracef("Credential validation failed: no trusted certificate found for principal [%s], ignoring as authentication is optional", (Object)principal);
                    return;
                }
                throw ElytronMessages.log.notTrusted((Principal)principal);
            }
            if (!authenticationContext.authorize()) {
                if (this.authenticationOptional) {
                    ElytronMessages.log.tracef("Credential validation failed: identity is not authorized principal [%s], ignoring as authentication is optional", (Object)principal);
                    return;
                }
                throw ElytronMessages.log.notTrusted((Principal)principal);
            }
            ElytronMessages.log.tracef("Authentication succeed for principal [%s]", (Object)principal);
            authenticationContext.succeed();
            if (handshakeSession != null) {
                handshakeSession.putValue("org.wildfly.security.ssl.identity", authenticationContext.getAuthorizedIdentity());
            }
        }
        catch (RealmUnavailableException e) {
            throw ElytronMessages.log.notTrustedRealmProblem(e, (Principal)principal);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType, sslEngine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }
}

