/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.text.Normalizer;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.wildfly.common.Assert;
import org.wildfly.common.codec.Alphabet;
import org.wildfly.common.codec.Base32Alphabet;
import org.wildfly.common.codec.Base64Alphabet;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security._private.ElytronMessages;

public final class PasswordBasedEncryptionUtil {
    private static final char PAD = '_';
    private static final String REGEX = "^_{0,2}[0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz./]*$";
    private static final String DEFAULT_PICKETBOX_ALGORITHM = "PBEWithMD5AndDES";
    private static final String DEFAULT_PICKETBOX_INITIAL_KEY_MATERIAL = "somearbitrarycrazystringthatdoesnotmatter";
    private static final String DEFAULT_PBE_ALGORITHM = "PBEWithHmacSHA1andAES_128";
    private final Cipher cipher;
    private final AlgorithmParameters algorithmParameters;
    private final Alphabet alphabet;
    private final boolean picketBoxCompatibility;
    private final boolean usePadding;
    public static final Base64Alphabet PICKETBOX_COMPATIBILITY = new Base64Alphabet(false){

        public int encode(int val) {
            if (val <= 9) {
                return 48 + val;
            }
            if (val <= 35) {
                return 65 + val - 10;
            }
            if (val <= 61) {
                return 97 + val - 36;
            }
            if (val == 62) {
                return 46;
            }
            assert (val == 63);
            return 47;
        }

        public int decode(int codePoint) {
            if (48 <= codePoint && codePoint <= 57) {
                return codePoint - 48;
            }
            if (65 <= codePoint && codePoint <= 90) {
                return codePoint - 65 + 10;
            }
            if (97 <= codePoint && codePoint <= 122) {
                return codePoint - 97 + 36;
            }
            if (codePoint == 46) {
                return 62;
            }
            if (codePoint == 47) {
                return 63;
            }
            return -1;
        }
    };

    PasswordBasedEncryptionUtil(Cipher cipher, AlgorithmParameters algorithmParameters, Alphabet alphabet, boolean usePadding, boolean picketBoxCompatibility) {
        this.cipher = cipher;
        this.alphabet = alphabet;
        this.algorithmParameters = algorithmParameters;
        this.usePadding = usePadding;
        this.picketBoxCompatibility = picketBoxCompatibility;
    }

    PasswordBasedEncryptionUtil(Cipher cipher, AlgorithmParameters algorithmParameters, Alphabet alphabet) {
        this(cipher, algorithmParameters, alphabet, false, false);
    }

    public String encryptAndEncode(char[] payload) throws GeneralSecurityException {
        return this.encodeUsingAlphabet(this.encrypt(PasswordBasedEncryptionUtil.charArrayEncode(payload)));
    }

    public char[] decodeAndDecrypt(String encodedPayload) throws GeneralSecurityException {
        return PasswordBasedEncryptionUtil.byteArrayDecode(this.decrypt(this.decodeUsingAlphabet(encodedPayload)));
    }

    public AlgorithmParameters getAlgorithmParameters() {
        return this.algorithmParameters;
    }

    public String getEncodedIV() {
        if (this.algorithmParameters != null) {
            try {
                PBEParameterSpec spec = this.algorithmParameters.getParameterSpec(PBEParameterSpec.class);
                AlgorithmParameterSpec algSpec = spec.getParameterSpec();
                if (algSpec instanceof IvParameterSpec) {
                    return this.encodeUsingAlphabet(((IvParameterSpec)algSpec).getIV());
                }
            }
            catch (InvalidParameterSpecException e) {
                return null;
            }
        }
        return null;
    }

    private byte[] decodeUsingAlphabet(String payload) {
        if (this.picketBoxCompatibility) {
            return PasswordBasedEncryptionUtil.picketBoxBase64Decode(payload);
        }
        ByteIterator byteIterator = PasswordBasedEncryptionUtil.isBase64(this.alphabet) ? CodePointIterator.ofString((String)payload).base64Decode(PasswordBasedEncryptionUtil.getAlphabet64(this.alphabet), this.usePadding) : CodePointIterator.ofString((String)payload).base32Decode(PasswordBasedEncryptionUtil.getAlphabet32(this.alphabet));
        return byteIterator.drain();
    }

    private String encodeUsingAlphabet(byte[] payload) {
        if (this.picketBoxCompatibility) {
            return this.picketBoxBased64Encode(payload);
        }
        CodePointIterator codePointIterator = PasswordBasedEncryptionUtil.isBase64(this.alphabet) ? ByteIterator.ofBytes((byte[])payload).base64Encode(PasswordBasedEncryptionUtil.getAlphabet64(this.alphabet), this.usePadding) : ByteIterator.ofBytes((byte[])payload).base32Encode(PasswordBasedEncryptionUtil.getAlphabet32(this.alphabet));
        return codePointIterator.drainToString();
    }

    private static boolean isBase64(Alphabet alphabet) {
        return alphabet instanceof Base64Alphabet;
    }

    private static Base64Alphabet getAlphabet64(Alphabet alphabet) {
        return (Base64Alphabet)alphabet;
    }

    private static Base32Alphabet getAlphabet32(Alphabet alphabet) {
        return (Base32Alphabet)alphabet;
    }

    private byte[] encrypt(byte[] payload) throws GeneralSecurityException {
        return this.cipher.doFinal(payload);
    }

    private byte[] decrypt(byte[] payload) throws GeneralSecurityException {
        return this.cipher.doFinal(payload);
    }

    private static char[] byteArrayDecode(byte[] buffer) {
        return new String(buffer, StandardCharsets.UTF_8).toCharArray();
    }

    private static byte[] charArrayEncode(char[] buffer) {
        return Normalizer.normalize(new String(buffer), Normalizer.Form.NFKC).getBytes(StandardCharsets.UTF_8);
    }

    private static byte[] picketBoxBase64Decode(String picketBoxBase64) {
        if (picketBoxBase64.length() == 0) {
            return new byte[0];
        }
        while (picketBoxBase64.length() % 4 != 0) {
            picketBoxBase64 = '_' + picketBoxBase64;
        }
        if (!picketBoxBase64.matches(REGEX)) {
            throw ElytronMessages.log.wrongBase64InPBCompatibleMode(picketBoxBase64);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(picketBoxBase64.length() * 3 / 4);
        int i = 0;
        int n = picketBoxBase64.length();
        while (i < n) {
            int pos0 = PICKETBOX_COMPATIBILITY.decode((int)picketBoxBase64.charAt(i++));
            int pos1 = PICKETBOX_COMPATIBILITY.decode((int)picketBoxBase64.charAt(i++));
            int pos2 = PICKETBOX_COMPATIBILITY.decode((int)picketBoxBase64.charAt(i++));
            int pos3 = PICKETBOX_COMPATIBILITY.decode((int)picketBoxBase64.charAt(i++));
            if (pos0 > -1) {
                bos.write((pos1 & 0x30) >>> 4 | pos0 << 2);
            }
            if (pos1 > -1) {
                bos.write((pos2 & 0x3C) >>> 2 | (pos1 & 0xF) << 4);
            }
            bos.write((pos2 & 3) << 6 | pos3);
        }
        return bos.toByteArray();
    }

    private String picketBoxBased64Encode(byte[] buffer) {
        int c;
        int len = buffer.length;
        int pos = len % 3;
        int b0 = 0;
        byte b1 = 0;
        byte b2 = 0;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        switch (pos) {
            case 2: {
                b1 = buffer[i++];
                c = (b0 & 3) << 4 | (b1 & 0xF0) >>> 4;
                sb.appendCodePoint(PICKETBOX_COMPATIBILITY.encode(c));
            }
            case 1: {
                b2 = buffer[i++];
                c = (b1 & 0xF) << 2 | (b2 & 0xC0) >>> 6;
                sb.appendCodePoint(PICKETBOX_COMPATIBILITY.encode(c));
                c = b2 & 0x3F;
                sb.appendCodePoint(PICKETBOX_COMPATIBILITY.encode(c));
            }
        }
        while (pos < len) {
            b0 = buffer[pos++];
            b1 = buffer[pos++];
            b2 = buffer[pos++];
            c = (b0 & 0xFC) >>> 2;
            sb.appendCodePoint(PICKETBOX_COMPATIBILITY.encode(c));
            c = (b0 & 3) << 4 | (b1 & 0xF0) >>> 4;
            sb.appendCodePoint(PICKETBOX_COMPATIBILITY.encode(c));
            c = (b1 & 0xF) << 2 | (b2 & 0xC0) >>> 6;
            sb.appendCodePoint(PICKETBOX_COMPATIBILITY.encode(c));
            c = b2 & 0x3F;
            sb.appendCodePoint(PICKETBOX_COMPATIBILITY.encode(c));
        }
        return sb.toString();
    }

    public static class Builder {
        private String keyAlgorithm;
        private String transformation;
        private String parametersAlgorithm;
        private int iteration = -1;
        private byte[] salt;
        private int keyLength = 0;
        private char[] password;
        private int cipherMode;
        private int cipherIteration = -1;
        private byte[] cipherSalt;
        private Provider provider;
        private Alphabet alphabet = Base64Alphabet.STANDARD;
        private boolean usePadding = false;
        private IvParameterSpec ivSpec;
        private String encodedIV;
        private AlgorithmParameters algorithmParameters;
        private boolean picketBoxCompatibility = false;

        public Builder password(char[] password) {
            this.password = password;
            return this;
        }

        public Builder password(String password) {
            this.password = password.toCharArray();
            return this;
        }

        public Builder iv(byte[] iv) {
            this.ivSpec = new IvParameterSpec(iv);
            return this;
        }

        public Builder iv(String encodedIV) {
            this.encodedIV = encodedIV;
            return this;
        }

        public Builder transformation(String transformation) {
            this.transformation = transformation;
            return this;
        }

        public Builder parametersAlgorithm(String parametersAlgorithm) {
            this.parametersAlgorithm = parametersAlgorithm;
            return this;
        }

        public Builder salt(String salt) {
            this.salt = salt.getBytes(StandardCharsets.UTF_8);
            return this;
        }

        public Builder salt(byte[] salt) {
            this.salt = salt;
            return this;
        }

        public Builder picketBoxCompatibility() {
            this.picketBoxCompatibility = true;
            return this;
        }

        public Builder encodingPadded() {
            this.usePadding = true;
            return this;
        }

        public Builder iteration(int iteration) {
            this.iteration = iteration;
            return this;
        }

        public Builder keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        public Builder keyLength(int keyLength) {
            this.keyLength = keyLength;
            return this;
        }

        public Builder cipherIteration(int cipherIteration) {
            this.cipherIteration = cipherIteration;
            return this;
        }

        public Builder cipherSalt(byte[] cipherSalt) {
            this.cipherSalt = cipherSalt;
            return this;
        }

        public Builder cipherSalt(String cipherSalt) {
            this.cipherSalt = cipherSalt.getBytes(StandardCharsets.UTF_8);
            return this;
        }

        public Builder provider(Provider provider) {
            this.provider = provider;
            return this;
        }

        public Builder provider(String providerName) {
            Assert.checkNotNullParam((String)"providerName", (Object)providerName);
            this.provider = Security.getProvider(providerName);
            if (this.provider == null) {
                throw ElytronMessages.log.securityProviderDoesnExist(providerName);
            }
            return this;
        }

        public Builder alphabet(Alphabet alphabet) {
            this.alphabet = alphabet;
            return this;
        }

        public Builder encryptMode() {
            this.cipherMode = 1;
            return this;
        }

        public Builder decryptMode() {
            this.cipherMode = 2;
            return this;
        }

        public Builder algorithmParameters(AlgorithmParameters algorithmParameters) {
            if (this.algorithmParameters == null) {
                this.algorithmParameters = algorithmParameters;
            }
            return this;
        }

        private Cipher createAndInitCipher(SecretKey secretKey) throws GeneralSecurityException {
            Cipher cipher;
            Cipher cipher2 = cipher = this.provider == null ? Cipher.getInstance(this.transformation) : Cipher.getInstance(this.transformation, this.provider);
            if (this.cipherMode == 1) {
                cipher.init(this.cipherMode, (Key)secretKey, Builder.generateAlgorithmParameters(this.parametersAlgorithm, this.cipherIteration, this.cipherSalt, null, this.provider));
                this.algorithmParameters = cipher.getParameters();
            } else if (this.algorithmParameters != null) {
                cipher.init(this.cipherMode, (Key)secretKey, this.algorithmParameters);
            } else {
                cipher.init(this.cipherMode, (Key)secretKey, Builder.generateAlgorithmParameters(this.parametersAlgorithm, this.cipherIteration, this.cipherSalt, this.ivSpec, this.provider));
            }
            return cipher;
        }

        private static AlgorithmParameters generateAlgorithmParameters(String algorithm, int iterationCount, byte[] salt, IvParameterSpec ivSpec, Provider provider) throws GeneralSecurityException {
            AlgorithmParameters tempParams = provider == null ? AlgorithmParameters.getInstance(algorithm) : AlgorithmParameters.getInstance(algorithm, provider);
            PBEParameterSpec pbeParameterSpec = ivSpec != null ? new PBEParameterSpec(salt, iterationCount, ivSpec) : new PBEParameterSpec(salt, iterationCount);
            tempParams.init(pbeParameterSpec);
            return tempParams;
        }

        private SecretKey deriveSecretKey() throws GeneralSecurityException {
            SecretKeyFactory secretKeyFactory;
            try {
                secretKeyFactory = this.provider != null ? SecretKeyFactory.getInstance(this.keyAlgorithm, this.provider) : SecretKeyFactory.getInstance(this.keyAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw ElytronMessages.log.noSuchKeyAlgorithm(this.keyAlgorithm, (GeneralSecurityException)e);
            }
            PBEKeySpec pbeKeySpec = this.keyLength == 0 ? new PBEKeySpec(this.password, this.salt, this.iteration) : new PBEKeySpec(this.password, this.salt, this.iteration, this.keyLength);
            SecretKey partialKey = secretKeyFactory.generateSecret(pbeKeySpec);
            return new SecretKeySpec(partialKey.getEncoded(), this.transformation);
        }

        public PasswordBasedEncryptionUtil build() throws GeneralSecurityException {
            if (this.picketBoxCompatibility) {
                this.alphabet = PICKETBOX_COMPATIBILITY;
                this.usePadding = false;
                this.keyAlgorithm = PasswordBasedEncryptionUtil.DEFAULT_PICKETBOX_ALGORITHM;
                this.password = PasswordBasedEncryptionUtil.DEFAULT_PICKETBOX_INITIAL_KEY_MATERIAL.toCharArray();
            }
            if (this.iteration <= -1) {
                throw ElytronMessages.log.iterationCountNotSpecified();
            }
            if (this.salt == null) {
                throw ElytronMessages.log.saltNotSpecified();
            }
            if (this.password == null || this.password.length == 0) {
                throw ElytronMessages.log.initialKeyNotSpecified();
            }
            if (this.keyAlgorithm == null) {
                this.keyAlgorithm = PasswordBasedEncryptionUtil.DEFAULT_PBE_ALGORITHM;
            }
            if (this.transformation == null) {
                this.transformation = this.keyAlgorithm;
            }
            if (this.parametersAlgorithm == null) {
                this.parametersAlgorithm = this.keyAlgorithm;
            }
            if (this.cipherSalt == null) {
                this.cipherSalt = this.salt;
            }
            if (this.cipherIteration == -1) {
                this.cipherIteration = this.iteration;
            }
            if (this.ivSpec == null && this.encodedIV != null) {
                ByteIterator byteIterator = PasswordBasedEncryptionUtil.isBase64(this.alphabet) ? CodePointIterator.ofString((String)this.encodedIV).base64Decode(PasswordBasedEncryptionUtil.getAlphabet64(this.alphabet), false) : CodePointIterator.ofString((String)this.encodedIV).base32Decode(PasswordBasedEncryptionUtil.getAlphabet32(this.alphabet), false);
                this.ivSpec = new IvParameterSpec(byteIterator.drain());
            }
            return new PasswordBasedEncryptionUtil(this.createAndInitCipher(this.deriveSecretKey()), this.algorithmParameters, this.alphabet, this.usePadding, this.picketBoxCompatibility);
        }
    }
}

