/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert.acme;

import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.asn1.ASN1Encodable;
import org.wildfly.security.x500.X500AttributeTypeAndValue;
import org.wildfly.security.x500.X500PrincipalBuilder;
import org.wildfly.security.x500.cert.SelfSignedX509CertificateAndSigningKey;
import org.wildfly.security.x500.cert.acme.Acme;
import org.wildfly.security.x500.cert.acme.AcmeResource;
import org.wildfly.security.x500.cert.util.KeyUtil;

public final class AcmeAccount {
    private String[] contactUrls;
    private boolean termsOfServiceAgreed;
    private String serverUrl;
    private String stagingServerUrl;
    private PrivateKey privateKey;
    private X509Certificate certificate;
    private X500Principal dn;
    private String algHeader;
    private String signatureAlgorithm;
    private int keySize;
    private String keyAlgorithmName;
    private String accountUrl;
    private HashMap<AcmeResource, URL> resourceUrls = new HashMap(AcmeResource.values().length);
    private HashMap<AcmeResource, URL> stagingResourceUrls = new HashMap(AcmeResource.values().length);
    private byte[] nonce;

    private AcmeAccount(Builder builder) {
        this.contactUrls = builder.contactUrls;
        this.termsOfServiceAgreed = builder.termsOfServiceAgreed;
        this.serverUrl = builder.serverUrl;
        this.stagingServerUrl = builder.stagingServerUrl;
        this.privateKey = builder.privateKey;
        this.certificate = builder.certificate;
        this.algHeader = builder.algHeader;
        this.signatureAlgorithm = builder.signatureAlgorithm;
        this.keySize = builder.keySize;
        this.keyAlgorithmName = builder.keyAlgorithmName;
        this.dn = builder.dn;
    }

    public String[] getContactUrls() {
        return this.contactUrls;
    }

    public void setContactUrls(String[] contactUrls) {
        Assert.checkNotNullParam((String)"contactUrls", (Object)contactUrls);
        this.contactUrls = contactUrls;
    }

    public boolean isTermsOfServiceAgreed() {
        return this.termsOfServiceAgreed;
    }

    public void setTermsOfServiceAgreed(boolean termsOfServiceAgreed) {
        Assert.checkNotNullParam((String)"termsOfServiceAgreed", (Object)termsOfServiceAgreed);
        this.termsOfServiceAgreed = termsOfServiceAgreed;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getServerUrl(boolean staging) {
        if (staging) {
            return this.stagingServerUrl;
        }
        return this.serverUrl;
    }

    public String getStagingServerUrl() {
        return this.stagingServerUrl;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.certificate.getPublicKey();
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public X500Principal getDn() {
        return this.dn;
    }

    public String getAlgHeader() {
        return this.algHeader;
    }

    public Signature getSignature() {
        try {
            Signature signature = Signature.getInstance(this.signatureAlgorithm);
            signature.initSign(this.privateKey);
            return signature;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw ElytronMessages.acme.unableToCreateAcmeSignature((Exception)e);
        }
    }

    public int getKeySize() {
        return this.keySize;
    }

    public String getKeyAlgorithmName() {
        return this.keyAlgorithmName;
    }

    public String getAccountUrl() {
        return this.accountUrl;
    }

    public void setAccountUrl(String accountUrl) {
        Assert.checkNotNullParam((String)"accountUrl", (Object)accountUrl);
        this.accountUrl = accountUrl;
    }

    public URL getResourceUrl(AcmeResource resource, boolean staging) {
        Assert.checkNotNullParam((String)"resource", (Object)((Object)resource));
        return this.getResourceUrls(staging).get((Object)resource);
    }

    public Map<AcmeResource, URL> getResourceUrls(boolean staging) {
        return staging ? this.stagingResourceUrls : this.resourceUrls;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public void setNonce(byte[] nonce) {
        Assert.checkNotNullParam((String)"nonce", (Object)nonce);
        this.nonce = nonce;
    }

    public void changeCertificateAndPrivateKey(X509Certificate certificate, PrivateKey privateKey) {
        Assert.checkNotNullParam((String)"certificate", (Object)certificate);
        Assert.checkNotNullParam((String)"privateKey", (Object)privateKey);
        this.certificate = certificate;
        this.privateKey = privateKey;
        this.keySize = KeyUtil.getKeySize(privateKey);
        this.keyAlgorithmName = privateKey.getAlgorithm();
        this.signatureAlgorithm = KeyUtil.getDefaultCompatibleSignatureAlgorithmName(privateKey);
        this.algHeader = Acme.getAlgHeaderFromSignatureAlgorithm(this.signatureAlgorithm);
        this.dn = certificate.getSubjectX500Principal();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        public static final String DEFAULT_ACCOUNT_KEY_ALGORITHM_NAME = "RSA";
        public static final int DEFAULT_ACCOUNT_KEY_SIZE = 2048;
        public static final int DEFAULT_ACCOUNT_EC_KEY_SIZE = 256;
        static final String ACCOUNT_KEY_NAME = "account.key";
        private String[] contactUrls;
        private boolean termsOfServiceAgreed;
        private String serverUrl;
        private String stagingServerUrl;
        private PrivateKey privateKey;
        private X509Certificate certificate;
        private X500Principal dn;
        private String keyAlgorithmName;
        private int keySize = -1;
        private String algHeader;
        private String signatureAlgorithm;

        Builder() {
        }

        public Builder setContactUrls(String[] contactUrls) {
            Assert.checkNotNullParam((String)"contactUrls", (Object)contactUrls);
            this.contactUrls = contactUrls;
            return this;
        }

        public Builder setTermsOfServiceAgreed(boolean termsOfServiceAgreed) {
            Assert.checkNotNullParam((String)"termsOfServiceAgreed", (Object)termsOfServiceAgreed);
            this.termsOfServiceAgreed = termsOfServiceAgreed;
            return this;
        }

        public Builder setServerUrl(String serverUrl) {
            Assert.checkNotNullParam((String)"serverUrl", (Object)serverUrl);
            this.serverUrl = serverUrl;
            return this;
        }

        public Builder setStagingServerUrl(String stagingServerUrl) {
            Assert.checkNotNullParam((String)"stagingServerUrl", (Object)stagingServerUrl);
            this.stagingServerUrl = stagingServerUrl;
            return this;
        }

        public Builder setKeyAlgorithmName(String keyAlgorithmName) {
            Assert.checkNotNullParam((String)"keyAlgorithmName", (Object)keyAlgorithmName);
            this.keyAlgorithmName = keyAlgorithmName;
            return this;
        }

        public Builder setKeySize(int keySize) {
            this.keySize = keySize;
            return this;
        }

        public Builder setDn(X500Principal dn) {
            Assert.checkNotNullParam((String)"dn", (Object)dn);
            this.dn = dn;
            return this;
        }

        public Builder setKey(X509Certificate certificate, PrivateKey privateKey) {
            Assert.checkNotNullParam((String)"certificate", (Object)certificate);
            Assert.checkNotNullParam((String)"privateKey", (Object)privateKey);
            this.certificate = certificate;
            this.privateKey = privateKey;
            return this;
        }

        public AcmeAccount build() throws IllegalArgumentException {
            if (this.serverUrl == null) {
                throw ElytronMessages.log.noAcmeServerUrlGiven();
            }
            if (this.certificate != null && this.privateKey != null) {
                this.keySize = KeyUtil.getKeySize(this.privateKey);
                if (this.keySize == -1) {
                    throw ElytronMessages.acme.unableToDetermineKeySize();
                }
                this.keyAlgorithmName = this.privateKey.getAlgorithm();
                this.signatureAlgorithm = KeyUtil.getDefaultCompatibleSignatureAlgorithmName(this.privateKey);
                if (this.signatureAlgorithm == null) {
                    throw ElytronMessages.log.unableToDetermineDefaultCompatibleSignatureAlgorithmName(this.privateKey.getAlgorithm());
                }
                this.algHeader = Acme.getAlgHeaderFromSignatureAlgorithm(this.signatureAlgorithm);
                this.dn = this.certificate.getSubjectX500Principal();
            } else {
                if (this.keyAlgorithmName == null) {
                    this.keyAlgorithmName = DEFAULT_ACCOUNT_KEY_ALGORITHM_NAME;
                }
                if (this.dn == null) {
                    X500PrincipalBuilder principalBuilder = new X500PrincipalBuilder();
                    principalBuilder.addItem(X500AttributeTypeAndValue.create("2.5.4.3", ASN1Encodable.ofUtf8String(ACCOUNT_KEY_NAME)));
                    this.dn = principalBuilder.build();
                }
                if (this.keySize == -1) {
                    this.keySize = this.keyAlgorithmName.equals("EC") ? 256 : 2048;
                }
                try {
                    SelfSignedX509CertificateAndSigningKey certificateAndSigningKey = SelfSignedX509CertificateAndSigningKey.builder().setKeySize(this.keySize).setKeyAlgorithmName(this.keyAlgorithmName).setDn(this.dn).build();
                    this.privateKey = certificateAndSigningKey.getSigningKey();
                    this.certificate = certificateAndSigningKey.getSelfSignedCertificate();
                    this.signatureAlgorithm = KeyUtil.getDefaultCompatibleSignatureAlgorithmName(this.privateKey);
                    if (this.signatureAlgorithm == null) {
                        throw ElytronMessages.log.unableToDetermineDefaultCompatibleSignatureAlgorithmName(this.privateKey.getAlgorithm());
                    }
                    this.algHeader = Acme.getAlgHeaderFromSignatureAlgorithm(this.signatureAlgorithm);
                }
                catch (Exception e) {
                    throw ElytronMessages.acme.acmeAccountKeyPairGenerationFailed(e);
                }
            }
            return new AcmeAccount(this);
        }
    }
}

