/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.external;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.mechanism._private.MechanismUtil;

public class ExternalAuthenticationMechanism
implements HttpServerAuthenticationMechanism {
    private final CallbackHandler callbackHandler;

    ExternalAuthenticationMechanism(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public String getMechanismName() {
        return "EXTERNAL";
    }

    public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
        String remoteUser = request.getRemoteUser();
        if (remoteUser == null) {
            request.noAuthenticationInProgress();
            return;
        }
        if (this.authorize(remoteUser)) {
            this.succeed(request);
        } else {
            this.fail(request);
        }
    }

    private boolean authorize(String username) throws HttpAuthenticationException {
        AuthorizeCallback authorizeCallback = new AuthorizeCallback(username, username);
        try {
            MechanismUtil.handleCallbacks((ElytronMessages)ElytronMessages.httpExternal, (CallbackHandler)this.callbackHandler, (Callback[])new Callback[]{authorizeCallback});
            return authorizeCallback.isAuthorized();
        }
        catch (AuthenticationMechanismException e) {
            throw e.toHttpAuthenticationException();
        }
        catch (UnsupportedCallbackException e) {
            throw ElytronMessages.httpExternal.mechCallbackHandlerFailedForUnknownReason((Throwable)e).toHttpAuthenticationException();
        }
    }

    private void succeed(HttpServerRequest request) throws HttpAuthenticationException {
        try {
            MechanismUtil.handleCallbacks((ElytronMessages)ElytronMessages.httpExternal, (CallbackHandler)this.callbackHandler, (Callback[])new Callback[]{AuthenticationCompleteCallback.SUCCEEDED});
            request.authenticationComplete();
        }
        catch (AuthenticationMechanismException e) {
            throw e.toHttpAuthenticationException();
        }
        catch (UnsupportedCallbackException e) {
            throw ElytronMessages.httpExternal.mechCallbackHandlerFailedForUnknownReason((Throwable)e).toHttpAuthenticationException();
        }
    }

    private void fail(HttpServerRequest request) throws HttpAuthenticationException {
        try {
            MechanismUtil.handleCallbacks((ElytronMessages)ElytronMessages.httpExternal, (CallbackHandler)this.callbackHandler, (Callback[])new Callback[]{AuthenticationCompleteCallback.FAILED});
            request.authenticationFailed(ElytronMessages.httpExternal.authenticationFailed(), response -> response.setStatusCode(403));
        }
        catch (AuthenticationMechanismException e) {
            throw e.toHttpAuthenticationException();
        }
        catch (UnsupportedCallbackException e) {
            throw ElytronMessages.httpExternal.mechCallbackHandlerFailedForUnknownReason((Throwable)e).toHttpAuthenticationException();
        }
    }
}

