/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util.sso;

import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;
import java.util.function.Consumer;
import javax.net.ssl.HttpsURLConnection;
import org.wildfly.common.Assert;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.util.sso.DefaultSingleSignOnSession;
import org.wildfly.security.http.util.sso.ElytronMessages;
import org.wildfly.security.http.util.sso.SingleSignOn;
import org.wildfly.security.http.util.sso.SingleSignOnManager;
import org.wildfly.security.http.util.sso.SingleSignOnSession;
import org.wildfly.security.http.util.sso.SingleSignOnSessionContext;
import org.wildfly.security.http.util.sso.SingleSignOnSessionFactory;

public class DefaultSingleSignOnSessionFactory
implements SingleSignOnSessionFactory,
SingleSignOnSessionContext {
    private static final String DEFAULT_SIGNATURE_ALGORITHM = "SHA512withRSA";
    private final SingleSignOnManager manager;
    private final KeyPair keyPair;
    private final Consumer<HttpsURLConnection> logoutConnectionConfigurator;

    public DefaultSingleSignOnSessionFactory(SingleSignOnManager manager, KeyPair keyPair) {
        this(manager, keyPair, connection -> {});
    }

    public DefaultSingleSignOnSessionFactory(SingleSignOnManager manager, KeyPair keyPair, Consumer<HttpsURLConnection> logoutConnectionConfigurator) {
        this.manager = (SingleSignOnManager)Assert.checkNotNullParam((String)"manager", (Object)manager);
        this.keyPair = (KeyPair)Assert.checkNotNullParam((String)"keyPair", (Object)keyPair);
        this.logoutConnectionConfigurator = (Consumer)Assert.checkNotNullParam((String)"logoutConnectionConfigurator", logoutConnectionConfigurator);
    }

    @Override
    public SingleSignOnSession find(String id, HttpServerRequest request) {
        Assert.checkNotNullParam((String)"id", (Object)id);
        Assert.checkNotNullParam((String)"request", (Object)request);
        SingleSignOn sso = this.manager.find(id);
        return sso != null ? new DefaultSingleSignOnSession((SingleSignOnSessionContext)this, request, sso) : null;
    }

    @Override
    public SingleSignOnSession create(HttpServerRequest request, String mechanismName) {
        Assert.checkNotNullParam((String)"request", (Object)request);
        Assert.checkNotNullParam((String)"mechanismName", (Object)mechanismName);
        return new DefaultSingleSignOnSession((SingleSignOnSessionContext)this, request, mechanismName);
    }

    @Override
    public SingleSignOnManager getSingleSignOnManager() {
        return this.manager;
    }

    @Override
    public String createLogoutParameter(String sessionId) {
        try {
            Signature signature = Signature.getInstance(DEFAULT_SIGNATURE_ALGORITHM);
            signature.initSign(this.keyPair.getPrivate());
            Base64.Encoder urlEncoder = Base64.getUrlEncoder();
            return sessionId + "." + ByteIterator.ofBytes((byte[])urlEncoder.encode(ByteIterator.ofBytes((byte[])sessionId.getBytes(StandardCharsets.UTF_8)).sign(signature).drain())).asUtf8String().drainToString();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String verifyLogoutParameter(String parameter) {
        String[] parts = parameter.split("\\.");
        if (parts.length != 2) {
            throw new IllegalArgumentException(parameter);
        }
        try {
            String localSessionId = ByteIterator.ofBytes((byte[])parts[0].getBytes(StandardCharsets.UTF_8)).asUtf8String().drainToString();
            Signature signature = Signature.getInstance(DEFAULT_SIGNATURE_ALGORITHM);
            signature.initVerify(this.keyPair.getPublic());
            signature.update(localSessionId.getBytes(StandardCharsets.UTF_8));
            Base64.Decoder urlDecoder = Base64.getUrlDecoder();
            if (!ByteIterator.ofBytes((byte[])urlDecoder.decode(parts[1].getBytes(StandardCharsets.UTF_8))).verify(signature)) {
                throw ElytronMessages.log.httpMechSsoInvalidLogoutMessage(localSessionId);
            }
            return localSessionId;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (SignatureException e) {
            throw new IllegalArgumentException(parameter, e);
        }
    }

    @Override
    public void configureLogoutConnection(HttpURLConnection connection) {
        if (connection.getURL().getProtocol().equalsIgnoreCase("https")) {
            HttpsURLConnection secureConnection = (HttpsURLConnection)connection;
            this.logoutConnectionConfigurator.accept(secureConnection);
        }
    }
}

