package org.wildfly.security.authz.jacc;

import java.util.Locale;
import java.security.ProtectionDomain;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.SecurityException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.security.Permission;
import java.lang.Throwable;
import javax.security.jacc.PolicyContextException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-03-22T11:03:14+0000")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String readOnlyPermissionCollection = "ELY03018: Cannot add permissions to a read-only permission collection";
    protected String readOnlyPermissionCollection$str() {
        return readOnlyPermissionCollection;
    }
    @Override
    public final SecurityException readOnlyPermissionCollection() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), readOnlyPermissionCollection$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void authzFailedToCheckPermission(final ProtectionDomain domain, final Permission permission, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, authzFailedToCheckPermission$str(), domain, permission);
    }
    private static final String authzFailedToCheckPermission = "ELY08500: Failed to check permissions for protection domain [%s] and permission [%s].";
    protected String authzFailedToCheckPermission$str() {
        return authzFailedToCheckPermission;
    }
    private static final String authzInvalidStateForOperation = "ELY08501: Invalid state [%s] for operation.";
    protected String authzInvalidStateForOperation$str() {
        return authzInvalidStateForOperation;
    }
    @Override
    public final UnsupportedOperationException authzInvalidStateForOperation(final String actualState) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), authzInvalidStateForOperation$str(), actualState));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authzLinkSamePolicyConfiguration = "ELY08502: Can't link policy configuration [%s] to itself.";
    protected String authzLinkSamePolicyConfiguration$str() {
        return authzLinkSamePolicyConfiguration;
    }
    @Override
    public final IllegalArgumentException authzLinkSamePolicyConfiguration(final String contextID) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), authzLinkSamePolicyConfiguration$str(), contextID));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authzContextIdentifierNotSet = "ELY08503: ContextID not set. Check if the context id was set using PolicyContext.setContextID.";
    protected String authzContextIdentifierNotSet$str() {
        return authzContextIdentifierNotSet;
    }
    @Override
    public final IllegalStateException authzContextIdentifierNotSet() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), authzContextIdentifierNotSet$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authzInvalidPolicyContextIdentifier = "ELY08504: Invalid policy context identifier [%s].";
    protected String authzInvalidPolicyContextIdentifier$str() {
        return authzInvalidPolicyContextIdentifier;
    }
    @Override
    public final IllegalArgumentException authzInvalidPolicyContextIdentifier(final String contextID) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), authzInvalidPolicyContextIdentifier$str(), contextID));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authzUnableToObtainPolicyConfiguration = "ELY08505: Could not obtain PolicyConfiguration for contextID [%s].";
    protected String authzUnableToObtainPolicyConfiguration$str() {
        return authzUnableToObtainPolicyConfiguration;
    }
    @Override
    public final PolicyContextException authzUnableToObtainPolicyConfiguration(final String contextId, final Throwable cause) {
        final PolicyContextException result = new PolicyContextException(String.format(getLoggingLocale(), authzUnableToObtainPolicyConfiguration$str(), contextId), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authzPolicyConfigurationNotInService = "ELY08506: Policy configuration with contextID [%s] is not in service state.";
    protected String authzPolicyConfigurationNotInService$str() {
        return authzPolicyConfigurationNotInService;
    }
    @Override
    public final IllegalStateException authzPolicyConfigurationNotInService(final String contextID) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), authzPolicyConfigurationNotInService$str(), contextID));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void authzCouldNotObtainSecurityIdentity(final Throwable cause) {
        super.log.logf(FQCN, DEBUG, cause, authzCouldNotObtainSecurityIdentity$str());
    }
    private static final String authzCouldNotObtainSecurityIdentity = "ELY08508: Could not obtain authorized identity.";
    protected String authzCouldNotObtainSecurityIdentity$str() {
        return authzCouldNotObtainSecurityIdentity;
    }
}
