package org.wildfly.security.auth.realm;

import java.util.Locale;
import java.nio.file.Path;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.realm.IntegrityException;
import org.wildfly.security.auth.server.RealmUnavailableException;
import java.lang.String;
import java.io.IOException;
import java.security.KeyStoreException;
import org.jboss.logging.Logger;
import java.lang.Exception;
import javax.security.auth.callback.Callback;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Class;
import javax.security.auth.callback.UnsupportedCallbackException;
import java.util.Arrays;
import java.security.Principal;
import java.lang.IllegalArgumentException;
import java.util.NoSuchElementException;


import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2023-05-23T16:52:41-0400")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String noRealmFoundInProperties$str() {
        return "ELY01006: No realm name found in users property file - non-plain-text users file must contain \"#$REALM_NAME=RealmName$\" line";
    }
    @Override
    public final RealmUnavailableException noRealmFoundInProperties() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), noRealmFoundInProperties$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void debugInfoJaasAuthenticationFailure(final Principal principal, final Throwable cause) {
        super.log.logf(FQCN, DEBUG, cause, debugInfoJaasAuthenticationFailure$str(), principal);
    }
    protected String debugInfoJaasAuthenticationFailure$str() {
        return "ELY01007: JAAS authentication failed for principal %s";
    }
    protected String failedToCreateLoginContext$str() {
        return "ELY01008: Failed to create login context";
    }
    @Override
    public final RealmUnavailableException failedToCreateLoginContext(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), failedToCreateLoginContext$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToInstantiateCustomHandler$str() {
        return "ELY01009: Failed to instantiate custom CallbackHandler";
    }
    @Override
    public final RealmUnavailableException failedToInstantiateCustomHandler(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), failedToInstantiateCustomHandler$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fileSystemRealmFailedToOpen$str() {
        return "ELY01012: Filesystem-backed realm unexpectedly failed to open path \"%s\" for identity name \"%s\"";
    }
    @Override
    public final RealmUnavailableException fileSystemRealmFailedToOpen(final Path path, final String finalName, final IOException cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmFailedToOpen$str(), path, finalName), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fileSystemRealmFailedToRead$str() {
        return "ELY01013: Filesystem-backed realm unexpectedly failed to read path \"%s\" for identity name \"%s\"";
    }
    @Override
    public final RealmUnavailableException fileSystemRealmFailedToRead(final Path path, final String finalName, final Exception cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmFailedToRead$str(), path, finalName), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fileSystemRealmInvalidContent$str() {
        return "ELY01015: Filesystem-backed realm encountered invalid file content in path \"%s\" line %d for identity name \"%s\"";
    }
    @Override
    public final RealmUnavailableException fileSystemRealmInvalidContent(final Path path, final int lineNumber, final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmInvalidContent$str(), path, lineNumber, name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fileSystemRealmMissingAttribute$str() {
        return "ELY01016: Filesystem-backed realm encountered missing required attribute \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    }
    @Override
    public final RealmUnavailableException fileSystemRealmMissingAttribute(final String attribute, final Path path, final int lineNumber, final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmMissingAttribute$str(), attribute, path, lineNumber, name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fileSystemRealmInvalidPasswordFormat$str() {
        return "ELY01017: Filesystem-backed realm encountered invalid password format \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    }
    @Override
    public final RealmUnavailableException fileSystemRealmInvalidPasswordFormat(final String format, final Path path, final int lineNumber, final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmInvalidPasswordFormat$str(), format, path, lineNumber, name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fileSystemRealmInvalidPasswordAlgorithm$str() {
        return "ELY01018: Filesystem-backed realm encountered invalid password algorithm \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    }
    @Override
    public final RealmUnavailableException fileSystemRealmInvalidPasswordAlgorithm(final String algorithm, final Path path, final int lineNumber, final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmInvalidPasswordAlgorithm$str(), algorithm, path, lineNumber, name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fileSystemUpdatedFailed$str() {
        return "ELY01020: Filesystem-backed realm failed to update identity \"%s\"";
    }
    @Override
    public final RealmUnavailableException fileSystemUpdatedFailed(final String name, final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemUpdatedFailed$str(), name), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fileSystemRealmDeleteFailed$str() {
        return "ELY01021: Filesystem-backed realm failed to delete identity \"%s\"";
    }
    @Override
    public final RealmUnavailableException fileSystemRealmDeleteFailed(final String name, final IOException e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmDeleteFailed$str(), name), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fileSystemRealmNotFound$str() {
        return "ELY01022: Filesystem-backed realm failed to find identity \"%s\"";
    }
    @Override
    public final RealmUnavailableException fileSystemRealmNotFound(final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmNotFound$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fileSystemRealmFailedToWrite$str() {
        return "ELY01023: Filesystem-backed realm failed to write to file \"%s\" for identity \"%s\"";
    }
    @Override
    public final RealmUnavailableException fileSystemRealmFailedToWrite(final Path tempPath, final String name, final Exception e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmFailedToWrite$str(), tempPath, name), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fileSystemRealmAlreadyExists$str() {
        return "ELY01024: Filesystem-backed realm cannot create duplicate identity for identity \"%s\"";
    }
    @Override
    public final RealmUnavailableException fileSystemRealmAlreadyExists(final String name, final Throwable e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmAlreadyExists$str(), name), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fileSystemRealmCertificateReadError$str() {
        return "ELY01025: Filesystem-backed realm encountered invalid certificate format \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    }
    @Override
    public final RealmUnavailableException fileSystemRealmCertificateReadError(final String format, final Path path, final int lineNumber, final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmCertificateReadError$str(), format, path, lineNumber, name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fileSystemRealmUnsupportedKeyFormat$str() {
        return "ELY01026: Filesystem-backed realm encountered invalid key format \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    }
    @Override
    public final RealmUnavailableException fileSystemRealmUnsupportedKeyFormat(final String format, final Path path, final int lineNumber, final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmUnsupportedKeyFormat$str(), format, path, lineNumber, name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fileSystemRealmUnsupportedKeyAlgorithm$str() {
        return "ELY01027: Filesystem-backed realm encountered invalid key algorithm for format \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    }
    @Override
    public final RealmUnavailableException fileSystemRealmUnsupportedKeyAlgorithm(final String format, final Path path, final int lineNumber, final String name, final Exception e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmUnsupportedKeyAlgorithm$str(), format, path, lineNumber, name), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidName$str() {
        return "ELY01064: Invalid identity name";
    }
    @Override
    public final IllegalArgumentException invalidName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fileSystemRealmInvalidOtpDefinition$str() {
        return "ELY01081: Filesystem-backed realm encountered invalid OTP definition in path \"%s\" line %d for identity name \"%s\"";
    }
    @Override
    public final RealmUnavailableException fileSystemRealmInvalidOtpDefinition(final Path path, final int lineNumber, final String name, final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmInvalidOtpDefinition$str(), path, lineNumber, name), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fileSystemRealmInvalidOtpAlgorithm$str() {
        return "ELY01082: Filesystem-backed realm encountered invalid OTP algorithm \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    }
    @Override
    public final RealmUnavailableException fileSystemRealmInvalidOtpAlgorithm(final String algorithm, final Path path, final int lineNumber, final String name, final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmInvalidOtpAlgorithm$str(), algorithm, path, lineNumber, name), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String decodingHashedPasswordFromPropertiesRealmFailed$str() {
        return "ELY01138: Decoding hashed password from users property file failed - should not be set as plain-text property file?";
    }
    @Override
    public final RealmUnavailableException decodingHashedPasswordFromPropertiesRealmFailed(final Exception e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), decodingHashedPasswordFromPropertiesRealmFailed$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String realmCacheUnexpectedType$str() {
        return "ELY01145: Security realm [%s] must implement [%s]";
    }
    @Override
    public final IllegalArgumentException realmCacheUnexpectedType(final SecurityRealm realm, final Class<? extends CacheableSecurityRealm> expectedType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), realmCacheUnexpectedType$str(), realm, expectedType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String transformedPrincipalCannotBeNull$str() {
        return "ELY13000: Authorization principal cannot be null after transformation";
    }
    @Override
    public final IllegalStateException transformedPrincipalCannotBeNull() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), transformedPrincipalCannotBeNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToReadKeyStore$str() {
        return "ELY01154: Failed to read key store";
    }
    @Override
    public final RealmUnavailableException failedToReadKeyStore(final KeyStoreException e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), failedToReadKeyStore$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidUnicodeSequence$str() {
        return "ELY11005: Invalid unicode endoding, offending sequence: %s.";
    }
    @Override
    public final IOException invalidUnicodeSequence(final String s, final NoSuchElementException nsee) {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidUnicodeSequence$str(), s), nsee);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void realmFailover(final RealmUnavailableException rue) {
        super.log.logf(FQCN, WARN, rue, realmFailover$str());
    }
    protected String realmFailover$str() {
        return "ELY13001: Realm is failing over.";
    }
    protected String unableToHandleCallback$str() {
        return "ELY13002: %s does not handle a callback of type %s";
    }
    @Override
    public final UnsupportedCallbackException unableToHandleCallback(final Callback callback, final String callbackHandler, final String callbackType) {
        final UnsupportedCallbackException result = new UnsupportedCallbackException(callback, String.format(getLoggingLocale(), unableToHandleCallback$str(), callbackHandler, callbackType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToLoadJaasConfigFile$str() {
        return "ELY13003: Failed to load JAAS configuration file.";
    }
    @Override
    public final RealmUnavailableException failedToLoadJaasConfigFile() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), failedToLoadJaasConfigFile$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void debugInfoJaasLogoutFailure(final Principal principal, final Throwable cause) {
        super.log.logf(FQCN, DEBUG, cause, debugInfoJaasLogoutFailure$str(), principal);
    }
    protected String debugInfoJaasLogoutFailure$str() {
        return "ELY13004: JAAS logout failed for principal %s";
    }
    protected String fileSystemRealmDecryptionFailed$str() {
        return "ELY13005: Filesystem-backed realm unable to decrypt identity";
    }
    @Override
    public final RealmUnavailableException fileSystemRealmDecryptionFailed(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmDecryptionFailed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fileSystemRealmEncryptionFailed$str() {
        return "ELY13006: Filesystem-backed realm unable to encrypt identity";
    }
    @Override
    public final RealmUnavailableException fileSystemRealmEncryptionFailed(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmEncryptionFailed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIdentitySignature$str() {
        return "ELY13007: Signature for the following identity is invalid: %s.";
    }
    @Override
    public final org.wildfly.security.auth.realm.IntegrityException invalidIdentitySignature(final String s) {
        final org.wildfly.security.auth.realm.IntegrityException result = new org.wildfly.security.auth.realm.IntegrityException(String.format(getLoggingLocale(), invalidIdentitySignature$str(), s));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToGenerateSignature$str() {
        return "ELY13008: Unable to create a signature for the file: %s.";
    }
    @Override
    public final RealmUnavailableException unableToGenerateSignature(final String s) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), unableToGenerateSignature$str(), s));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFindSignature$str() {
        return "ELY13009: Unable to locate the signature element for the file: %s";
    }
    @Override
    public final RealmUnavailableException cannotFindSignature(final String s) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), cannotFindSignature$str(), s));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeyPairArgument$str() {
        return "ELY13010: Both PrivateKey and PublicKey must be defined for realm at: %s";
    }
    @Override
    public final IllegalArgumentException invalidKeyPairArgument(final String s) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidKeyPairArgument$str(), s));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String integrityNotEnabled$str() {
        return "ELY13011: Integrity has not been enabled for the realm at: %s";
    }
    @Override
    public final IllegalArgumentException integrityNotEnabled(final String s) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), integrityNotEnabled$str(), s));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void realmIsNotAvailable(final Exception e) {
        super.log.logf(FQCN, WARN, e, realmIsNotAvailable$str());
    }
    protected String realmIsNotAvailable$str() {
        return "ELY13012: A realm within the distributed realm is unavailable. This realm will be ignored.";
    }
}
