package org.wildfly.security.sasl._private;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import org.wildfly.security.mechanism.AuthenticationMechanismException;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2025-09-04T17:10:47+0100")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void unableToResolveMechanismConfiguration(final Throwable e) {
        super.log.logf(FQCN, WARN, e, unableToResolveMechanismConfiguration$str());
    }
    protected String unableToResolveMechanismConfiguration$str() {
        return "ELY01157: Unable to resolve MechanismConfiguration for MechanismInformation";
    }
    protected String mechMessageAfterComplete$str() {
        return "ELY05001: Authentication mechanism exchange received a message after authentication was already complete";
    }
    @Override
    public final AuthenticationMechanismException mechMessageAfterComplete() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechMessageAfterComplete$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String mechAuthenticationNotComplete$str() {
        return "ELY05005: Authentication mechanism authentication is not yet complete";
    }
    @Override
    public final IllegalStateException mechAuthenticationNotComplete() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), mechAuthenticationNotComplete$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechSelectorUnexpectedChar$str() {
        return "ELY05015: Unexpected character U+%04x at offset %d of mechanism selection string \"%s\"";
    }
    @Override
    public final IllegalArgumentException mechSelectorUnexpectedChar(final int codePoint, final long offset, final String string) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mechSelectorUnexpectedChar$str(), codePoint, offset, string));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechSelectorTokenNotAllowed$str() {
        return "ELY05017: Token \"%s\" not allowed at offset %d of mechanism selection string \"%s\"";
    }
    @Override
    public final IllegalArgumentException mechSelectorTokenNotAllowed(final String token, final long offset, final String string) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mechSelectorTokenNotAllowed$str(), token, offset, string));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechSelectorUnexpectedEnd$str() {
        return "ELY05020: Unexpected end of mechanism selection string \"%s\"";
    }
    @Override
    public final IllegalArgumentException mechSelectorUnexpectedEnd(final String string) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mechSelectorUnexpectedEnd$str(), string));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechAuthenticationFailed$str() {
        return "ELY05058: Authentication failed";
    }
    @Override
    public final AuthenticationMechanismException mechAuthenticationFailed() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAuthenticationFailed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String wrappingNotConfigured$str() {
        return "ELY05090: Wrapping is not configured";
    }
    @Override
    public final IllegalStateException wrappingNotConfigured() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), wrappingNotConfigured$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNonAsciiSpace$str() {
        return "ELY05130: Invalid non-ASCII space \"0x%X\"";
    }
    @Override
    public final IllegalArgumentException invalidNonAsciiSpace(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidNonAsciiSpace$str(), input));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechCallbackHandlerFailedForUnknownReason$str() {
        return "ELY05053: Callback handler failed for unknown reason";
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerFailedForUnknownReason(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechCallbackHandlerFailedForUnknownReason$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidAsciiControl$str() {
        return "ELY05131: Invalid ASCII control \"0x%X\"";
    }
    @Override
    public final IllegalArgumentException invalidAsciiControl(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidAsciiControl$str(), input));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNonAsciiControl$str() {
        return "ELY05132: Invalid non-ASCII control \"0x%X\"";
    }
    @Override
    public final IllegalArgumentException invalidNonAsciiControl(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidNonAsciiControl$str(), input));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPrivateUseCharacter$str() {
        return "ELY05133: Invalid private use character \"0x%X\"";
    }
    @Override
    public final IllegalArgumentException invalidPrivateUseCharacter(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPrivateUseCharacter$str(), input));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNonCharacterCodePoint$str() {
        return "ELY05134: Invalid non-character code point \"0x%X\"";
    }
    @Override
    public final IllegalArgumentException invalidNonCharacterCodePoint(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidNonCharacterCodePoint$str(), input));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSurrogateCodePoint$str() {
        return "ELY05135: Invalid surrogate code point \"0x%X\"";
    }
    @Override
    public final IllegalArgumentException invalidSurrogateCodePoint(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSurrogateCodePoint$str(), input));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPlainTextCodePoint$str() {
        return "ELY05136: Invalid plain text code point \"0x%X\"";
    }
    @Override
    public final IllegalArgumentException invalidPlainTextCodePoint(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPlainTextCodePoint$str(), input));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNonCanonicalCodePoint$str() {
        return "ELY05137: Invalid non-canonical code point \"0x%X\"";
    }
    @Override
    public final IllegalArgumentException invalidNonCanonicalCodePoint(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidNonCanonicalCodePoint$str(), input));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidControlCharacter$str() {
        return "ELY05138: Invalid control character \"0x%X\"";
    }
    @Override
    public final IllegalArgumentException invalidControlCharacter(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidControlCharacter$str(), input));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTaggingCharacter$str() {
        return "ELY05139: Invalid tagging character \"0x%X\"";
    }
    @Override
    public final IllegalArgumentException invalidTaggingCharacter(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidTaggingCharacter$str(), input));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unassignedCodePoint$str() {
        return "ELY05140: Unassigned code point \"0x%X\"";
    }
    @Override
    public final IllegalArgumentException unassignedCodePoint(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unassignedCodePoint$str(), input));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSurrogatePairHightAtEnd$str() {
        return "ELY05141: Invalid surrogate pair (high at end of string) \"0x%X\"";
    }
    @Override
    public final IllegalArgumentException invalidSurrogatePairHightAtEnd(final char input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSurrogatePairHightAtEnd$str(), input));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSurrogatePairSecondIsNotLow$str() {
        return "ELY05142: Invalid surrogate pair (second is not low) \"0x%X 0x%X\"";
    }
    @Override
    public final IllegalArgumentException invalidSurrogatePairSecondIsNotLow(final char high, final char low) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSurrogatePairSecondIsNotLow$str(), high, low));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSurrogatePairLowWithoutHigh$str() {
        return "ELY05143: Invalid surrogate pair (low without high) \"0x%X\"";
    }
    @Override
    public final IllegalArgumentException invalidSurrogatePairLowWithoutHigh(final char low) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSurrogatePairLowWithoutHigh$str(), low));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidCodePoint$str() {
        return "ELY05144: Invalid code point \"0x%X\"";
    }
    @Override
    public final IllegalArgumentException invalidCodePoint(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidCodePoint$str(), input));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String disallowedRalDirectionalityInL$str() {
        return "ELY05145: Disallowed R/AL directionality character in L string";
    }
    @Override
    public final IllegalArgumentException disallowedRalDirectionalityInL() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), disallowedRalDirectionalityInL$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String disallowedLDirectionalityInRal$str() {
        return "ELY05146: Disallowed L directionality character in R/AL string";
    }
    @Override
    public final IllegalArgumentException disallowedLDirectionalityInRal() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), disallowedLDirectionalityInRal$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingTrailingRal$str() {
        return "ELY05147: Missing trailing R/AL directionality character";
    }
    @Override
    public final IllegalArgumentException missingTrailingRal() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), missingTrailingRal$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidEscapeSequence$str() {
        return "ELY05148: Invalid escape sequence";
    }
    @Override
    public final IllegalArgumentException invalidEscapeSequence() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidEscapeSequence$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechServerTimedOut$str() {
        return "ELY05163: Authentication mechanism server timed out";
    }
    @Override
    public final AuthenticationMechanismException mechServerTimedOut() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechServerTimedOut$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
