/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.security.Principal;
import javax.security.auth.callback.CallbackHandler;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.TestCallbackHandler;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.JaasSecurityRealm;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.PublicKeyCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;

public class JaasSecurityRealmTest {
    @BeforeClass
    public static void init() {
        System.setProperty("java.security.auth.login.config", JaasSecurityRealmTest.class.getResource("login.config").toString());
    }

    @Test
    public void testJaasSecurityRealm() throws Exception {
        JaasSecurityRealm realm = new JaasSecurityRealm("test");
        RealmIdentity realmIdentity = realm.getRealmIdentity((Principal)new NamePrincipal("elytron"));
        Assert.assertNotNull((String)"Unexpected null realm identity", (Object)realmIdentity);
        Assert.assertEquals((String)"Invalid credential support", (Object)SupportLevel.UNSUPPORTED, (Object)realmIdentity.getCredentialAcquireSupport(PasswordCredential.class, "blah", null));
        Assert.assertEquals((String)"Invalid credential support", (Object)SupportLevel.UNSUPPORTED, (Object)realmIdentity.getCredentialAcquireSupport(PublicKeyCredential.class, null, null));
        Assert.assertNull((String)"Invalid non null credential", (Object)realmIdentity.getCredential(PasswordCredential.class, null));
        Assert.assertTrue((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("passwd12#$".toCharArray())));
        Assert.assertFalse((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("wrongpass".toCharArray())));
        Assert.assertTrue((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("passwd12#$".toCharArray())));
        AuthorizationIdentity authRealmIdentity = realmIdentity.getAuthorizationIdentity();
        Assert.assertNotNull((String)"Unexpected null authenticated realm identity", (Object)authRealmIdentity);
    }

    @Test
    public void testJaasSecurityRealmWithCustomCallbackHandler() throws Exception {
        JaasSecurityRealm realm = new JaasSecurityRealm("test", (CallbackHandler)new TestCallbackHandler());
        RealmIdentity realmIdentity = realm.getRealmIdentity((Principal)new NamePrincipal("javajoe"));
        Assert.assertEquals((String)"Invalid credential support", (Object)SupportLevel.SUPPORTED, (Object)realmIdentity.getEvidenceVerifySupport(PasswordGuessEvidence.class, null));
        Assert.assertEquals((String)"Invalid credential support", (Object)SupportLevel.UNSUPPORTED, (Object)realmIdentity.getEvidenceVerifySupport(X509PeerCertificateChainEvidence.class, null));
        Assert.assertTrue((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("$#21pass".toCharArray())));
        Assert.assertFalse((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("wrongpass".toCharArray())));
    }
}

