/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;

public class CredentialStoreBuilder {
    private String type = "JCEKS";
    private String file;
    private char[] storagePassword;
    private ArrayList<Data> data = new ArrayList();

    public static CredentialStoreBuilder get() {
        return new CredentialStoreBuilder();
    }

    public CredentialStoreBuilder setKeyStoreType(String type) {
        this.type = type;
        return this;
    }

    public CredentialStoreBuilder setKeyStoreFile(String file) {
        this.file = file;
        return this;
    }

    public CredentialStoreBuilder setKeyStorePassword(String storagePassword) {
        this.storagePassword = storagePassword.toCharArray();
        return this;
    }

    public CredentialStoreBuilder setKeyStorePassword(char[] storagePassword) {
        this.storagePassword = Arrays.copyOf(storagePassword, storagePassword.length);
        return this;
    }

    public CredentialStoreBuilder addCredential(String alias, Credential credential) {
        this.data.add(new Data(alias, credential, null));
        return this;
    }

    public CredentialStoreBuilder addPassword(String alias, Password password) {
        return this.addCredential(alias, (Credential)new PasswordCredential(password));
    }

    public CredentialStoreBuilder addPassword(String alias, char[] password) {
        return this.addPassword(alias, (Password)ClearPassword.createRaw((String)"clear", (char[])password));
    }

    public CredentialStoreBuilder addPassword(String alias, String password) {
        return this.addPassword(alias, password.toCharArray());
    }

    public void build() throws Exception {
        if (this.file == null) {
            throw new IllegalStateException("file has to be specified");
        }
        KeyStoreCredentialStore storeImpl = new KeyStoreCredentialStore();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("location", this.file);
        map.put("create", Boolean.TRUE.toString());
        if (this.type != null) {
            map.put("keyStoreType", this.type);
        }
        storeImpl.initialize(map, (CredentialStore.ProtectionParameter)new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)IdentityCredentials.NONE.withCredential((Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])this.storagePassword)))), null);
        for (Data item : this.data) {
            storeImpl.store(item.getAlias(), item.getCredential(), item.getProtectionParameter());
        }
        storeImpl.flush();
    }

    static final class Data {
        private String alias;
        private Credential credential;
        private CredentialStore.ProtectionParameter protectionParameter;

        Data(String alias, Credential credential, CredentialStore.ProtectionParameter protectionParameter) {
            this.alias = alias;
            this.credential = credential;
            this.protectionParameter = protectionParameter;
        }

        String getAlias() {
            return this.alias;
        }

        Credential getCredential() {
            return this.credential;
        }

        CredentialStore.ProtectionParameter getProtectionParameter() {
            return this.protectionParameter;
        }
    }
}

