/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ldap;

import java.security.Principal;
import java.util.Arrays;
import javax.naming.InvalidNameException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapName;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.ldap.AttributeMapping;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealmBuilder;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableRealmIdentityIterator;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.ldap.LdapTestSuite;

public class ModifiabilitySuiteChild {
    private static ModifiableSecurityRealm realm;

    @BeforeClass
    public static void createRealm() throws InvalidNameException {
        BasicAttributes attributes = new BasicAttributes(true);
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        objectClass.add("top");
        objectClass.add("inetOrgPerson");
        objectClass.add("person");
        objectClass.add("organizationalPerson");
        attributes.put(objectClass);
        attributes.put(new BasicAttribute("sn", "aaa"));
        attributes.put(new BasicAttribute("cn", "bbb"));
        attributes.put(new BasicAttribute("description", "new user"));
        realm = LdapSecurityRealmBuilder.builder().setDirContextSupplier(LdapTestSuite.dirContextFactory.create()).setPageSize(3).identityMapping().setSearchDn("dc=elytron,dc=wildfly,dc=org").setRdnIdentifier("uid").map(new AttributeMapping[]{AttributeMapping.fromIdentity().from("uid").to("userName").build(), AttributeMapping.fromIdentity().from("cn").to("firstName").build(), AttributeMapping.fromIdentity().from("sn").to("lastName").build(), AttributeMapping.fromIdentity().from("description").to("description").build(), AttributeMapping.fromIdentity().from("telephoneNumber").to("phones").build(), AttributeMapping.fromFilter((String)"(&(objectClass=groupOfNames)(member=uid={0}))").searchDn("ou=Finance,dc=elytron,dc=wildfly,dc=org").extractRdn("OU").to("businessArea").build()}).setNewIdentityParent(new LdapName("dc=elytron,dc=wildfly,dc=org")).setNewIdentityAttributes((javax.naming.directory.Attributes)attributes).setIteratorFilter("(uid=*)").build().build();
    }

    @Test
    public void testCreateDelete() throws RealmUnavailableException, InterruptedException {
        ModifiableRealmIdentity identity = (ModifiableRealmIdentity)realm.getRealmIdentity((Principal)new NamePrincipal("myNewIdentity"));
        Assert.assertFalse((boolean)identity.exists());
        identity.create();
        identity.dispose();
        identity = (ModifiableRealmIdentity)realm.getRealmIdentity((Principal)new NamePrincipal("myNewIdentity"));
        Assert.assertTrue((boolean)identity.exists());
        identity.delete();
        identity.dispose();
        identity = (ModifiableRealmIdentity)realm.getRealmIdentity((Principal)new NamePrincipal("myNewIdentity"));
        Assert.assertFalse((boolean)identity.exists());
        identity.dispose();
    }

    @Test
    public void testAttributeSetting() throws Exception {
        ModifiableRealmIdentity identity = (ModifiableRealmIdentity)realm.getRealmIdentity((Principal)new NamePrincipal("myNewAttributesIdentity"));
        Assert.assertFalse((boolean)identity.exists());
        identity.create();
        MapAttributes newAttributes = new MapAttributes();
        newAttributes.addFirst("userName", "JohnSmithsNewIdentity");
        newAttributes.addFirst("firstName", "John");
        newAttributes.addFirst("lastName", "Smith");
        newAttributes.addAll("phones", Arrays.asList("123456", "654321"));
        identity.setAttributes((Attributes)newAttributes);
        identity.dispose();
        identity = (ModifiableRealmIdentity)realm.getRealmIdentity((Principal)new NamePrincipal("myNewAttributesIdentity"));
        Assert.assertFalse((boolean)identity.exists());
        identity.dispose();
        identity = (ModifiableRealmIdentity)realm.getRealmIdentity((Principal)new NamePrincipal("JohnSmithsNewIdentity"));
        Assert.assertTrue((boolean)identity.exists());
        Attributes attributes = identity.getAuthorizationIdentity().getAttributes();
        Assert.assertEquals((Object)"johnsmithsnewidentity", (Object)((String)attributes.get("userName").get(0)).toLowerCase());
        Assert.assertEquals((Object)"John", (Object)attributes.get("firstName").get(0));
        Assert.assertEquals((Object)"Smith", (Object)attributes.get("lastName").get(0));
        Assert.assertEquals((long)0L, (long)attributes.get("description").size());
        Assert.assertEquals((long)2L, (long)attributes.get("phones").size());
        identity.dispose();
    }

    @Test
    public void testIterating() throws Exception {
        ModifiableRealmIdentityIterator iterator = realm.getRealmIdentityIterator();
        int count = 0;
        while (iterator.hasNext()) {
            ModifiableRealmIdentity identity = (ModifiableRealmIdentity)iterator.next();
            Assert.assertTrue((boolean)identity.exists());
            System.out.println(identity.getAuthorizationIdentity().getAttributes().getFirst("userName"));
            identity.dispose();
            ++count;
        }
        Assert.assertTrue((count > 10 ? 1 : 0) != 0);
    }
}

