/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest;

import java.net.URI;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.ClientUtils;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.DigestPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;
import org.wildfly.security.sasl.SaslMechanismSelector;

class DigestCallbackHandlerUtils {
    DigestCallbackHandlerUtils() {
    }

    static CallbackHandler createClearPwdClientCallbackHandler(String username, String password, String sentRealm) throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"clear");
        return DigestCallbackHandlerUtils.createClientCallbackHandler(username, passwordFactory.generatePassword((KeySpec)new ClearPasswordSpec(password.toCharArray())), sentRealm);
    }

    static CallbackHandler createDigestPwdClientCallbackHandler(String username, String password, String realm, String sentRealm, String sentUsername) throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"digest-md5");
        DigestPasswordAlgorithmSpec parameterSpec = new DigestPasswordAlgorithmSpec(username, realm);
        EncryptablePasswordSpec encryptableSpec = new EncryptablePasswordSpec(password.toCharArray(), (AlgorithmParameterSpec)parameterSpec);
        return DigestCallbackHandlerUtils.createClientCallbackHandler(sentUsername, passwordFactory.generatePassword((KeySpec)encryptableSpec), sentRealm);
    }

    private static CallbackHandler createClientCallbackHandler(String username, Password password, String sentRealm) throws Exception {
        AuthenticationContext context = AuthenticationContext.empty().with(MatchRule.ALL, AuthenticationConfiguration.empty().useName(username).usePassword(password).useRealm(sentRealm).setSaslMechanismSelector(SaslMechanismSelector.NONE.addMechanism("DIGEST-MD5")));
        return ClientUtils.getCallbackHandler(new URI("seems://irrelevant"), context);
    }
}

