/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.URI;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.MiscPEMGenerator;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.realm.KeyStoreBackedSecurityRealm;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.permission.PermissionVerifier;
import org.wildfly.security.ssl.SSLContextBuilder;
import org.wildfly.security.ssl.TestingOcspServer;
import org.wildfly.security.ssl.X509RevocationTrustManager;
import org.wildfly.security.ssl.test.util.CAGenerationTool;
import org.wildfly.security.x500.GeneralName;
import org.wildfly.security.x500.cert.AccessDescription;
import org.wildfly.security.x500.cert.AuthorityInformationAccessExtension;
import org.wildfly.security.x500.cert.ExtendedKeyUsageExtension;
import org.wildfly.security.x500.cert.X509CertificateExtension;
import org.wildfly.security.x500.principal.X500AttributePrincipalDecoder;

public class SSLAuthenticationTest {
    private static final boolean IS_IBM = System.getProperty("java.vendor").contains("IBM");
    private static final int OCSP_PORT = 4854;
    private final int TESTING_PORT = 18201;
    private static final char[] PASSWORD = "Elytron".toCharArray();
    private static final String JKS_LOCATION = "./target/test-classes/jks";
    private static final String CA_CRL_LOCATION = "./target/test-classes/ca/crl";
    private static final String ICA_CRL_LOCATION = "./target/test-classes/ica/crl";
    private static final File WORKING_DIR_CACRL = new File("./target/test-classes/ca/crl");
    private static final File WORKING_DIR_ICACRL = new File("./target/test-classes/ica/crl");
    private static final File SHORTWINGED_FILE = new File("./target/test-classes/jks", "shortwinged.keystore");
    private static final File CA_BLANK_PEM_CRL = new File(WORKING_DIR_CACRL, "blank.pem");
    private static final File ICA_BLANK_PEM_CRL = new File(WORKING_DIR_ICACRL, "blank.pem");
    private static final File BLANK_BLANK_PEM_CRL = new File(WORKING_DIR_ICACRL, "blank-blank.pem");
    private static final File FIREFLY_REVOKED_PEM_CRL = new File(WORKING_DIR_CACRL, "firefly-revoked.pem");
    private static final File ICA_REVOKED_PEM_CRL = new File(WORKING_DIR_CACRL, "ica-revoked.pem");
    private static final File ROVE_REVOKED_PEM_CRL = new File(WORKING_DIR_ICACRL, "rove-revoked.pem");
    private static CAGenerationTool caGenerationTool = null;
    private static TestingOcspServer ocspServer = null;
    private static X509Certificate ocspResponderCertificate;

    private static X509ExtendedKeyManager getKeyManager(String keystorePath) throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(IS_IBM ? "IbmX509" : "SunX509");
        keyManagerFactory.init(SSLAuthenticationTest.createKeyStore(keystorePath), PASSWORD);
        for (KeyManager current : keyManagerFactory.getKeyManagers()) {
            if (!(current instanceof X509ExtendedKeyManager)) continue;
            return (X509ExtendedKeyManager)current;
        }
        throw new IllegalStateException("Unable to obtain X509ExtendedKeyManager.");
    }

    private static TrustManagerFactory getTrustManagerFactory() throws Exception {
        return TrustManagerFactory.getInstance("PKIX");
    }

    private static X509TrustManager getCATrustManager() throws Exception {
        TrustManagerFactory trustManagerFactory = SSLAuthenticationTest.getTrustManagerFactory();
        trustManagerFactory.init(SSLAuthenticationTest.createKeyStore("/jks/ca.truststore"));
        for (TrustManager current : trustManagerFactory.getTrustManagers()) {
            if (!(current instanceof X509TrustManager)) continue;
            return (X509TrustManager)current;
        }
        throw new IllegalStateException("Unable to obtain X509TrustManager.");
    }

    private static KeyStore createKeyStore() throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        return ks;
    }

    private static KeyStore createKeyStore(String path) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("jks");
        try (InputStream caTrustStoreFile = SSLAuthenticationTest.class.getResourceAsStream(path);){
            keyStore.load(caTrustStoreFile, PASSWORD);
        }
        return keyStore;
    }

    private static void createTemporaryKeyStoreFile(KeyStore keyStore, File outputFile, char[] password) throws Exception {
        if (!outputFile.exists()) {
            outputFile.createNewFile();
        }
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            keyStore.store(fos, password);
        }
    }

    private static SecurityDomain getKeyStoreBackedSecurityDomain(String keyStorePath) throws Exception {
        return SSLAuthenticationTest.getKeyStoreBackedSecurityDomain(keyStorePath, true);
    }

    private static SecurityDomain getKeyStoreBackedSecurityDomain(String keyStorePath, boolean decoder) throws Exception {
        KeyStoreBackedSecurityRealm securityRealm = new KeyStoreBackedSecurityRealm(SSLAuthenticationTest.createKeyStore(keyStorePath));
        SecurityDomain.Builder builder = SecurityDomain.builder().addRealm("KeystoreRealm", (SecurityRealm)securityRealm).build().setDefaultRealmName("KeystoreRealm").setPreRealmRewriter(s -> s.toLowerCase(Locale.ENGLISH)).setPermissionMapper((permissionMappable, roles) -> PermissionVerifier.ALL);
        if (decoder) {
            builder.setPrincipalDecoder((PrincipalDecoder)new X500AttributePrincipalDecoder("2.5.4.3", 1));
        }
        return builder.build();
    }

    @BeforeClass
    public static void beforeTest() throws Exception {
        WORKING_DIR_CACRL.mkdirs();
        WORKING_DIR_ICACRL.mkdirs();
        caGenerationTool = CAGenerationTool.builder().setBaseDir(JKS_LOCATION).setRequestIdentities(CAGenerationTool.Identity.values()).build();
        Security.addProvider((Provider)new BouncyCastleProvider());
        ocspResponderCertificate = caGenerationTool.createIdentity("ocspResponder", new X500Principal("OU=Elytron, O=Elytron, C=UK, ST=Elytron, CN=OcspResponder"), "ocsp-responder.keystore", CAGenerationTool.Identity.CA, new X509CertificateExtension[]{new ExtendedKeyUsageExtension(false, Collections.singletonList("1.3.6.1.5.5.7.3.9"))});
        X509Certificate ocspCheckedGoodCertificate = caGenerationTool.createIdentity("checked", new X500Principal("OU=Elytron, O=Elytron, C=UK, ST=Elytron, CN=ocspCheckedGood"), "ocsp-checked-good.keystore", CAGenerationTool.Identity.INTERMEDIATE, new X509CertificateExtension[]{new AuthorityInformationAccessExtension(Collections.singletonList(new AccessDescription("1.3.6.1.5.5.7.48.1", (GeneralName)new GeneralName.URIName("http://localhost:4854/ocsp"))))});
        X509Certificate ocspCheckedRevokedCertificate = caGenerationTool.createIdentity("checked", new X500Principal("OU=Elytron, O=Elytron, C=UK, ST=Elytron, CN=ocspCheckedRevoked"), "ocsp-checked-revoked.keystore", CAGenerationTool.Identity.CA, new X509CertificateExtension[]{new AuthorityInformationAccessExtension(Collections.singletonList(new AccessDescription("1.3.6.1.5.5.7.48.1", (GeneralName)new GeneralName.URIName("http://localhost:4854/ocsp"))))});
        X509Certificate ocspCheckedUnknownCertificate = caGenerationTool.createIdentity("checked", new X500Principal("OU=Elytron, O=Elytron, C=UK, ST=Elytron, CN=ocspCheckedUnknown"), "ocsp-checked-unknown.keystore", CAGenerationTool.Identity.CA, new X509CertificateExtension[]{new AuthorityInformationAccessExtension(Collections.singletonList(new AccessDescription("1.3.6.1.5.5.7.48.1", (GeneralName)new GeneralName.URIName("http://localhost:4854/ocsp"))))});
        KeyStore beetlesKeyStore = SSLAuthenticationTest.createKeyStore("/jks/beetles.keystore");
        beetlesKeyStore.setCertificateEntry("ocspResponder", ocspResponderCertificate);
        beetlesKeyStore.setCertificateEntry("ocspCheckedGood", ocspCheckedGoodCertificate);
        beetlesKeyStore.setCertificateEntry("ocspCheckedRevoked", ocspCheckedRevokedCertificate);
        beetlesKeyStore.setCertificateEntry("ocspCheckedUnknown", ocspCheckedUnknownCertificate);
        SSLAuthenticationTest.createTemporaryKeyStoreFile(beetlesKeyStore, new File(JKS_LOCATION, "beetles.keystore"), PASSWORD);
        KeyStore shortwingedKeyStore = SSLAuthenticationTest.createKeyStore();
        shortwingedKeyStore.setCertificateEntry("rove", caGenerationTool.getCertificate(CAGenerationTool.Identity.ROVE));
        SSLAuthenticationTest.createTemporaryKeyStoreFile(shortwingedKeyStore, SHORTWINGED_FILE, PASSWORD);
        Calendar calendar = Calendar.getInstance();
        Date currentDate = calendar.getTime();
        calendar.add(1, 1);
        Date nextYear = calendar.getTime();
        calendar.add(1, -1);
        calendar.add(13, -30);
        Date revokeDate = calendar.getTime();
        X509v2CRLBuilder caBlankCrlBuilder = new X509v2CRLBuilder(SSLAuthenticationTest.convertSunStyleToBCStyle(caGenerationTool.getCertificate(CAGenerationTool.Identity.CA).getSubjectDN()), currentDate);
        X509CRLHolder caBlankCrlHolder = caBlankCrlBuilder.setNextUpdate(nextYear).build(new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(caGenerationTool.getPrivateKey(CAGenerationTool.Identity.CA)));
        X509v2CRLBuilder icaBlankCrlBuilder = new X509v2CRLBuilder(SSLAuthenticationTest.convertSunStyleToBCStyle(caGenerationTool.getCertificate(CAGenerationTool.Identity.INTERMEDIATE).getSubjectDN()), currentDate);
        X509CRLHolder icaBlankCrlHolder = icaBlankCrlBuilder.setNextUpdate(nextYear).build(new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(caGenerationTool.getPrivateKey(CAGenerationTool.Identity.INTERMEDIATE)));
        X509v2CRLBuilder fireflyRevokedCrlBuilder = new X509v2CRLBuilder(SSLAuthenticationTest.convertSunStyleToBCStyle(caGenerationTool.getCertificate(CAGenerationTool.Identity.CA).getSubjectDN()), currentDate);
        fireflyRevokedCrlBuilder.addCRLEntry(caGenerationTool.getCertificate(CAGenerationTool.Identity.FIREFLY).getSerialNumber(), revokeDate, 0);
        X509CRLHolder fireflyRevokedCrlHolder = fireflyRevokedCrlBuilder.setNextUpdate(nextYear).build(new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(caGenerationTool.getPrivateKey(CAGenerationTool.Identity.CA)));
        X509v2CRLBuilder icaRevokedCrlBuilder = new X509v2CRLBuilder(SSLAuthenticationTest.convertSunStyleToBCStyle(caGenerationTool.getCertificate(CAGenerationTool.Identity.CA).getSubjectDN()), currentDate);
        icaRevokedCrlBuilder.addCRLEntry(caGenerationTool.getCertificate(CAGenerationTool.Identity.INTERMEDIATE).getSerialNumber(), revokeDate, 0);
        X509CRLHolder icaRevokedCrlHolder = icaRevokedCrlBuilder.setNextUpdate(nextYear).build(new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(caGenerationTool.getPrivateKey(CAGenerationTool.Identity.CA)));
        X509v2CRLBuilder roveRevokedCrlBuilder = new X509v2CRLBuilder(SSLAuthenticationTest.convertSunStyleToBCStyle(caGenerationTool.getCertificate(CAGenerationTool.Identity.INTERMEDIATE).getSubjectDN()), currentDate);
        X509CRLHolder roveRevokedCrlHolder = roveRevokedCrlBuilder.setNextUpdate(nextYear).build(new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(caGenerationTool.getPrivateKey(CAGenerationTool.Identity.INTERMEDIATE)));
        PemWriter caBlankCrlOutput = new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(CA_BLANK_PEM_CRL)));
        PemWriter icaBlankCrlOutput = new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(ICA_BLANK_PEM_CRL)));
        PemWriter blankBlankCrlOutput = new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(BLANK_BLANK_PEM_CRL)));
        PemWriter fireflyRevokedCrlOutput = new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(FIREFLY_REVOKED_PEM_CRL)));
        PemWriter icaRevokedCrlOutput = new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(ICA_REVOKED_PEM_CRL)));
        PemWriter roveRevokedCrlOutput = new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(ROVE_REVOKED_PEM_CRL)));
        caBlankCrlOutput.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)caBlankCrlHolder));
        icaBlankCrlOutput.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)icaBlankCrlHolder));
        blankBlankCrlOutput.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)icaBlankCrlHolder));
        blankBlankCrlOutput.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)caBlankCrlHolder));
        fireflyRevokedCrlOutput.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)fireflyRevokedCrlHolder));
        icaRevokedCrlOutput.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)icaRevokedCrlHolder));
        roveRevokedCrlOutput.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)roveRevokedCrlHolder));
        roveRevokedCrlOutput.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)icaBlankCrlHolder));
        roveRevokedCrlOutput.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)caBlankCrlHolder));
        caBlankCrlOutput.close();
        icaBlankCrlOutput.close();
        blankBlankCrlOutput.close();
        fireflyRevokedCrlOutput.close();
        icaRevokedCrlOutput.close();
        roveRevokedCrlOutput.close();
        ocspServer = new TestingOcspServer(4854);
        ocspServer.createIssuer(1, caGenerationTool.getCertificate(CAGenerationTool.Identity.CA));
        ocspServer.createIssuer(2, caGenerationTool.getCertificate(CAGenerationTool.Identity.INTERMEDIATE));
        ocspServer.createCertificate(1, 1, caGenerationTool.getCertificate(CAGenerationTool.Identity.INTERMEDIATE));
        ocspServer.createCertificate(2, 2, ocspCheckedGoodCertificate);
        ocspServer.createCertificate(3, 1, ocspCheckedRevokedCertificate);
        ocspServer.revokeCertificate(3, 4);
        ocspServer.start();
    }

    private static X500Name convertSunStyleToBCStyle(Principal dn) {
        String dnName = dn.getName();
        String[] dnComponents = dnName.split(", ");
        StringBuilder dnBuffer = new StringBuilder(dnName.length());
        dnBuffer.append(dnComponents[dnComponents.length - 1]);
        for (int i = dnComponents.length - 2; i >= 0; --i) {
            dnBuffer.append(',');
            dnBuffer.append(dnComponents[i]);
        }
        return new X500Name(dnBuffer.toString());
    }

    @AfterClass
    public static void afterTest() throws Exception {
        if (ocspServer != null) {
            ocspServer.stop();
        }
        SHORTWINGED_FILE.delete();
        CA_BLANK_PEM_CRL.delete();
        ICA_BLANK_PEM_CRL.delete();
        BLANK_BLANK_PEM_CRL.delete();
        FIREFLY_REVOKED_PEM_CRL.delete();
        ICA_REVOKED_PEM_CRL.delete();
        ROVE_REVOKED_PEM_CRL.delete();
        WORKING_DIR_CACRL.delete();
        WORKING_DIR_ICACRL.delete();
        caGenerationTool.close();
        Security.removeProvider(new BouncyCastleProvider().getName());
    }

    @Test
    public void testOneWay() throws Throwable {
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setKeyManager(SSLAuthenticationTest.getKeyManager("/jks/firefly.keystore")).build().create();
        this.performConnectionTest(serverContext, "protocol://test-one-way.org", true, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Firefly", null, true);
    }

    @Test
    public void testCrlBlank() throws Throwable {
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setKeyManager(SSLAuthenticationTest.getKeyManager("/jks/firefly.keystore")).build().create();
        this.performConnectionTest(serverContext, "protocol://test-one-way-crl.org", true, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Firefly", null, true);
    }

    @Test
    public void testServerRevoked() throws Throwable {
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setKeyManager(SSLAuthenticationTest.getKeyManager("/jks/firefly.keystore")).build().create();
        this.performConnectionTest(serverContext, "protocol://test-one-way-firefly-revoked.org", false, null, null, true);
    }

    @Test
    public void testServerIcaRevoked() throws Throwable {
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setKeyManager(SSLAuthenticationTest.getKeyManager("/jks/rove.keystore")).build().create();
        this.performConnectionTest(serverContext, "protocol://test-one-way-ica-revoked.org", false, null, null, true);
    }

    @Test
    public void testCRLMaxCertPathSucceeds() throws Throwable {
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setKeyManager(SSLAuthenticationTest.getKeyManager("/jks/rove.keystore")).build().create();
        this.performConnectionTest(serverContext, "protocol://test-one-way-max-cert-path.org", true, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Rove", null, true);
    }

    @Test
    public void testCRLMaxCertPathFails() throws Throwable {
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setKeyManager(SSLAuthenticationTest.getKeyManager("/jks/rove.keystore")).build().create();
        this.performConnectionTest(serverContext, "protocol://test-one-way-max-cert-path-failure.org", false, null, null, true);
    }

    @Test
    public void testTwoWay() throws Throwable {
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(SSLAuthenticationTest.getKeyStoreBackedSecurityDomain("/jks/beetles.keystore")).setKeyManager(SSLAuthenticationTest.getKeyManager("/jks/scarab.keystore")).setTrustManager(SSLAuthenticationTest.getCATrustManager()).setNeedClientAuth(true).build().create();
        this.performConnectionTest(serverContext, "protocol://test-two-way.org", true, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Scarab", "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Ladybird", false);
    }

    @Test
    public void testTwoWayNoDecoder() throws Throwable {
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(SSLAuthenticationTest.getKeyStoreBackedSecurityDomain("/jks/beetles.keystore", false)).setKeyManager(SSLAuthenticationTest.getKeyManager("/jks/scarab.keystore")).setTrustManager(SSLAuthenticationTest.getCATrustManager()).setNeedClientAuth(true).build().create();
        this.performConnectionTest(serverContext, "protocol://test-two-way.org", true, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Scarab", "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Ladybird", false);
    }

    @Test
    public void testTwoWayIca() throws Throwable {
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(SSLAuthenticationTest.getKeyStoreBackedSecurityDomain("/jks/shortwinged.keystore")).setKeyManager(SSLAuthenticationTest.getKeyManager("/jks/scarab.keystore")).setTrustManager(SSLAuthenticationTest.getCATrustManager()).setNeedClientAuth(true).build().create();
        this.performConnectionTest(serverContext, "protocol://test-two-way-ica.org", true, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Scarab", "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Rove", false);
    }

    @Test
    public void testAcceptedIssuersConfiguredWithCRL() throws Throwable {
        FileInputStream crl = new FileInputStream("./target/test-classes/ica/crl/blank-blank.pem");
        X509RevocationTrustManager trustManager = X509RevocationTrustManager.builder().setTrustManagerFactory(SSLAuthenticationTest.getTrustManagerFactory()).setTrustStore(SSLAuthenticationTest.createKeyStore("/jks/ca.truststore")).setCrlStream((InputStream)crl).setPreferCrls(true).setNoFallback(true).build();
        org.wildfly.common.Assert.assertTrue((trustManager.getAcceptedIssuers().length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testOcspGood() throws Throwable {
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(SSLAuthenticationTest.getKeyStoreBackedSecurityDomain("/jks/beetles.keystore")).setKeyManager(SSLAuthenticationTest.getKeyManager("/jks/scarab.keystore")).setTrustManager((X509TrustManager)X509RevocationTrustManager.builder().setTrustManagerFactory(SSLAuthenticationTest.getTrustManagerFactory()).setTrustStore(SSLAuthenticationTest.createKeyStore("/jks/ca.truststore")).setOcspResponderCert(ocspResponderCertificate).build()).setNeedClientAuth(true).build().create();
        this.performConnectionTest(serverContext, "protocol://test-two-way-ocsp-good.org", true, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Scarab", "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=ocspCheckedGood", false);
    }

    @Test
    public void testOcspMaxCertPathNeg1() throws Throwable {
        this.ocspMaxCertPathCommon(-1, false);
    }

    @Test
    public void testOcspMaxCertPath0() throws Throwable {
        this.ocspMaxCertPathCommon(0, false);
    }

    @Test
    public void testOcspMaxCertPathTooLong() throws Throwable {
        this.ocspMaxCertPathCommon(1, false);
    }

    @Test
    public void testOcspMaxCertPathOkay() throws Throwable {
        this.ocspMaxCertPathCommon(2, true);
    }

    private void ocspMaxCertPathCommon(int maxCertPath, boolean expectValid) throws Throwable {
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(SSLAuthenticationTest.getKeyStoreBackedSecurityDomain("/jks/beetles.keystore")).setKeyManager(SSLAuthenticationTest.getKeyManager("/jks/scarab.keystore")).setTrustManager((X509TrustManager)X509RevocationTrustManager.builder().setTrustManagerFactory(SSLAuthenticationTest.getTrustManagerFactory()).setTrustStore(SSLAuthenticationTest.createKeyStore("/jks/ca.truststore")).setOcspResponderCert(ocspResponderCertificate).setMaxCertPath(maxCertPath).build()).setNeedClientAuth(true).build().create();
        this.performConnectionTest(serverContext, "protocol://test-two-way-ocsp-good.org", expectValid, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Scarab", "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=ocspCheckedGood", false);
    }

    @Test
    public void testClientSideOcsp() throws Throwable {
        SSLContext serverContextGood = (SSLContext)new SSLContextBuilder().setKeyManager(SSLAuthenticationTest.getKeyManager("/jks/ocsp-checked-good.keystore")).build().create();
        SSLContext serverContextRevoked = (SSLContext)new SSLContextBuilder().setKeyManager(SSLAuthenticationTest.getKeyManager("/jks/ocsp-checked-revoked.keystore")).build().create();
        SSLContext clientContext = (SSLContext)new SSLContextBuilder().setTrustManager((X509TrustManager)X509RevocationTrustManager.builder().setTrustManagerFactory(SSLAuthenticationTest.getTrustManagerFactory()).setTrustStore(SSLAuthenticationTest.createKeyStore("/jks/ca.truststore")).setOcspResponderCert(ocspResponderCertificate).build()).setClientMode(true).build().create();
        this.testCommunication(serverContextGood, clientContext, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=ocspCheckedGood", null, true);
        try {
            this.testCommunication(serverContextRevoked, clientContext, null, null, true);
            Assert.fail((String)"Expected SSLHandshakeException not thrown");
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performConnectionTest(SSLContext serverContext, String clientUri, boolean expectValid, String expectedServerPrincipal, String expectedClientPrincipal, boolean oneWay) throws Throwable {
        System.setProperty("wildfly.config.url", SSLAuthenticationTest.class.getResource("wildfly-ssl-test-config-v1_1.xml").toExternalForm());
        AccessController.doPrivileged(() -> Security.insertProviderAt((Provider)WildFlyElytronPasswordProvider.getInstance(), 1));
        AuthenticationContext context = (AuthenticationContext)AuthenticationContext.getContextManager().get();
        AuthenticationContextConfigurationClient contextConfigurationClient = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
        SSLContext clientContext = contextConfigurationClient.getSSLContext(URI.create(clientUri), context);
        try {
            this.testCommunication(serverContext, clientContext, expectedServerPrincipal, expectedClientPrincipal, oneWay);
            if (!expectValid) {
                Assert.fail((String)"Expected SSLHandshakeException not thrown");
            }
        }
        catch (SocketException | SSLHandshakeException expected) {
            if (expectValid) {
                throw new IllegalStateException("Unexpected SSLHandshakeException", expected);
            }
        }
        catch (SSLException expected) {
            if (expectValid) {
                throw new IllegalStateException("Unexpected SSLException", expected);
            }
            if (expected.getCause() instanceof SocketException) {
                // empty if block
            }
        }
        finally {
            System.clearProperty("wildfly.config.url");
            Security.removeProvider(WildFlyElytronPasswordProvider.getInstance().getName());
        }
    }

    private void testCommunication(SSLContext serverContext, SSLContext clientContext, String expectedServerPrincipal, String expectedClientPrincipal, boolean oneWay) throws Throwable {
        ServerSocket listeningSocket = serverContext.getServerSocketFactory().createServerSocket();
        listeningSocket.bind(new InetSocketAddress("localhost", 18201));
        SSLSocket clientSocket = (SSLSocket)clientContext.getSocketFactory().createSocket("localhost", 18201);
        SSLSocket serverSocket = (SSLSocket)listeningSocket.accept();
        ExecutorService serverExecutorService = Executors.newSingleThreadExecutor();
        Future<byte[]> serverFuture = serverExecutorService.submit(() -> {
            try {
                byte[] received = new byte[2];
                serverSocket.getInputStream().read(received);
                serverSocket.getOutputStream().write(new byte[]{86, 120});
                if (expectedClientPrincipal != null) {
                    Assert.assertEquals((Object)expectedClientPrincipal, (Object)serverSocket.getSession().getPeerPrincipal().getName());
                }
                SecurityIdentity identity = (SecurityIdentity)serverSocket.getSession().getValue("org.wildfly.security.ssl.identity");
                if (oneWay) {
                    Assert.assertNull((Object)identity);
                } else {
                    Assert.assertNotNull((Object)identity);
                }
                return received;
            }
            catch (Exception e) {
                throw new RuntimeException("Server exception", e);
            }
        });
        ExecutorService clientExecutorService = Executors.newSingleThreadExecutor();
        Future<byte[]> clientFuture = clientExecutorService.submit(() -> {
            try {
                byte[] received = new byte[2];
                clientSocket.getOutputStream().write(new byte[]{18, 52});
                clientSocket.getInputStream().read(received);
                if (expectedServerPrincipal != null) {
                    Assert.assertEquals((Object)expectedServerPrincipal, (Object)clientSocket.getSession().getPeerPrincipal().getName());
                }
                if (oneWay) {
                    Assert.assertFalse((boolean)clientSocket.getSession().getProtocol().equals("TLSv1.3"));
                } else {
                    Assert.assertFalse((boolean)serverSocket.getSession().getProtocol().equals("TLSv1.3"));
                    Assert.assertFalse((boolean)clientSocket.getSession().getProtocol().equals("TLSv1.3"));
                }
                return received;
            }
            catch (Exception e) {
                throw new RuntimeException("Client exception", e);
            }
        });
        try {
            Assert.assertArrayEquals((byte[])new byte[]{18, 52}, (byte[])serverFuture.get());
            Assert.assertArrayEquals((byte[])new byte[]{86, 120}, (byte[])clientFuture.get());
        }
        catch (ExecutionException e) {
            if (e.getCause() != null && e.getCause() instanceof RuntimeException && e.getCause().getCause() != null) {
                throw e.getCause().getCause();
            }
            throw e;
        }
        finally {
            this.safeClose(serverSocket);
            this.safeClose(clientSocket);
            this.safeClose(listeningSocket);
        }
    }

    private void safeClose(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

