/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.cache;

import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.realm.CachingSecurityRealm;
import org.wildfly.security.auth.realm.SimpleMapBackedSecurityRealm;
import org.wildfly.security.auth.realm.SimpleRealmEntry;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.cache.LRURealmIdentityCache;
import org.wildfly.security.cache.RealmIdentityCache;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.password.spec.ClearPasswordSpec;

public class SecurityRealmIdentityCacheTest {
    private AtomicInteger realmHitCount = new AtomicInteger();

    @Before
    public void onBefore() {
        Security.addProvider((Provider)WildFlyElytronPasswordProvider.getInstance());
    }

    @Test
    public void testRealmIdentitySimpleJavaMapCache() throws Exception {
        int i;
        SecurityDomain securityDomain = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", this.createSecurityRealm(this.createRealmIdentityLRUCache())).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
        for (i = 0; i < 10; ++i) {
            this.assertAuthenticationAndAuthorization("joe", securityDomain);
            Assert.assertEquals((long)1L, (long)this.realmHitCount.get());
        }
        for (i = 0; i < 10; ++i) {
            this.assertAuthenticationAndAuthorization("bob", securityDomain);
            Assert.assertEquals((long)2L, (long)this.realmHitCount.get());
        }
    }

    @Test
    public void testRealmIdentityNoCache() throws Exception {
        SecurityDomain securityDomain = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", this.createSecurityRealm(null)).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
        for (int i = 0; i < 10; ++i) {
            this.assertAuthenticationAndAuthorization("joe", securityDomain);
        }
        Assert.assertEquals((long)10L, (long)this.realmHitCount.get());
    }

    @Test
    public void testMaxAge() throws Exception {
        SecurityDomain securityDomain = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", this.createSecurityRealm(this.createRealmIdentityLRUCache(2000))).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
        this.assertAuthenticationAndAuthorization("joe", securityDomain);
        this.assertAuthenticationAndAuthorization("joe", securityDomain);
        this.assertAuthenticationAndAuthorization("joe", securityDomain);
        Assert.assertEquals((long)1L, (long)this.realmHitCount.get());
        Thread.sleep(3000L);
        this.assertAuthenticationAndAuthorization("joe", securityDomain);
        this.assertAuthenticationAndAuthorization("joe", securityDomain);
        this.assertAuthenticationAndAuthorization("joe", securityDomain);
        Assert.assertEquals((long)2L, (long)this.realmHitCount.get());
    }

    private SecurityRealm createSecurityRealm(RealmIdentityCache cache) {
        final SimpleMapBackedSecurityRealm realm = new SimpleMapBackedSecurityRealm();
        HashMap<String, SimpleRealmEntry> users = new HashMap<String, SimpleRealmEntry>();
        this.addUser(users, "joe", "User");
        this.addUser(users, "bob", "User");
        realm.setIdentityMap(users);
        if (cache == null) {
            cache = new RealmIdentityCache(){

                public void put(Principal principal, RealmIdentity realmIdentity) {
                }

                public RealmIdentity get(Principal principal) {
                    return null;
                }

                public void remove(Principal principal) {
                }

                public void clear() {
                }
            };
        }
        return new CachingSecurityRealm(new CacheableSecurityRealm(){

            public void registerIdentityChangeListener(Consumer<Principal> listener) {
            }

            public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
                SecurityRealmIdentityCacheTest.this.realmHitCount.incrementAndGet();
                return realm.getRealmIdentity(principal);
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                return realm.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return this.getEvidenceVerifySupport(evidenceType, algorithmName);
            }
        }, cache){};
    }

    private void addUser(Map<String, SimpleRealmEntry> securityRealm, String userName, String roles) {
        List<PasswordCredential> credentials;
        try {
            credentials = Collections.singletonList(new PasswordCredential(PasswordFactory.getInstance((String)"clear").generatePassword((KeySpec)new ClearPasswordSpec("password".toCharArray()))));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MapAttributes attributes = new MapAttributes();
        attributes.addAll("Roles", Collections.singletonList(roles));
        securityRealm.put(userName, new SimpleRealmEntry(credentials, (Attributes)attributes));
    }

    private void assertAuthenticationAndAuthorization(String username, SecurityDomain securityDomain) throws RealmUnavailableException {
        ServerAuthenticationContext sac = securityDomain.createNewAuthenticationContext();
        sac.setAuthenticationName(username);
        Assert.assertTrue((boolean)sac.verifyEvidence((Evidence)new PasswordGuessEvidence("password".toCharArray())));
        Assert.assertTrue((boolean)sac.authorize(username));
        SecurityIdentity securityIdentity = sac.getAuthorizedIdentity();
        Assert.assertNotNull((Object)securityIdentity);
        Assert.assertEquals((Object)username, (Object)securityIdentity.getPrincipal().getName());
    }

    private RealmIdentityCache createRealmIdentityLRUCache(int maxAge) {
        return new LRURealmIdentityCache(1, (long)maxAge);
    }

    private RealmIdentityCache createRealmIdentityLRUCache() {
        return this.createRealmIdentityLRUCache(-1);
    }
}

