/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.gssapi;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

final class SubjectWrappingSaslClient
implements SaslClient {
    private final SaslClient wrapped;
    private final Subject subject;

    SubjectWrappingSaslClient(SaslClient toBeWrapped, Subject subject) {
        this.wrapped = toBeWrapped;
        this.subject = subject;
    }

    @Override
    public String getMechanismName() {
        return this.wrapped.getMechanismName();
    }

    @Override
    public boolean hasInitialResponse() {
        return this.wrapped.hasInitialResponse();
    }

    @Override
    public byte[] evaluateChallenge(final byte[] challenge) throws SaslException {
        try {
            return Subject.doAs(this.subject, new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return SubjectWrappingSaslClient.this.wrapped.evaluateChallenge(challenge);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof SaslException) {
                throw (SaslException)e.getCause();
            }
            throw new SaslException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isComplete() {
        return this.wrapped.isComplete();
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        return this.wrapped.unwrap(incoming, offset, len);
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        return this.wrapped.wrap(outgoing, offset, len);
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return this.wrapped.getNegotiatedProperty(propName);
    }

    @Override
    public void dispose() throws SaslException {
        this.wrapped.dispose();
    }
}

