/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.test;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.Provider;
import java.security.Security;
import java.security.spec.KeySpec;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import mockit.Mock;
import mockit.MockUp;
import org.jboss.threads.JBossThreadFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.ClientUtils;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.sasl.SaslMechanismSelector;
import org.wildfly.security.sasl.digest.DigestServerFactory;
import org.wildfly.security.sasl.digest.WildFlyElytronSaslDigestProvider;
import org.wildfly.security.sasl.test.SaslServerBuilder;
import org.wildfly.security.sasl.util.AuthenticationTimeoutSaslServerFactory;

public class SaslAuthenticationTimeoutTest {
    private static final String DIGEST = "DIGEST-MD5";
    private static final String AUTHENTICATION_TIMEOUT_MESSAGE = "Authentication mechanism server timed out";
    private static final Provider[] providers = new Provider[]{WildFlyElytronSaslDigestProvider.getInstance(), WildFlyElytronPasswordProvider.getInstance()};

    private static void mockGetTimeout() {
        Class<?> classToMock;
        try {
            classToMock = Class.forName("org.wildfly.security.sasl.util.AuthenticationTimeoutSaslServerFactory", true, AuthenticationTimeoutSaslServerFactory.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        new MockUp<Object>(classToMock){

            @Mock
            private long getTimeout(Map<String, ?> props) {
                return 3L;
            }
        };
    }

    @BeforeClass
    public static void registerPasswordProvider() {
        SaslAuthenticationTimeoutTest.mockGetTimeout();
        for (Provider provider : providers) {
            Security.insertProviderAt(provider, 1);
        }
    }

    @AfterClass
    public static void removePasswordProvider() {
        for (Provider provider : providers) {
            Security.removeProvider(provider.getName());
        }
    }

    @Test
    public void testSuccessfulTimeout() throws Exception {
        ThreadFactory threadFactory = (ThreadFactory)AccessController.doPrivileged(() -> new JBossThreadFactory(new ThreadGroup("SecurityDomain ThreadGroup"), Boolean.FALSE, null, "%G - %t", null, null));
        ScheduledThreadPoolExecutor INSTANCE = new ScheduledThreadPoolExecutor(1, threadFactory);
        INSTANCE.setRemoveOnCancelPolicy(true);
        INSTANCE.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        try {
            SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("gpwd".toCharArray()).setProtocol("TestProtocol").setServerName("TestServer").setScheduledExecutorService(INSTANCE).addMechanismRealm("TestRealm").build();
            CallbackHandler clientCallback = SaslAuthenticationTimeoutTest.createClearPwdClientCallbackHandler("George", "gpwd", "TestRealm");
            SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
            byte[] message = server.evaluateResponse(new byte[0]);
            Thread.sleep(5000L);
            message = client.evaluateChallenge(message);
            server.evaluateResponse(message);
            Assert.fail((String)"Expected SaslException not thrown");
        }
        catch (SaslException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains(AUTHENTICATION_TIMEOUT_MESSAGE));
        }
    }

    @Test
    public void testSuccessfulTimeout_DefaultExecuterService() throws Exception {
        try {
            SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("gpwd".toCharArray()).setProtocol("TestProtocol").setServerName("TestServer").addMechanismRealm("TestRealm").build();
            CallbackHandler clientCallback = SaslAuthenticationTimeoutTest.createClearPwdClientCallbackHandler("George", "gpwd", "TestRealm");
            SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
            byte[] message = server.evaluateResponse(new byte[0]);
            Thread.sleep(5000L);
            message = client.evaluateChallenge(message);
            server.evaluateResponse(message);
            Assert.fail((String)"Expected SaslException not thrown");
        }
        catch (SaslException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains(AUTHENTICATION_TIMEOUT_MESSAGE));
        }
    }

    private static CallbackHandler createClearPwdClientCallbackHandler(String username, String password, String sentRealm) throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"clear");
        return SaslAuthenticationTimeoutTest.createClientCallbackHandler(username, passwordFactory.generatePassword((KeySpec)new ClearPasswordSpec(password.toCharArray())), sentRealm);
    }

    private static CallbackHandler createClientCallbackHandler(String username, Password password, String sentRealm) throws URISyntaxException {
        AuthenticationContext context = AuthenticationContext.empty().with(MatchRule.ALL, AuthenticationConfiguration.empty().useName(username).usePassword(password).useRealm(sentRealm).setSaslMechanismSelector(SaslMechanismSelector.NONE.addMechanism(DIGEST)));
        return ClientUtils.getCallbackHandler(new URI("seems://irrelevant"), context);
    }
}

