/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import java.io.IOException;
import java.net.InetAddress;
import javax.net.SocketFactory;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.logmanager.handlers.SyslogHandler;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.wildfly.security.audit.AuditEndpoint;
import org.wildfly.security.audit.EventPriority;
import org.wildfly.security.audit.SimpleSyslogServer;
import org.wildfly.security.audit.SyslogAuditEndpoint;

public class SyslogAuditEndpointTest {
    private static final String HOST_NAME = "localhost";
    private static final String BAD_HOST_NAME = "0.35.98.76";
    private static final String RFC3164_LOG_MESSAGE = "testing log message RFC3164";
    private static final String RFC5424_LOG_MESSAGE = "testing log message RFC5424";
    private static final int UDP_PORT = 10837;
    private static final int TCP_PORT = 10857;
    private static final int RECONNECT_NUMBER = 10;
    private static final int BAD_RECONNECT_NUMBER = -2;
    private static final int RECONNECT_TIMEOUT = 450;
    private static SocketFactory socketFactory = null;
    private static SimpleSyslogServer udpServer = null;
    private static SimpleSyslogServer tcpServer = null;
    private String failString = "";

    @BeforeClass
    public static void initializeServer() throws Exception {
        socketFactory = SocketFactory.getDefault();
        udpServer = SimpleSyslogServer.createUdp(10837);
        tcpServer = SimpleSyslogServer.createTcp(10857, false);
    }

    @AfterClass
    public static void shutdownServer() {
        udpServer.close();
        tcpServer.close();
    }

    @Test
    public void testGenericRfc3164SyslogEvent() throws Exception {
        AuditEndpoint endpoint = this.setupEndpointUdp(SyslogHandler.SyslogType.RFC3164);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)RFC3164_LOG_MESSAGE);
        endpoint.close();
        this.discardMessage(udpServer);
        this.verifyUdpMessage(RFC3164_LOG_MESSAGE);
    }

    @Test
    public void testGenericRfc5424SyslogEvent() throws Exception {
        AuditEndpoint endpoint = this.setupEndpointUdp(SyslogHandler.SyslogType.RFC5424);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)RFC5424_LOG_MESSAGE);
        endpoint.close();
        this.discardMessage(udpServer);
        this.verifyUdpMessage(RFC5424_LOG_MESSAGE);
    }

    @Test
    public void testBadIntegerReconnectAttempts() throws Exception {
        try {
            AuditEndpoint endpoint = this.setupEndpointBadUdpReconnectAttempts(-2);
            Assert.fail((String)"No error was thrown while attempting to log with an invalid reconnect-attempts number.");
        }
        catch (IllegalArgumentException e) {
            this.assertCorrectError(e, new String[]{"ELY12003", Integer.toString(-2)});
        }
    }

    @Test
    @Ignore(value="[ELY-1895] Testing of failures is unreliable.")
    public void testFailureInfiniteReconnectAttempts() throws Exception {
        Assume.assumeFalse((String)"Test does not run on Windows Server", (boolean)SystemUtils.OS_NAME.contains("Windows Server"));
        Thread t = new Thread(() -> {
            try {
                SyslogAuditEndpoint endpoint = (SyslogAuditEndpoint)this.setupEndpointBadUdpReconnectAttempts(-1);
                int attemptNumber = 1;
                int currentAttempts = endpoint.getAttempts();
                while (attemptNumber == currentAttempts || currentAttempts == -1) {
                    endpoint.accept(EventPriority.INFORMATIONAL, "This is a test message that should fail.");
                    currentAttempts = endpoint.getAttempts();
                    if (currentAttempts != -1) {
                        ++attemptNumber;
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                }
                if (!Thread.currentThread().isInterrupted()) {
                    this.failString = "No error was thrown while attempting to log to a bad IP with UDP.";
                }
            }
            catch (Exception e) {
                this.failString = "An unexpected error has occurred: " + e.getMessage();
            }
        });
        t.start();
        Thread.sleep(450L);
        t.interrupt();
        t.join();
        if (!this.failString.isEmpty()) {
            Assert.fail((String)this.failString);
        }
    }

    @Test
    @Ignore(value="[ELY-1895] Testing of failures is unreliable.")
    public void testFailureZeroReconnectAttempts() throws Exception {
        Assume.assumeFalse((String)"Test does not run on Windows Server", (boolean)SystemUtils.OS_NAME.contains("Windows Server"));
        try {
            AuditEndpoint endpoint = this.setupEndpointBadUdpReconnectAttempts(0);
            Assert.fail((String)"No error was thrown while attempting to log to a bad IP with UDP.");
        }
        catch (IOException e) {
            this.assertCorrectError(e, new String[]{"ELY12001", "0"});
        }
    }

    @Test
    @Ignore(value="[ELY-1895] Testing of failures is unreliable.")
    public void testFailureNumberedReconnectAttempts() throws Exception {
        Assume.assumeFalse((String)"Test does not run on Windows Server", (boolean)SystemUtils.OS_NAME.contains("Windows Server"));
        try {
            AuditEndpoint endpoint = this.setupEndpointBadUdpReconnectAttempts(10);
            for (int i = 0; i < 10; ++i) {
                endpoint.accept((Object)EventPriority.INFORMATIONAL, (Object)"This is a test message that should fail.");
            }
            Assert.fail((String)"No error was thrown while attempting to log to a bad IP with UDP.");
        }
        catch (IOException e) {
            this.assertCorrectError(e, new String[]{"ELY12001", Integer.toString(10)});
        }
    }

    @Test
    public void testSuccessInfiniteReconnectAttempts() throws Exception {
        AuditEndpoint endpoint = this.setupEndpointUdpReconnectAttempts(-1);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)RFC5424_LOG_MESSAGE);
        endpoint.close();
        this.discardMessage(udpServer);
        this.verifyUdpMessage(RFC5424_LOG_MESSAGE);
    }

    @Test
    public void testSuccessZeroReconnectAttempts() throws Exception {
        AuditEndpoint endpoint = this.setupEndpointUdpReconnectAttempts(0);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)RFC5424_LOG_MESSAGE);
        endpoint.close();
        this.discardMessage(udpServer);
        this.verifyUdpMessage(RFC5424_LOG_MESSAGE);
    }

    @Test
    public void testSuccessNumberedReconnectAttempts() throws Exception {
        AuditEndpoint endpoint = this.setupEndpointUdpReconnectAttempts(10);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)RFC5424_LOG_MESSAGE);
        endpoint.close();
        this.discardMessage(udpServer);
        this.verifyUdpMessage(RFC5424_LOG_MESSAGE);
    }

    @Test
    public void testSuccessTcp() throws Exception {
        AuditEndpoint endpoint = this.setupEndpointTcp();
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)RFC5424_LOG_MESSAGE);
        endpoint.close();
        this.verifyTcpMessage(RFC5424_LOG_MESSAGE);
    }

    private AuditEndpoint setupEndpoint(SyslogHandler.SyslogType syslogFormat, String hostName, int port, boolean ssl, boolean tcp, int maxReconnectAttempts) throws Exception {
        return SyslogAuditEndpoint.builder().setFormat(syslogFormat).setHostName(hostName).setPort(port).setServerAddress(InetAddress.getByName(hostName)).setSocketFactory(socketFactory).setSsl(ssl).setTcp(tcp).setMaxReconnectAttempts(maxReconnectAttempts).build();
    }

    private AuditEndpoint setupEndpointUdp(SyslogHandler.SyslogType syslogFormat) throws Exception {
        return this.setupEndpoint(syslogFormat, HOST_NAME, 10837, false, false, -1);
    }

    private AuditEndpoint setupEndpointTcp() throws Exception {
        return this.setupEndpoint(SyslogHandler.SyslogType.RFC5424, HOST_NAME, 10857, false, true, 0);
    }

    private AuditEndpoint setupEndpointUdpReconnectAttempts(int maxReconnectAttempts) throws Exception {
        return this.setupEndpoint(SyslogHandler.SyslogType.RFC5424, HOST_NAME, 10837, false, false, maxReconnectAttempts);
    }

    private AuditEndpoint setupEndpointBadUdpReconnectAttempts(int maxReconnectAttempts) throws Exception {
        return this.setupEndpoint(SyslogHandler.SyslogType.RFC5424, BAD_HOST_NAME, 10837, false, false, maxReconnectAttempts);
    }

    private void discardMessage(SimpleSyslogServer server) throws Exception {
        server.receiveData();
    }

    private void verifyMessage(SimpleSyslogServer server, String msg) throws Exception {
        String[] rawServerDataString;
        byte[] serverData = server.receiveData();
        for (String serverDataString : rawServerDataString = new String(serverData).split(System.getProperty("line.separator"))) {
            if (!serverDataString.contains(msg)) continue;
            return;
        }
        Assert.fail((String)"Server message is not the test message");
    }

    private void verifyUdpMessage(String msg) throws Exception {
        this.verifyMessage(udpServer, msg);
    }

    private void verifyTcpMessage(String msg) throws Exception {
        this.verifyMessage(tcpServer, msg);
    }

    private void assertCorrectError(Exception e, String[] messages) {
        for (String msg : messages) {
            System.out.println(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains(msg));
        }
    }
}

