/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableRealmIdentityIterator;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.ServerUtils;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.BCryptPassword;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.password.interfaces.OneTimePassword;
import org.wildfly.security.password.interfaces.SaltedSimpleDigestPassword;
import org.wildfly.security.password.interfaces.ScramDigestPassword;
import org.wildfly.security.password.interfaces.SimpleDigestPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.DigestPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.Encoding;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.OneTimePasswordSpec;
import org.wildfly.security.password.spec.SaltedPasswordAlgorithmSpec;

public class FileSystemSecurityRealmTest {
    @Test
    public void testCreateIdentityWithNoLevels() throws Exception {
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), 0, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity identity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        Assert.assertFalse((boolean)identity.exists());
        identity.create();
        Assert.assertTrue((boolean)identity.exists());
    }

    @Test
    public void testCreateIdentityWithLevels() throws Exception {
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), 3, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity identity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        identity.create();
        Assert.assertTrue((boolean)identity.exists());
        identity.dispose();
    }

    @Test
    public void testCreateAndLoadIdentity() throws Exception {
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), 3, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        newIdentity.dispose();
        securityRealm = new FileSystemSecurityRealm(this.getRootPath(false), 3, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        Assert.assertTrue((boolean)existingIdentity.exists());
        existingIdentity.dispose();
    }

    @Test
    public void testShortUsername() throws Exception {
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), 3, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("p"));
        newIdentity.create();
        newIdentity.dispose();
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("p"));
        Assert.assertTrue((boolean)existingIdentity.exists());
        existingIdentity.dispose();
    }

    @Test
    public void testSpecialCharacters() throws Exception {
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), 3, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("special*.\"/\\[]:;|=,\u7528\u6236 "));
        newIdentity.create();
        newIdentity.dispose();
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("special*.\"/\\[]:;|=,\u7528\u6236 "));
        Assert.assertTrue((boolean)existingIdentity.exists());
        existingIdentity.dispose();
    }

    @Test
    public void testCaseSensitive() throws Exception {
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), 3, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        Assert.assertTrue((boolean)newIdentity.exists());
        newIdentity.dispose();
        ModifiableRealmIdentity differentIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("PLAINUSER"));
        Assert.assertFalse((boolean)differentIdentity.exists());
        differentIdentity.dispose();
    }

    @Test
    public void testCreateAndLoadAndDeleteIdentity() throws Exception {
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), 3, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        newIdentity.dispose();
        securityRealm = new FileSystemSecurityRealm(this.getRootPath(false), 3, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        Assert.assertTrue((boolean)existingIdentity.exists());
        existingIdentity.delete();
        Assert.assertFalse((boolean)existingIdentity.exists());
        existingIdentity.dispose();
        securityRealm = new FileSystemSecurityRealm(this.getRootPath(false), 3, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        Assert.assertFalse((boolean)existingIdentity.exists());
        existingIdentity.dispose();
    }

    @Test
    public void testCreateIdentityWithAttributes() throws Exception {
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), 1, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        MapAttributes newAttributes = new MapAttributes();
        newAttributes.addFirst("name", "plainUser");
        newAttributes.addAll("roles", Arrays.asList("Employee", "Manager", "Admin"));
        newIdentity.setAttributes((Attributes)newAttributes);
        newIdentity.dispose();
        securityRealm = new FileSystemSecurityRealm(this.getRootPath(false), 1, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        AuthorizationIdentity authorizationIdentity = existingIdentity.getAuthorizationIdentity();
        Attributes existingAttributes = authorizationIdentity.getAttributes();
        existingIdentity.dispose();
        Assert.assertEquals((long)newAttributes.size(), (long)existingAttributes.size());
        Assert.assertTrue((boolean)newAttributes.get("name").containsAll((Collection)existingAttributes.get("name")));
        Assert.assertTrue((boolean)newAttributes.get("roles").containsAll((Collection)existingAttributes.get("roles")));
    }

    @Test
    public void testCreateIdentityWithClearPassword() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        PasswordFactory factory = PasswordFactory.getInstance((String)"clear", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ClearPassword clearPassword = (ClearPassword)factory.generatePassword((KeySpec)new ClearPasswordSpec(actualPassword));
        this.assertCreateIdentityWithPassword(actualPassword, (Password)clearPassword);
    }

    @Test
    public void testCreateIdentityWithBcryptCredential() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"bcrypt", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        char[] actualPassword = "secretPassword".toCharArray();
        BCryptPassword bCryptPassword = (BCryptPassword)passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(10, FileSystemSecurityRealmTest.generateRandomSalt(16))));
        this.assertCreateIdentityWithPassword(actualPassword, (Password)bCryptPassword);
    }

    @Test
    public void testCreateIdentityWithBcryptCredentialHexEncoded() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"bcrypt", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        char[] actualPassword = "secretPassword".toCharArray();
        BCryptPassword bCryptPassword = (BCryptPassword)passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(10, FileSystemSecurityRealmTest.generateRandomSalt(16))));
        this.assertCreateIdentityWithPassword(actualPassword, (Password)bCryptPassword, Encoding.HEX, StandardCharsets.UTF_8);
    }

    @Test
    public void testCreateIdentityWithBcryptCredentialBase64AndCharset() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"bcrypt", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        char[] actualPassword = "password\u5bc6\u7801".toCharArray();
        BCryptPassword bCryptPassword = (BCryptPassword)passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(10, FileSystemSecurityRealmTest.generateRandomSalt(16)), Charset.forName("gb2312")));
        this.assertCreateIdentityWithPassword(actualPassword, (Password)bCryptPassword, Encoding.BASE64, Charset.forName("gb2312"));
    }

    @Test
    public void testCreateIdentityWithBcryptCredentialHexEncodedAndCharset() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"bcrypt", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        char[] actualPassword = "password\u5bc6\u7801".toCharArray();
        BCryptPassword bCryptPassword = (BCryptPassword)passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(10, FileSystemSecurityRealmTest.generateRandomSalt(16)), Charset.forName("gb2312")));
        this.assertCreateIdentityWithPassword(actualPassword, (Password)bCryptPassword, Encoding.HEX, Charset.forName("gb2312"));
    }

    @Test
    public void testCreateIdentityWithScramCredential() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        byte[] salt = FileSystemSecurityRealmTest.generateRandomSalt(16);
        PasswordFactory factory = PasswordFactory.getInstance((String)"scram-sha-256", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        EncryptablePasswordSpec encSpec = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(4096, salt));
        ScramDigestPassword scramPassword = (ScramDigestPassword)factory.generatePassword((KeySpec)encSpec);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)scramPassword);
    }

    @Test
    public void testCreateIdentityWithScramCredentialHexEncoded() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        byte[] salt = FileSystemSecurityRealmTest.generateRandomSalt(16);
        PasswordFactory factory = PasswordFactory.getInstance((String)"scram-sha-256", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        EncryptablePasswordSpec encSpec = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(4096, salt));
        ScramDigestPassword scramPassword = (ScramDigestPassword)factory.generatePassword((KeySpec)encSpec);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)scramPassword, Encoding.HEX, StandardCharsets.UTF_8);
    }

    @Test
    public void testCreateIdentityWithScramCredentialHexEncodedAndCharset() throws Exception {
        char[] actualPassword = "passwordHyv\u00e4\u00e4\u00e4".toCharArray();
        byte[] salt = FileSystemSecurityRealmTest.generateRandomSalt(16);
        PasswordFactory factory = PasswordFactory.getInstance((String)"scram-sha-256", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        EncryptablePasswordSpec encSpec = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(4096, salt), Charset.forName("ISO-8859-1"));
        ScramDigestPassword scramPassword = (ScramDigestPassword)factory.generatePassword((KeySpec)encSpec);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)scramPassword, Encoding.HEX, Charset.forName("ISO-8859-1"));
    }

    @Test
    public void testCreateIdentityWithDigest() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        PasswordFactory factory = PasswordFactory.getInstance((String)"digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        DigestPasswordAlgorithmSpec dpas = new DigestPasswordAlgorithmSpec("jsmith", "elytron");
        EncryptablePasswordSpec encryptableSpec = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)dpas);
        DigestPassword digestPassword = (DigestPassword)factory.generatePassword((KeySpec)encryptableSpec);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)digestPassword);
    }

    @Test
    public void testCreateIdentityWithDigestHexEncoded() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        PasswordFactory factory = PasswordFactory.getInstance((String)"digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        DigestPasswordAlgorithmSpec dpas = new DigestPasswordAlgorithmSpec("jsmith", "elytron");
        EncryptablePasswordSpec encryptableSpec = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)dpas);
        DigestPassword digestPassword = (DigestPassword)factory.generatePassword((KeySpec)encryptableSpec);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)digestPassword, Encoding.HEX, StandardCharsets.UTF_8);
    }

    @Test
    public void testCreateIdentityWithDigestHexEncodedAndCharset() throws Exception {
        char[] actualPassword = "\u043f\u0430\u0440\u043e\u043b\u044c".toCharArray();
        PasswordFactory factory = PasswordFactory.getInstance((String)"digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        DigestPasswordAlgorithmSpec dpas = new DigestPasswordAlgorithmSpec("jsmith", "elytron");
        EncryptablePasswordSpec encryptableSpec = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)dpas, Charset.forName("KOI8-R"));
        DigestPassword digestPassword = (DigestPassword)factory.generatePassword((KeySpec)encryptableSpec);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)digestPassword, Encoding.HEX, Charset.forName("KOI8-R"));
    }

    @Test
    public void testCreateIdentityWithSimpleDigest() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        EncryptablePasswordSpec eps = new EncryptablePasswordSpec(actualPassword, null);
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"simple-digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        SimpleDigestPassword tsdp = (SimpleDigestPassword)passwordFactory.generatePassword((KeySpec)eps);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)tsdp);
    }

    @Test
    public void testCreateIdentityWithSimpleDigestHexEncoded() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        EncryptablePasswordSpec eps = new EncryptablePasswordSpec(actualPassword, null);
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"simple-digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        SimpleDigestPassword tsdp = (SimpleDigestPassword)passwordFactory.generatePassword((KeySpec)eps);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)tsdp, Encoding.HEX, StandardCharsets.UTF_8);
    }

    @Test
    public void testCreateIdentityWithSimpleDigestHexEncodedAndCharset() throws Exception {
        char[] actualPassword = "password\u5bc6\u7801".toCharArray();
        EncryptablePasswordSpec eps = new EncryptablePasswordSpec(actualPassword, null, Charset.forName("gb2312"));
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"simple-digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        SimpleDigestPassword tsdp = (SimpleDigestPassword)passwordFactory.generatePassword((KeySpec)eps);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)tsdp, Encoding.HEX, Charset.forName("gb2312"));
    }

    @Test
    public void testCreateIdentityWithSimpleSaltedDigest() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        byte[] salt = FileSystemSecurityRealmTest.generateRandomSalt(16);
        SaltedPasswordAlgorithmSpec spac = new SaltedPasswordAlgorithmSpec(salt);
        EncryptablePasswordSpec eps = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)spac);
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"password-salt-digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        SaltedSimpleDigestPassword tsdp = (SaltedSimpleDigestPassword)passwordFactory.generatePassword((KeySpec)eps);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)tsdp);
    }

    @Test
    public void testCreateIdentityWithSimpleSaltedDigestHexEncoded() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        byte[] salt = FileSystemSecurityRealmTest.generateRandomSalt(16);
        SaltedPasswordAlgorithmSpec spac = new SaltedPasswordAlgorithmSpec(salt);
        EncryptablePasswordSpec eps = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)spac);
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"password-salt-digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        SaltedSimpleDigestPassword tsdp = (SaltedSimpleDigestPassword)passwordFactory.generatePassword((KeySpec)eps);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)tsdp, Encoding.HEX, StandardCharsets.UTF_8);
    }

    @Test
    public void testCreateIdentityWithSimpleSaltedDigestHexEncodedAndCharset() throws Exception {
        char[] actualPassword = "password\u5bc6\u7801".toCharArray();
        byte[] salt = FileSystemSecurityRealmTest.generateRandomSalt(16);
        SaltedPasswordAlgorithmSpec spac = new SaltedPasswordAlgorithmSpec(salt);
        EncryptablePasswordSpec eps = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)spac, Charset.forName("gb2312"));
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"password-salt-digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        SaltedSimpleDigestPassword tsdp = (SaltedSimpleDigestPassword)passwordFactory.generatePassword((KeySpec)eps);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)tsdp, Encoding.HEX, Charset.forName("gb2312"));
    }

    @Test
    public void testCreateIdentityWithEverything() throws Exception {
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), 1, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        MapAttributes newAttributes = new MapAttributes();
        newAttributes.addFirst("firstName", "John");
        newAttributes.addFirst("lastName", "Smith");
        newAttributes.addAll("roles", Arrays.asList("Employee", "Manager", "Admin"));
        newIdentity.setAttributes((Attributes)newAttributes);
        ArrayList<PasswordCredential> credentials = new ArrayList<PasswordCredential>();
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"bcrypt", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        BCryptPassword bCryptPassword = (BCryptPassword)passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec("secretPassword".toCharArray(), (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(10, FileSystemSecurityRealmTest.generateRandomSalt(16))));
        credentials.add(new PasswordCredential((Password)bCryptPassword));
        byte[] hash = CodePointIterator.ofString((String)"505d889f90085847").hexDecode().drain();
        String seed = "ke1234";
        PasswordFactory otpFactory = PasswordFactory.getInstance((String)"otp-sha1", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        OneTimePassword otpPassword = (OneTimePassword)otpFactory.generatePassword((KeySpec)new OneTimePasswordSpec(hash, seed, 500));
        credentials.add(new PasswordCredential((Password)otpPassword));
        newIdentity.setCredentials(credentials);
        newIdentity.dispose();
        securityRealm = new FileSystemSecurityRealm(this.getRootPath(false), 1, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        Assert.assertTrue((boolean)existingIdentity.exists());
        Assert.assertTrue((boolean)existingIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("secretPassword".toCharArray())));
        OneTimePassword otp = (OneTimePassword)((PasswordCredential)existingIdentity.getCredential(PasswordCredential.class, "otp-sha1")).getPassword(OneTimePassword.class);
        Assert.assertNotNull((Object)otp);
        Assert.assertEquals((Object)"otp-sha1", (Object)otp.getAlgorithm());
        Assert.assertArrayEquals((byte[])hash, (byte[])otp.getHash());
        Assert.assertEquals((Object)seed, (Object)otp.getSeed());
        Assert.assertEquals((long)500L, (long)otp.getSequenceNumber());
        AuthorizationIdentity authorizationIdentity = existingIdentity.getAuthorizationIdentity();
        Attributes existingAttributes = authorizationIdentity.getAttributes();
        existingIdentity.dispose();
        Assert.assertEquals((long)newAttributes.size(), (long)existingAttributes.size());
        Assert.assertTrue((boolean)newAttributes.get("firstName").containsAll((Collection)existingAttributes.get("firstName")));
        Assert.assertTrue((boolean)newAttributes.get("lastName").containsAll((Collection)existingAttributes.get("lastName")));
        Assert.assertTrue((boolean)newAttributes.get("roles").containsAll((Collection)existingAttributes.get("roles")));
    }

    @Test
    public void testCredentialReplacing() throws Exception {
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), 1, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity identity1 = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("testingUser"));
        identity1.create();
        ArrayList<PasswordCredential> credentials = new ArrayList<PasswordCredential>();
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"bcrypt", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        BCryptPassword bCryptPassword = (BCryptPassword)passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec("secretPassword".toCharArray(), (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(10, FileSystemSecurityRealmTest.generateRandomSalt(16))));
        credentials.add(new PasswordCredential((Password)bCryptPassword));
        byte[] hash = CodePointIterator.ofString((String)"505d889f90085847").hexDecode().drain();
        String seed = "ke1234";
        PasswordFactory otpFactory = PasswordFactory.getInstance((String)"otp-sha1", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        OneTimePassword otpPassword = (OneTimePassword)otpFactory.generatePassword((KeySpec)new OneTimePasswordSpec(hash, seed, 500));
        credentials.add(new PasswordCredential((Password)otpPassword));
        identity1.setCredentials(credentials);
        identity1.dispose();
        securityRealm = new FileSystemSecurityRealm(this.getRootPath(false), 1, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity identity3 = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("testingUser"));
        Assert.assertTrue((boolean)identity3.exists());
        Assert.assertTrue((boolean)identity3.verifyEvidence((Evidence)new PasswordGuessEvidence("secretPassword".toCharArray())));
        identity3.dispose();
    }

    private FileSystemSecurityRealm createRealmWithTwoIdentities() throws Exception {
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), 1);
        ModifiableRealmIdentity identity1 = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("firstUser"));
        identity1.create();
        identity1.dispose();
        ModifiableRealmIdentity identity2 = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("secondUser"));
        identity2.create();
        identity2.dispose();
        return securityRealm;
    }

    @Test
    public void testIterating() throws Exception {
        FileSystemSecurityRealm securityRealm = this.createRealmWithTwoIdentities();
        ModifiableRealmIdentityIterator iterator = securityRealm.getRealmIdentityIterator();
        int count = 0;
        while (iterator.hasNext()) {
            Assert.assertTrue((boolean)((ModifiableRealmIdentity)iterator.next()).exists());
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        this.getRootPath();
    }

    @Test
    public void testIteratingNeedlessClose() throws Exception {
        FileSystemSecurityRealm securityRealm = this.createRealmWithTwoIdentities();
        ModifiableRealmIdentityIterator iterator = securityRealm.getRealmIdentityIterator();
        int count = 0;
        while (iterator.hasNext()) {
            Assert.assertTrue((boolean)((ModifiableRealmIdentity)iterator.next()).exists());
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        iterator.close();
        this.getRootPath();
    }

    @Test
    public void testPartialIterating() throws Exception {
        FileSystemSecurityRealm securityRealm = this.createRealmWithTwoIdentities();
        ModifiableRealmIdentityIterator iterator = securityRealm.getRealmIdentityIterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)((ModifiableRealmIdentity)iterator.next()).exists());
        iterator.close();
        this.getRootPath();
    }

    @Test
    public void testPartialIteratingTryWithResource() throws Exception {
        FileSystemSecurityRealm securityRealm = this.createRealmWithTwoIdentities();
        try (ModifiableRealmIdentityIterator iterator = securityRealm.getRealmIdentityIterator();){
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertTrue((boolean)((ModifiableRealmIdentity)iterator.next()).exists());
        }
        this.getRootPath();
    }

    private void assertCreateIdentityWithPassword(char[] actualPassword, Password credential) throws Exception {
        this.assertCreateIdentityWithPassword(actualPassword, credential, Encoding.BASE64, StandardCharsets.UTF_8);
    }

    private void assertCreateIdentityWithPassword(char[] actualPassword, Password credential, Encoding hashEncoding, Charset hashCharset) throws Exception {
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), NameRewriter.IDENTITY_REWRITER, 1, true, hashEncoding, hashCharset, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        newIdentity.setCredentials(Collections.singleton(new PasswordCredential(credential)));
        newIdentity.dispose();
        securityRealm = new FileSystemSecurityRealm(this.getRootPath(false), NameRewriter.IDENTITY_REWRITER, 1, true, hashEncoding, hashCharset, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        Assert.assertTrue((boolean)existingIdentity.exists());
        Assert.assertTrue((boolean)existingIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence(actualPassword)));
        existingIdentity.dispose();
    }

    private static byte[] generateRandomSalt(int saltSize) {
        byte[] randomSalt = new byte[saltSize];
        ThreadLocalRandom.current().nextBytes(randomSalt);
        return randomSalt;
    }

    private Path getRootPath(boolean deleteIfExists) throws Exception {
        Path rootPath = Paths.get(this.getClass().getResource(File.separator).toURI()).resolve("filesystem-realm");
        if (rootPath.toFile().exists() && !deleteIfExists) {
            return rootPath;
        }
        return Files.walkFileTree(Files.createDirectories(rootPath, new FileAttribute[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private Path getRootPath() throws Exception {
        return this.getRootPath(true);
    }
}

