/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.RealmUnavailableException;

public class ServerUtils {
    public static void addUser(ModifiableSecurityRealm realm, String userName) throws RealmUnavailableException {
        ModifiableRealmIdentity realmIdentity = realm.getRealmIdentityForUpdate((Principal)new NamePrincipal(userName));
        realmIdentity.create();
        realmIdentity.dispose();
    }

    public static Path getRootPath(boolean deleteIfExists, Class<?> testClass) throws Exception {
        Path rootPath = Paths.get(testClass.getResource(File.separator).toURI()).resolve("filesystem-realm");
        if (rootPath.toFile().exists() && !deleteIfExists) {
            return rootPath;
        }
        return Files.walkFileTree(Files.createDirectories(rootPath, new FileAttribute[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

