/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http;

import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import mockit.integration.junit4.JMockit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpAuthenticator;
import org.wildfly.security.http.HttpConstants;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.digest.WildFlyElytronHttpDigestProvider;
import org.wildfly.security.http.impl.AbstractBaseHttpTest;

@RunWith(value=JMockit.class)
public class HttpAuthenticatorTest
extends AbstractBaseHttpTest {
    private AbstractBaseHttpTest.TestingHttpExchangeSpi exchangeSpi = new AbstractBaseHttpTest.TestingHttpExchangeSpi(this);
    private HttpAuthenticator authenticator;
    private String digestHeader = "Digest username=\"Mufasa\",\n       realm=\"http-auth@example.org\",\n       uri=\"/dir/index.html\",\n       algorithm=MD5,\n       nonce=\"7ypf/xlj9XXwfDPEoM4URrv/xwf94BcCAzFZH4GiTo0v\",\n       nc=00000001,\n       cnonce=\"f2/wE4q74E6zIJEtWaHKaf5wv/H5QzzpXusqGemxURZJ\",\n       qop=auth,\n       response=\"8ca523f5e9506fed4657c9700eebdbec\",\n       opaque=\"FQhe/qaU925kfnzjCev0ciny7QMkPqMAFRtzCUYo5tdS\"";
    private static final Provider provider = WildFlyElytronHttpDigestProvider.getInstance();

    private CallbackHandler callbackHandler() {
        return this.getCallbackHandler("Mufasa", "http-auth@example.org", "Circle of Life");
    }

    @BeforeClass
    public static void registerPasswordProvider() {
        Security.insertProviderAt(provider, 1);
    }

    @AfterClass
    public static void removePasswordProvider() {
        Security.removeProvider(provider.getName());
    }

    private void testOneOfThree() throws Exception {
        this.mockDigestNonce("7ypf/xlj9XXwfDPEoM4URrv/xwf94BcCAzFZH4GiTo0v");
        HashMap<String, String> digestProps = new HashMap<String, String>();
        digestProps.put(HttpConstants.CONFIG_REALM, "http-auth@example.org");
        digestProps.put("org.wildfly.security.http.validate-digest-uri", "false");
        CallbackHandler callbackHandler = this.callbackHandler();
        LinkedList<HttpServerAuthenticationMechanism> mechanisms = new LinkedList<HttpServerAuthenticationMechanism>();
        mechanisms.add(this.digestFactory.createAuthenticationMechanism("DIGEST", digestProps, callbackHandler));
        mechanisms.add(this.basicFactory.createAuthenticationMechanism("BASIC", Collections.emptyMap(), callbackHandler));
        mechanisms.add(this.digestFactory.createAuthenticationMechanism("DIGEST-SHA-256", digestProps, callbackHandler));
        this.authenticator = HttpAuthenticator.builder().setMechanismSupplier(() -> mechanisms).setHttpExchangeSpi((HttpExchangeSpi)this.exchangeSpi).setRequired(true).build();
        Assert.assertFalse((boolean)this.authenticator.authenticate());
        List<String> responses = this.exchangeSpi.getResponseAuthenticateHeaders();
        Assert.assertEquals((String)"All three mechanisms provided authenticate response", (long)3L, (long)responses.size());
        Assert.assertEquals((long)401L, (long)this.exchangeSpi.getStatusCode());
        Assert.assertEquals(null, (Object)((Object)this.exchangeSpi.getResult()));
        this.exchangeSpi.setStatusCode(0);
    }

    private void authenticateWithDigestMD5() throws HttpAuthenticationException {
        this.exchangeSpi.setRequestAuthorizationHeaders(Collections.singletonList(this.digestHeader));
        Assert.assertTrue((String)"Digest-MD5 successful", (boolean)this.authenticator.authenticate());
        Assert.assertEquals((long)0L, (long)this.exchangeSpi.getStatusCode());
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.COMPLETE), (Object)((Object)this.exchangeSpi.getResult()));
    }

    @Test
    public void testDigestMd5() throws Exception {
        this.testOneOfThree();
        this.authenticateWithDigestMD5();
    }

    @Test
    public void testBasic() throws Exception {
        this.testOneOfThree();
        this.exchangeSpi.setRequestAuthorizationHeaders(Collections.singletonList("Basic TXVmYXNhOkNpcmNsZSBvZiBMaWZl"));
        Assert.assertTrue((String)"Basic successful", (boolean)this.authenticator.authenticate());
        Assert.assertEquals((long)0L, (long)this.exchangeSpi.getStatusCode());
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.COMPLETE), (Object)((Object)this.exchangeSpi.getResult()));
    }

    @Test
    public void testDigestSha256() throws Exception {
        this.testOneOfThree();
        this.exchangeSpi.setRequestAuthorizationHeaders(Collections.singletonList("Digest username=\"Mufasa\",\n       realm=\"http-auth@example.org\",\n       uri=\"/dir/index.html\",\n       algorithm=SHA-256,\n       nonce=\"7ypf/xlj9XXwfDPEoM4URrv/xwf94BcCAzFZH4GiTo0v\",\n       nc=00000001,\n       cnonce=\"f2/wE4q74E6zIJEtWaHKaf5wv/H5QzzpXusqGemxURZJ\",\n       qop=auth,\n       response=\"753927fa0e85d155564e2e272a28d1802ca10daf4496794697cf8db5856cb6c1\",\n       opaque=\"FQhe/qaU925kfnzjCev0ciny7QMkPqMAFRtzCUYo5tdS\""));
        Assert.assertTrue((String)"Digest-SHA-256 successful", (boolean)this.authenticator.authenticate());
        Assert.assertEquals((long)0L, (long)this.exchangeSpi.getStatusCode());
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.COMPLETE), (Object)((Object)this.exchangeSpi.getResult()));
    }

    public List<HttpServerAuthenticationMechanism> prepareBasicSilentMechanisms() throws Exception {
        this.mockDigestNonce("7ypf/xlj9XXwfDPEoM4URrv/xwf94BcCAzFZH4GiTo0v");
        LinkedList<HttpServerAuthenticationMechanism> mechanisms = new LinkedList<HttpServerAuthenticationMechanism>();
        HashMap<String, String> silentProp = new HashMap<String, String>();
        silentProp.put("silent", "true");
        mechanisms.add(this.basicFactory.createAuthenticationMechanism("BASIC", silentProp, this.callbackHandler()));
        this.authenticator = HttpAuthenticator.builder().setMechanismSupplier(() -> mechanisms).setHttpExchangeSpi((HttpExchangeSpi)this.exchangeSpi).setRequired(true).build();
        return mechanisms;
    }

    public void prepareSilentBasicWithDigestMechanisms() throws Exception {
        List<HttpServerAuthenticationMechanism> mechanisms = this.prepareBasicSilentMechanisms();
        HashMap<String, String> digestProps = new HashMap<String, String>();
        digestProps.put(HttpConstants.CONFIG_REALM, "http-auth@example.org");
        digestProps.put("org.wildfly.security.http.validate-digest-uri", "false");
        mechanisms.add(this.digestFactory.createAuthenticationMechanism("DIGEST", digestProps, this.callbackHandler()));
        this.authenticator = HttpAuthenticator.builder().setMechanismSupplier(() -> mechanisms).setHttpExchangeSpi((HttpExchangeSpi)this.exchangeSpi).setRequired(true).build();
    }

    @Test
    public void testBasicSilent() throws Exception {
        this.prepareBasicSilentMechanisms();
        Assert.assertFalse((boolean)this.authenticator.authenticate());
        List<String> responses = this.exchangeSpi.getResponseAuthenticateHeaders();
        Assert.assertEquals((String)"Basic authentication with silent mode does not send challenge if AUTHORIZATION header is not present", (long)0L, (long)responses.size());
        Assert.assertEquals((long)200L, (long)this.exchangeSpi.getStatusCode());
        this.exchangeSpi.setRequestAuthorizationHeaders(Collections.singletonList("Basic "));
        Assert.assertFalse((boolean)this.authenticator.authenticate());
        responses = this.exchangeSpi.getResponseAuthenticateHeaders();
        Assert.assertEquals((String)"Basic authentication with silent mode sends challenge when AUTHORIZATION header is present", (long)1L, (long)responses.size());
        Assert.assertEquals((long)401L, (long)this.exchangeSpi.getStatusCode());
        this.exchangeSpi.setRequestAuthorizationHeaders(Collections.singletonList("Basic TXVmYXNhOkNpcmNsZSBvZiBMaWZl"));
        Assert.assertTrue((String)"Basic auth successful", (boolean)this.authenticator.authenticate());
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.COMPLETE), (Object)((Object)this.exchangeSpi.getResult()));
    }

    @Test
    public void testBasicSilentWithDigest() throws Exception {
        this.prepareSilentBasicWithDigestMechanisms();
        this.authenticateWithDigestMD5();
    }
}

