/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest;

import java.io.File;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import mockit.Mock;
import mockit.MockUp;
import mockit.integration.junit4.JMockit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.ClientUtils;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreBuilder;
import org.wildfly.security.credential.store.WildFlyElytronCredentialStoreProvider;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.sasl.SaslMechanismSelector;
import org.wildfly.security.sasl.digest.DigestSaslClient;
import org.wildfly.security.sasl.digest.WildFlyElytronSaslDigestProvider;

@RunWith(value=JMockit.class)
public class CompatibilityClientTest {
    protected static final String DIGEST = "DIGEST-MD5";
    protected static final String QOP_PROPERTY = "javax.security.sasl.qop";
    private SaslClient client;
    private static final Provider[] providers = new Provider[]{WildFlyElytronSaslDigestProvider.getInstance(), WildFlyElytronCredentialStoreProvider.getInstance()};
    private static String CS_FILE_NAME = "target/" + CompatibilityClientTest.class.getSimpleName() + ".cs";

    private static void registerProviders() {
        for (Provider provider : providers) {
            Security.insertProviderAt(provider, 1);
        }
    }

    @AfterClass
    public static void removeProviders() {
        for (Provider provider : providers) {
            Security.removeProvider(provider.getName());
        }
    }

    private void mockNonce(final String nonce) {
        new MockUp<DigestSaslClient>(){

            @Mock
            byte[] generateNonce() {
                return nonce.getBytes(StandardCharsets.UTF_8);
            }
        };
    }

    @BeforeClass
    public static void setupCredentialStore() throws Exception {
        CompatibilityClientTest.registerProviders();
        CredentialStoreBuilder.get().setKeyStoreFile(CS_FILE_NAME).setKeyStorePassword("secret_store_1").addPassword("chris_pwd_alias", "secret").build();
    }

    @AfterClass
    public static void cleanUpCredentialStore() {
        File csFile = new File(CS_FILE_NAME);
        if (csFile.exists()) {
            csFile.delete();
        }
    }

    @Test
    public void testRfc2831example1Classic() throws Exception {
        this.testRfc2831example1(false);
    }

    @Test
    public void testRfc2831example1CredentialStore() throws Exception {
        this.testRfc2831example1(true);
    }

    private void testRfc2831example1(boolean useCredentialStore) throws Exception {
        this.mockNonce("OA6MHXh6VqTrRk");
        HashMap clientProps = new HashMap();
        CallbackHandler clientCallback = useCredentialStore ? this.createCredentialStoreBasedClientCallbackHandler("chris", null, "chris_pwd_alias", CS_FILE_NAME, "secret_store_1", "secret_key_1") : this.createClientCallbackHandler("chris", "secret".toCharArray(), null);
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, null, "imap", "elwood.innosoft.com", clientProps, clientCallback);
        Assert.assertNotNull((Object)client);
        Assert.assertFalse((boolean)client.isComplete());
        byte[] message1 = "realm=\"elwood.innosoft.com\",nonce=\"OA6MG9tEQGm2hh\",qop=\"auth\",algorithm=md5-sess,charset=utf-8".getBytes(StandardCharsets.UTF_8);
        byte[] message2 = client.evaluateChallenge(message1);
        Assert.assertEquals((Object)"charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA6MG9tEQGm2hh\",nc=00000001,cnonce=\"OA6MHXh6VqTrRk\",digest-uri=\"imap/elwood.innosoft.com\",maxbuf=65536,response=d388dad90d4bbd760a152321f2143af7,qop=auth", (Object)new String(message2, "UTF-8"));
        Assert.assertFalse((boolean)client.isComplete());
        byte[] message3 = "rspauth=ea40f60335c427b5527b84dbabcdfffd".getBytes(StandardCharsets.UTF_8);
        byte[] message4 = client.evaluateChallenge(message3);
        Assert.assertEquals(null, (Object)message4);
        Assert.assertTrue((boolean)client.isComplete());
    }

    @Test
    public void testRfc2831example2Classic() throws Exception {
        this.testRfc2831example2(false);
    }

    @Test
    public void testRfc2831example2CredentialStore() throws Exception {
        this.testRfc2831example2(true);
    }

    private void testRfc2831example2(boolean useCredentialStore) throws Exception {
        this.mockNonce("OA9BSuZWMSpW8m");
        HashMap clientProps = new HashMap();
        CallbackHandler clientCallback = useCredentialStore ? this.createCredentialStoreBasedClientCallbackHandler("chris", null, "chris_pwd_alias", CS_FILE_NAME, "secret_store_1", "secret_key_1") : this.createClientCallbackHandler("chris", "secret".toCharArray(), null);
        this.client = Sasl.createSaslClient(new String[]{DIGEST}, null, "acap", "elwood.innosoft.com", clientProps, clientCallback);
        Assert.assertFalse((boolean)this.client.hasInitialResponse());
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message1 = "realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",qop=\"auth\",algorithm=md5-sess,charset=utf-8".getBytes(StandardCharsets.UTF_8);
        byte[] message2 = this.client.evaluateChallenge(message1);
        Assert.assertEquals((Object)"charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA9BSuZWMSpW8m\",digest-uri=\"acap/elwood.innosoft.com\",maxbuf=65536,response=6084c6db3fede7352c551284490fd0fc,qop=auth", (Object)new String(message2, "UTF-8"));
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message3 = "rspauth=2f0b3d7c3c2e486600ef710726aa2eae".getBytes(StandardCharsets.UTF_8);
        byte[] message4 = this.client.evaluateChallenge(message3);
        Assert.assertEquals(null, (Object)message4);
        Assert.assertTrue((boolean)this.client.isComplete());
    }

    @Test
    public void testAuthorizedAuthorizationIdClassic() throws Exception {
        this.testAuthorizedAuthorizationId(false);
    }

    @Test
    public void testAuthorizedAuthorizationIdCredentialStore() throws Exception {
        this.testAuthorizedAuthorizationId(true);
    }

    private void testAuthorizedAuthorizationId(boolean useCredentialStore) throws Exception {
        this.mockNonce("OA9BSuZWMSpW8m");
        HashMap clientProps = new HashMap();
        CallbackHandler clientCallback = useCredentialStore ? this.createCredentialStoreBasedClientCallbackHandler("chris", null, "chris_pwd_alias", CS_FILE_NAME, "secret_store_1", "secret_key_1") : this.createClientCallbackHandler("chris", "secret".toCharArray(), null);
        this.client = Sasl.createSaslClient(new String[]{DIGEST}, "chris", "acap", "elwood.innosoft.com", clientProps, clientCallback);
        Assert.assertFalse((boolean)this.client.hasInitialResponse());
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message1 = "realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",qop=\"auth\",algorithm=md5-sess,charset=utf-8".getBytes(StandardCharsets.UTF_8);
        byte[] message2 = this.client.evaluateChallenge(message1);
        Assert.assertEquals((Object)"charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA9BSuZWMSpW8m\",digest-uri=\"acap/elwood.innosoft.com\",maxbuf=65536,response=aa4e81f1c6656350f7bce05d436665de,qop=auth,authzid=\"chris\"", (Object)new String(message2, "UTF-8"));
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message3 = "rspauth=af3ca83a805d4cfa00675a17315475c4".getBytes(StandardCharsets.UTF_8);
        byte[] message4 = this.client.evaluateChallenge(message3);
        Assert.assertEquals(null, (Object)message4);
        Assert.assertTrue((boolean)this.client.isComplete());
    }

    @Test
    public void testQopAuthIntClassic() throws Exception {
        this.testQopAuthInt(false);
    }

    @Test
    public void testQopAuthIntCredentialStore() throws Exception {
        this.testQopAuthInt(true);
    }

    private void testQopAuthInt(boolean useCredentialStore) throws Exception {
        this.mockNonce("OA9BSuZWMSpW8m");
        HashMap<String, String> clientProps = new HashMap<String, String>();
        clientProps.put(QOP_PROPERTY, "auth-int");
        CallbackHandler clientCallback = useCredentialStore ? this.createCredentialStoreBasedClientCallbackHandler("chris", null, "chris_pwd_alias", CS_FILE_NAME, "secret_store_1", "secret_key_1") : this.createClientCallbackHandler("chris", "secret".toCharArray(), null);
        this.client = Sasl.createSaslClient(new String[]{DIGEST}, "chris", "acap", "elwood.innosoft.com", clientProps, clientCallback);
        Assert.assertFalse((boolean)this.client.hasInitialResponse());
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message1 = "realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",qop=\"auth-int\",charset=utf-8,algorithm=md5-sess".getBytes(StandardCharsets.UTF_8);
        byte[] message2 = this.client.evaluateChallenge(message1);
        Assert.assertEquals((Object)"charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA9BSuZWMSpW8m\",digest-uri=\"acap/elwood.innosoft.com\",maxbuf=65536,response=d8b17f55b410208c6ebb22f89f9d6cbb,qop=auth-int,authzid=\"chris\"", (Object)new String(message2, "UTF-8"));
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message3 = "rspauth=7a8794654d6d6de607e9143d52b554a8".getBytes(StandardCharsets.UTF_8);
        byte[] message4 = this.client.evaluateChallenge(message3);
        Assert.assertEquals(null, (Object)message4);
        Assert.assertTrue((boolean)this.client.isComplete());
        byte[] outcoming1 = CodePointIterator.ofString((String)"11223344").hexDecode().drain();
        byte[] outcoming1wrapped = this.client.wrap(outcoming1, 0, outcoming1.length);
        Assert.assertEquals((Object)"1122334499191be7952a49d8549b000100000000", (Object)ByteIterator.ofBytes((byte[])outcoming1wrapped).hexEncode().drainToString());
        byte[] incoming1 = CodePointIterator.ofString((String)"55667788cf5e02ad15987d9076b8000100000000").hexDecode().drain();
        byte[] incoming1unwrapped = this.client.unwrap(incoming1, 0, incoming1.length);
        Assert.assertEquals((Object)"55667788", (Object)ByteIterator.ofBytes((byte[])incoming1unwrapped).hexEncode().drainToString());
        byte[] outcoming2 = CodePointIterator.ofString((String)"aabbcc").hexDecode().drain();
        byte[] outcoming2wrapped = this.client.wrap(outcoming2, 0, outcoming2.length);
        Assert.assertEquals((Object)"aabbcc7e845ed48b0474447543000100000001", (Object)ByteIterator.ofBytes((byte[])outcoming2wrapped).hexEncode().drainToString());
        byte[] incoming2 = new byte[]{};
        byte[] incoming2unwrapped = this.client.unwrap(incoming2, 0, incoming2.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])incoming2unwrapped).hexEncode().drainToString());
        byte[] incoming3 = CodePointIterator.ofString((String)"016603ce7148b6869e1b8df557000100000001").hexDecode().drain();
        byte[] incoming3unwrapped = this.client.unwrap(incoming3, 0, incoming3.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])incoming3unwrapped).hexEncode().drainToString());
        try {
            byte[] incoming4 = CodePointIterator.ofString((String)"01020352873023be5e875d6a93000100000002").hexDecode().drain();
            this.client.unwrap(incoming4, 0, incoming4.length);
            Assert.fail((String)"Out of order sequencing SaslException expected!");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testQopAuthConf() throws Exception {
        this.mockNonce("OA9BSuZWMSpW8m");
        CallbackHandler clientCallback = this.createClientCallbackHandler("chris", "secret".toCharArray(), null);
        HashMap<String, String> clientProps = new HashMap<String, String>();
        clientProps.put(QOP_PROPERTY, "auth-conf");
        this.client = Sasl.createSaslClient(new String[]{DIGEST}, "chris", "acap", "elwood.innosoft.com", clientProps, clientCallback);
        Assert.assertFalse((boolean)this.client.hasInitialResponse());
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message1 = "realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",qop=\"auth-conf\",charset=utf-8,cipher=\"3des,rc4,des,rc4-56,rc4-40\",algorithm=md5-sess".getBytes(StandardCharsets.UTF_8);
        byte[] message2 = this.client.evaluateChallenge(message1);
        Assert.assertEquals((Object)"charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA9BSuZWMSpW8m\",digest-uri=\"acap/elwood.innosoft.com\",maxbuf=65536,response=4520cf48234bb93b95548a25cd56601b,qop=auth-conf,cipher=\"3des\",authzid=\"chris\"", (Object)new String(message2, "UTF-8"));
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message3 = "rspauth=a804fda66588e2d911bbacd1b1163bc1".getBytes(StandardCharsets.UTF_8);
        byte[] message4 = this.client.evaluateChallenge(message3);
        Assert.assertEquals(null, (Object)message4);
        Assert.assertTrue((boolean)this.client.isComplete());
        byte[] outcoming1 = CodePointIterator.ofString((String)"11223344").hexDecode().drain();
        byte[] outcoming1wrapped = this.client.wrap(outcoming1, 0, outcoming1.length);
        Assert.assertEquals((Object)"13f7644f8c783501177522c1a455cb1f000100000000", (Object)ByteIterator.ofBytes((byte[])outcoming1wrapped).hexEncode().drainToString());
        byte[] incoming1 = CodePointIterator.ofString((String)"93ce33409e0fe5187e07c16fc3041f64000100000000").hexDecode().drain();
        byte[] incoming1unwrapped = this.client.unwrap(incoming1, 0, incoming1.length);
        Assert.assertEquals((Object)"55667788", (Object)ByteIterator.ofBytes((byte[])incoming1unwrapped).hexEncode().drainToString());
        byte[] outcoming2 = CodePointIterator.ofString((String)"aabbcc").hexDecode().drain();
        byte[] outcoming2wrapped = this.client.wrap(outcoming2, 0, outcoming2.length);
        Assert.assertEquals((Object)"ec426d9cd3276f22285ab5da8df8f26b000100000001", (Object)ByteIterator.ofBytes((byte[])outcoming2wrapped).hexEncode().drainToString());
        byte[] incoming2 = new byte[]{};
        byte[] incoming2unwrapped = this.client.unwrap(incoming2, 0, incoming2.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])incoming2unwrapped).hexEncode().drainToString());
        byte[] incoming3 = CodePointIterator.ofString((String)"cb8905522a50046ecb969c11a9d72014000100000001").hexDecode().drain();
        byte[] incoming3unwrapped = this.client.unwrap(incoming3, 0, incoming3.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])incoming3unwrapped).hexEncode().drainToString());
        try {
            byte[] incoming4 = CodePointIterator.ofString((String)"b12efd35ef3289f98cf6d98e6547bd3a000100000002").hexDecode().drain();
            this.client.unwrap(incoming4, 0, incoming4.length);
            Assert.fail((String)"Out of order sequencing SaslException expected!");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testQopAuthConfRc4Classic() throws Exception {
        this.testQopAuthConfRc4(false);
    }

    @Test
    public void testQopAuthConfRc4CredentialStore() throws Exception {
        this.testQopAuthConfRc4(true);
    }

    private void testQopAuthConfRc4(boolean useCredentialStore) throws Exception {
        this.mockNonce("OA9BSuZWMSpW8m");
        HashMap<String, String> clientProps = new HashMap<String, String>();
        clientProps.put(QOP_PROPERTY, "auth-conf");
        CallbackHandler clientCallback = useCredentialStore ? this.createCredentialStoreBasedClientCallbackHandler("chris", null, "chris_pwd_alias", CS_FILE_NAME, "secret_store_1", "secret_key_1") : this.createClientCallbackHandler("chris", "secret".toCharArray(), null);
        this.client = Sasl.createSaslClient(new String[]{DIGEST}, "chris", "acap", "elwood.innosoft.com", clientProps, clientCallback);
        Assert.assertFalse((boolean)this.client.hasInitialResponse());
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message1 = "realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",qop=\"auth-conf\",charset=utf-8,cipher=\"rc4\",algorithm=md5-sess".getBytes(StandardCharsets.UTF_8);
        byte[] message2 = this.client.evaluateChallenge(message1);
        Assert.assertEquals((Object)"charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA9BSuZWMSpW8m\",digest-uri=\"acap/elwood.innosoft.com\",maxbuf=65536,response=4520cf48234bb93b95548a25cd56601b,qop=auth-conf,cipher=\"rc4\",authzid=\"chris\"", (Object)new String(message2, "UTF-8"));
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message3 = "rspauth=a804fda66588e2d911bbacd1b1163bc1".getBytes(StandardCharsets.UTF_8);
        byte[] message4 = this.client.evaluateChallenge(message3);
        Assert.assertEquals(null, (Object)message4);
        Assert.assertTrue((boolean)this.client.isComplete());
        byte[] outcoming1 = CodePointIterator.ofString((String)"11223344").hexDecode().drain();
        byte[] outcoming1wrapped = this.client.wrap(outcoming1, 0, outcoming1.length);
        Assert.assertEquals((Object)"6a9328ca634e47c8d1ecc3c3f6e6000100000000", (Object)ByteIterator.ofBytes((byte[])outcoming1wrapped).hexEncode().drainToString());
        byte[] incoming1 = CodePointIterator.ofString((String)"9fc7eb1c3c9e04b52df6e347a389000100000000").hexDecode().drain();
        byte[] incoming1unwrapped = this.client.unwrap(incoming1, 0, incoming1.length);
        Assert.assertEquals((Object)"55667788", (Object)ByteIterator.ofBytes((byte[])incoming1unwrapped).hexEncode().drainToString());
        byte[] outcoming2 = CodePointIterator.ofString((String)"aabbcc").hexDecode().drain();
        byte[] outcoming2wrapped = this.client.wrap(outcoming2, 0, outcoming2.length);
        Assert.assertEquals((Object)"7e15b940fccbb58a5612f54da7000100000001", (Object)ByteIterator.ofBytes((byte[])outcoming2wrapped).hexEncode().drainToString());
        byte[] incoming2 = new byte[]{};
        byte[] incoming2unwrapped = this.client.unwrap(incoming2, 0, incoming2.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])incoming2unwrapped).hexEncode().drainToString());
        byte[] incoming3 = CodePointIterator.ofString((String)"b0d829402149855796493cdf21000100000001").hexDecode().drain();
        byte[] incoming3unwrapped = this.client.unwrap(incoming3, 0, incoming3.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])incoming3unwrapped).hexEncode().drainToString());
        try {
            byte[] incoming4 = CodePointIterator.ofString((String)"a5a7390698ed8ab7ac667406a3000100000002").hexDecode().drain();
            this.client.unwrap(incoming4, 0, incoming4.length);
            Assert.fail((String)"Out of order sequencing SaslException expected!");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testQopAuthConfDes() throws Exception {
        this.mockNonce("OA9BSuZWMSpW8m");
        CallbackHandler clientCallback = this.createClientCallbackHandler("chris", "secret".toCharArray(), null);
        HashMap<String, String> clientProps = new HashMap<String, String>();
        clientProps.put(QOP_PROPERTY, "auth-conf");
        this.client = Sasl.createSaslClient(new String[]{DIGEST}, "chris", "acap", "elwood.innosoft.com", clientProps, clientCallback);
        Assert.assertFalse((boolean)this.client.hasInitialResponse());
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message1 = "realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",qop=\"auth-conf\",charset=utf-8,cipher=\"des\",algorithm=md5-sess".getBytes(StandardCharsets.UTF_8);
        byte[] message2 = this.client.evaluateChallenge(message1);
        Assert.assertEquals((Object)"charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA9BSuZWMSpW8m\",digest-uri=\"acap/elwood.innosoft.com\",maxbuf=65536,response=4520cf48234bb93b95548a25cd56601b,qop=auth-conf,cipher=\"des\",authzid=\"chris\"", (Object)new String(message2, "UTF-8"));
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message3 = "rspauth=a804fda66588e2d911bbacd1b1163bc1".getBytes(StandardCharsets.UTF_8);
        byte[] message4 = this.client.evaluateChallenge(message3);
        Assert.assertEquals(null, (Object)message4);
        Assert.assertTrue((boolean)this.client.isComplete());
        byte[] outcoming1 = CodePointIterator.ofString((String)"11223344").hexDecode().drain();
        byte[] outcoming1wrapped = this.client.wrap(outcoming1, 0, outcoming1.length);
        Assert.assertEquals((Object)"b2a12ba8ccd1030e7da4bac57a224197000100000000", (Object)ByteIterator.ofBytes((byte[])outcoming1wrapped).hexEncode().drainToString());
        byte[] incoming1 = CodePointIterator.ofString((String)"8bc1267e71a769456f0c60f030e13f32000100000000").hexDecode().drain();
        byte[] incoming1unwrapped = this.client.unwrap(incoming1, 0, incoming1.length);
        Assert.assertEquals((Object)"55667788", (Object)ByteIterator.ofBytes((byte[])incoming1unwrapped).hexEncode().drainToString());
        byte[] outcoming2 = CodePointIterator.ofString((String)"aabbcc").hexDecode().drain();
        byte[] outcoming2wrapped = this.client.wrap(outcoming2, 0, outcoming2.length);
        Assert.assertEquals((Object)"13144fc90ca65d3838d3547cca43e8ad000100000001", (Object)ByteIterator.ofBytes((byte[])outcoming2wrapped).hexEncode().drainToString());
        byte[] incoming2 = new byte[]{};
        byte[] incoming2unwrapped = this.client.unwrap(incoming2, 0, incoming2.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])incoming2unwrapped).hexEncode().drainToString());
        byte[] incoming3 = CodePointIterator.ofString((String)"54d717857f511fb1964a723e08bf810c000100000001").hexDecode().drain();
        byte[] incoming3unwrapped = this.client.unwrap(incoming3, 0, incoming3.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])incoming3unwrapped).hexEncode().drainToString());
        try {
            byte[] incoming4 = CodePointIterator.ofString((String)"44dd10b5277ee6c7de87cd0c3acacfad000100000002").hexDecode().drain();
            this.client.unwrap(incoming4, 0, incoming4.length);
            Assert.fail((String)"Out of order sequencing SaslException expected!");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testQopAuthConfRc456() throws Exception {
        this.mockNonce("OA9BSuZWMSpW8m");
        CallbackHandler clientCallback = this.createClientCallbackHandler("chris", "secret".toCharArray(), null);
        HashMap<String, String> clientProps = new HashMap<String, String>();
        clientProps.put(QOP_PROPERTY, "auth-conf");
        this.client = Sasl.createSaslClient(new String[]{DIGEST}, "chris", "acap", "elwood.innosoft.com", clientProps, clientCallback);
        Assert.assertFalse((boolean)this.client.hasInitialResponse());
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message1 = "realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",qop=\"auth-conf\",charset=utf-8,cipher=\"rc4-56\",algorithm=md5-sess".getBytes(StandardCharsets.UTF_8);
        byte[] message2 = this.client.evaluateChallenge(message1);
        Assert.assertEquals((Object)"charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA9BSuZWMSpW8m\",digest-uri=\"acap/elwood.innosoft.com\",maxbuf=65536,response=4520cf48234bb93b95548a25cd56601b,qop=auth-conf,cipher=\"rc4-56\",authzid=\"chris\"", (Object)new String(message2, "UTF-8"));
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message3 = "rspauth=a804fda66588e2d911bbacd1b1163bc1".getBytes(StandardCharsets.UTF_8);
        byte[] message4 = this.client.evaluateChallenge(message3);
        Assert.assertEquals(null, (Object)message4);
        Assert.assertTrue((boolean)this.client.isComplete());
        byte[] outcoming1 = CodePointIterator.ofString((String)"11223344").hexDecode().drain();
        byte[] outcoming1wrapped = this.client.wrap(outcoming1, 0, outcoming1.length);
        Assert.assertEquals((Object)"7a77c4b8b20208e502e5dc09bbfc000100000000", (Object)ByteIterator.ofBytes((byte[])outcoming1wrapped).hexEncode().drainToString());
        byte[] incoming1 = CodePointIterator.ofString((String)"c10acbf737cdebf2298df53417bc000100000000").hexDecode().drain();
        byte[] incoming1unwrapped = this.client.unwrap(incoming1, 0, incoming1.length);
        Assert.assertEquals((Object)"55667788", (Object)ByteIterator.ofBytes((byte[])incoming1unwrapped).hexEncode().drainToString());
        byte[] outcoming2 = CodePointIterator.ofString((String)"aabbcc").hexDecode().drain();
        byte[] outcoming2wrapped = this.client.wrap(outcoming2, 0, outcoming2.length);
        Assert.assertEquals((Object)"efcb8662925427788b0ffeab2c000100000001", (Object)ByteIterator.ofBytes((byte[])outcoming2wrapped).hexEncode().drainToString());
        byte[] incoming2 = new byte[]{};
        byte[] incoming2unwrapped = this.client.unwrap(incoming2, 0, incoming2.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])incoming2unwrapped).hexEncode().drainToString());
        byte[] incoming3 = CodePointIterator.ofString((String)"b18150d7204da90f0f733e3f73000100000001").hexDecode().drain();
        byte[] incoming3unwrapped = this.client.unwrap(incoming3, 0, incoming3.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])incoming3unwrapped).hexEncode().drainToString());
        try {
            byte[] incoming4 = CodePointIterator.ofString((String)"ed5cc6b9058c9e5f3a175cdcbf000100000002").hexDecode().drain();
            this.client.unwrap(incoming4, 0, incoming4.length);
            Assert.fail((String)"Out of order sequencing SaslException expected!");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testQopAuthConfRc440Classic() throws Exception {
        this.testQopAuthConfRc440(false);
    }

    @Test
    public void testQopAuthConfRc440CredentialStore() throws Exception {
        this.testQopAuthConfRc440(true);
    }

    public void testQopAuthConfRc440(boolean useCredentialStore) throws Exception {
        this.mockNonce("OA9BSuZWMSpW8m");
        HashMap<String, String> clientProps = new HashMap<String, String>();
        clientProps.put(QOP_PROPERTY, "auth-conf");
        CallbackHandler clientCallback = useCredentialStore ? this.createCredentialStoreBasedClientCallbackHandler("chris", null, "chris_pwd_alias", CS_FILE_NAME, "secret_store_1", "secret_key_1") : this.createClientCallbackHandler("chris", "secret".toCharArray(), null);
        this.client = Sasl.createSaslClient(new String[]{DIGEST}, "chris", "acap", "elwood.innosoft.com", clientProps, clientCallback);
        Assert.assertFalse((boolean)this.client.hasInitialResponse());
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message1 = "realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",qop=\"auth-conf\",charset=utf-8,cipher=\"rc4-40\",algorithm=md5-sess".getBytes(StandardCharsets.UTF_8);
        byte[] message2 = this.client.evaluateChallenge(message1);
        Assert.assertEquals((Object)"charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA9BSuZWMSpW8m\",digest-uri=\"acap/elwood.innosoft.com\",maxbuf=65536,response=4520cf48234bb93b95548a25cd56601b,qop=auth-conf,cipher=\"rc4-40\",authzid=\"chris\"", (Object)new String(message2, "UTF-8"));
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message3 = "rspauth=a804fda66588e2d911bbacd1b1163bc1".getBytes(StandardCharsets.UTF_8);
        byte[] message4 = this.client.evaluateChallenge(message3);
        Assert.assertEquals(null, (Object)message4);
        Assert.assertTrue((boolean)this.client.isComplete());
        byte[] outcoming1 = CodePointIterator.ofString((String)"11223344").hexDecode().drain();
        byte[] outcoming1wrapped = this.client.wrap(outcoming1, 0, outcoming1.length);
        Assert.assertEquals((Object)"ed46c6b0d38acb719aad661f9625000100000000", (Object)ByteIterator.ofBytes((byte[])outcoming1wrapped).hexEncode().drainToString());
        byte[] incoming1 = CodePointIterator.ofString((String)"44aca6145a89353d26258e524724000100000000").hexDecode().drain();
        byte[] incoming1unwrapped = this.client.unwrap(incoming1, 0, incoming1.length);
        Assert.assertEquals((Object)"55667788", (Object)ByteIterator.ofBytes((byte[])incoming1unwrapped).hexEncode().drainToString());
        byte[] outcoming2 = CodePointIterator.ofString((String)"aabbcc").hexDecode().drain();
        byte[] outcoming2wrapped = this.client.wrap(outcoming2, 0, outcoming2.length);
        Assert.assertEquals((Object)"b7bdc8f08733182154289e7f3d000100000001", (Object)ByteIterator.ofBytes((byte[])outcoming2wrapped).hexEncode().drainToString());
        byte[] incoming2 = new byte[]{};
        byte[] incoming2unwrapped = this.client.unwrap(incoming2, 0, incoming2.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])incoming2unwrapped).hexEncode().drainToString());
        byte[] incoming3 = CodePointIterator.ofString((String)"685082d4671e03ac60df93d1b9000100000001").hexDecode().drain();
        byte[] incoming3unwrapped = this.client.unwrap(incoming3, 0, incoming3.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])incoming3unwrapped).hexEncode().drainToString());
        try {
            byte[] incoming4 = CodePointIterator.ofString((String)"c7b5198826c7066b48e474db0c000100000002").hexDecode().drain();
            this.client.unwrap(incoming4, 0, incoming4.length);
            Assert.fail((String)"Out of order sequencing SaslException expected!");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testQopAuthConfUnknown() throws Exception {
        this.mockNonce("OA9BSuZWMSpW8m");
        CallbackHandler clientCallback = this.createClientCallbackHandler("chris", "secret".toCharArray(), null);
        HashMap<String, String> clientProps = new HashMap<String, String>();
        clientProps.put(QOP_PROPERTY, "auth-conf");
        this.client = Sasl.createSaslClient(new String[]{DIGEST}, "chris", "acap", "elwood.innosoft.com", clientProps, clientCallback);
        Assert.assertFalse((boolean)this.client.hasInitialResponse());
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message1 = "realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",qop=\"auth-conf\",charset=utf-8,cipher=\"unknown\",algorithm=md5-sess".getBytes(StandardCharsets.UTF_8);
        try {
            this.client.evaluateChallenge(message1);
            Assert.fail((String)"Not thrown SaslException!");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.client.isComplete());
    }

    @Test
    public void testMoreRealmsFromServer() throws Exception {
        this.mockNonce("OA6MHXh6VqTrRk");
        CallbackHandler clientCallback = this.createClientCallbackHandler("chris", "secret".toCharArray(), "elwood.innosoft.com");
        this.client = Sasl.createSaslClient(new String[]{DIGEST}, null, "imap", "elwood.innosoft.com", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message1 = "realm=\"other-realm\",realm=\"elwood.innosoft.com\",realm=\"next-realm\",nonce=\"OA6MG9tEQGm2hh\",qop=\"auth\",algorithm=md5-sess,charset=utf-8".getBytes(StandardCharsets.UTF_8);
        byte[] message2 = this.client.evaluateChallenge(message1);
        Assert.assertEquals((Object)"charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA6MG9tEQGm2hh\",nc=00000001,cnonce=\"OA6MHXh6VqTrRk\",digest-uri=\"imap/elwood.innosoft.com\",maxbuf=65536,response=d388dad90d4bbd760a152321f2143af7,qop=auth", (Object)new String(message2, "UTF-8"));
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message3 = "rspauth=ea40f60335c427b5527b84dbabcdfffd".getBytes(StandardCharsets.UTF_8);
        byte[] message4 = this.client.evaluateChallenge(message3);
        Assert.assertEquals(null, (Object)message4);
        Assert.assertTrue((boolean)this.client.isComplete());
    }

    @Test
    public void testNoRealmsFromServer() throws Exception {
        this.mockNonce("OA6MHXh6VqTrRk");
        CallbackHandler clientCallback = this.createClientCallbackHandler("chris", "secret".toCharArray(), null);
        this.client = Sasl.createSaslClient(new String[]{DIGEST}, null, "imap", "elwood.innosoft.com", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message1 = "nonce=\"OA6MG9tEQGm2hh\",qop=\"auth\",algorithm=md5-sess,charset=utf-8".getBytes(StandardCharsets.UTF_8);
        byte[] message2 = this.client.evaluateChallenge(message1);
        Assert.assertEquals((Object)"charset=utf-8,username=\"chris\",nonce=\"OA6MG9tEQGm2hh\",nc=00000001,cnonce=\"OA6MHXh6VqTrRk\",digest-uri=\"imap/elwood.innosoft.com\",maxbuf=65536,response=695dcc815019923b9d438fd28c641aa9,qop=auth", (Object)new String(message2, "UTF-8"));
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message3 = "rspauth=ef0a550cd88d926ff426790bef156af3".getBytes(StandardCharsets.UTF_8);
        byte[] message4 = this.client.evaluateChallenge(message3);
        Assert.assertEquals(null, (Object)message4);
        Assert.assertTrue((boolean)this.client.isComplete());
    }

    @Test
    public void testNoServerNonce() throws Exception {
        CallbackHandler clientCallback = this.createClientCallbackHandler("chris", "secret".toCharArray(), null);
        this.client = Sasl.createSaslClient(new String[]{DIGEST}, null, "imap", "elwood.innosoft.com", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message1 = "qop=\"auth\",algorithm=md5-sess,charset=utf-8".getBytes(StandardCharsets.UTF_8);
        try {
            this.client.evaluateChallenge(message1);
            Assert.fail((String)"Not thrown SaslException!");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.client.isComplete());
    }

    @Test
    public void testBlankServerNonce() throws Exception {
        this.mockNonce("OA6MHXh6VqTrRk");
        CallbackHandler clientCallback = this.createClientCallbackHandler("chris", "secret".toCharArray(), null);
        this.client = Sasl.createSaslClient(new String[]{DIGEST}, null, "imap", "elwood.innosoft.com", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message1 = "nonce=\"\",qop=\"auth\",algorithm=md5-sess,charset=utf-8".getBytes(StandardCharsets.UTF_8);
        byte[] message2 = this.client.evaluateChallenge(message1);
        Assert.assertEquals((Object)"charset=utf-8,username=\"chris\",nonce=\"\",nc=00000001,cnonce=\"OA6MHXh6VqTrRk\",digest-uri=\"imap/elwood.innosoft.com\",maxbuf=65536,response=c87a63a455fed82d007a7996d49a51bc,qop=auth", (Object)new String(message2, "UTF-8"));
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message3 = "rspauth=fa4e5be53f9b154858fb82d96c93a03a".getBytes(StandardCharsets.UTF_8);
        byte[] message4 = this.client.evaluateChallenge(message3);
        Assert.assertEquals(null, (Object)message4);
        Assert.assertTrue((boolean)this.client.isComplete());
    }

    @Test
    public void testUtf8Charset() throws Exception {
        this.mockNonce("cn\u0438\u4f60\ud83c\udca1");
        CallbackHandler clientCallback = this.createClientCallbackHandler("\u0438\u4f60\ud83c\udca1", "\u0438\u4f60\ud83c\udca1".toCharArray(), null);
        this.client = Sasl.createSaslClient(new String[]{DIGEST}, null, "\u0438\u4f60\ud83c\udca1", "realm.\u0438\u4f60\ud83c\udca1.com", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message1 = "realm=\"realm.\u0438\u4f60\ud83c\udca1.com\",nonce=\"sn\u0438\u4f60\ud83c\udca1\",charset=utf-8,algorithm=md5-sess".getBytes(StandardCharsets.UTF_8);
        byte[] message2 = this.client.evaluateChallenge(message1);
        Assert.assertEquals((Object)"charset=utf-8,username=\"\u0438\u4f60\ud83c\udca1\",realm=\"realm.\u0438\u4f60\ud83c\udca1.com\",nonce=\"sn\u0438\u4f60\ud83c\udca1\",nc=00000001,cnonce=\"cn\u0438\u4f60\ud83c\udca1\",digest-uri=\"\u0438\u4f60\ud83c\udca1/realm.\u0438\u4f60\ud83c\udca1.com\",maxbuf=65536,response=420939e06d2d748c157c5e33499b41a9,qop=auth", (Object)new String(message2, StandardCharsets.UTF_8));
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message3 = "rspauth=9c4d137545617ba98c11aaea939b4381".getBytes(StandardCharsets.UTF_8);
        byte[] message4 = this.client.evaluateChallenge(message3);
        Assert.assertEquals(null, (Object)message4);
        Assert.assertTrue((boolean)this.client.isComplete());
    }

    @Test
    public void testMoreRealmsWithEscapedDelimiters() throws Exception {
        this.mockNonce("OA6MHXh6VqTrRk");
        CallbackHandler clientCallback = this.createClientCallbackHandler("chris", "secret".toCharArray(), "first realm");
        this.client = Sasl.createSaslClient(new String[]{DIGEST}, null, "protocol name", "server name", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message1 = "realm=\"first realm\",realm=\"second\\\\ realm\",realm=\" with spaces \",realm=\" \",nonce=\"OA9BSXrbuRhWay\",charset=utf-8,algorithm=md5-sess".getBytes(StandardCharsets.UTF_8);
        byte[] message2 = this.client.evaluateChallenge(message1);
        Assert.assertEquals((Object)"charset=utf-8,username=\"chris\",realm=\"first realm\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA6MHXh6VqTrRk\",digest-uri=\"protocol name/server name\",maxbuf=65536,response=bf3dd710ee08b05c663456975c156075,qop=auth", (Object)new String(message2, "UTF-8"));
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message3 = "rspauth=05a18aff49b22e373bb91af7396ce345".getBytes(StandardCharsets.UTF_8);
        byte[] message4 = this.client.evaluateChallenge(message3);
        Assert.assertEquals(null, (Object)message4);
        Assert.assertTrue((boolean)this.client.isComplete());
    }

    @Test
    public void testWrongStepThreeRspauth() throws Exception {
        this.mockNonce("OA6MHXh6VqTrRk");
        CallbackHandler clientCallback = this.createClientCallbackHandler("chris", "secret".toCharArray(), null);
        this.client = Sasl.createSaslClient(new String[]{DIGEST}, null, "imap", "elwood.innosoft.com", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message1 = "realm=\"elwood.innosoft.com\",nonce=\"OA6MG9tEQGm2hh\",qop=\"auth\",algorithm=md5-sess,charset=utf-8".getBytes(StandardCharsets.UTF_8);
        byte[] message2 = this.client.evaluateChallenge(message1);
        Assert.assertEquals((Object)"charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA6MG9tEQGm2hh\",nc=00000001,cnonce=\"OA6MHXh6VqTrRk\",digest-uri=\"imap/elwood.innosoft.com\",maxbuf=65536,response=d388dad90d4bbd760a152321f2143af7,qop=auth", (Object)new String(message2, "UTF-8"));
        Assert.assertFalse((boolean)this.client.isComplete());
        byte[] message3 = "rspauth=ab66f60335c427b5527b84dbabcdaacc".getBytes(StandardCharsets.UTF_8);
        try {
            this.client.evaluateChallenge(message3);
            Assert.fail((String)"Not thrown SaslException!");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.client.isComplete());
    }

    @Test
    public void testQopSelection1() throws Exception {
        this.mockNonce("+7HQhcJThEsqZ3gor1hThC5on8hQ3DRP2esrw+km");
        HashMap<String, String> clientProps = new HashMap<String, String>();
        clientProps.put(QOP_PROPERTY, "auth-conf,auth-int,auth");
        CallbackHandler clientCallback = this.createClientCallbackHandler("user", "password".toCharArray(), null);
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "user", "TestProtocol", "TestServer", clientProps, clientCallback);
        Assert.assertFalse((boolean)client.isComplete());
        byte[] message1 = "realm=\"TestServer\",nonce=\"288HcNYUg60jN/kEFYT/HklRVjZA6opb2if8tsja\",qop=\"auth,auth-int\",charset=utf-8,algorithm=md5-sess".getBytes(StandardCharsets.UTF_8);
        byte[] message2 = client.evaluateChallenge(message1);
        Assert.assertEquals((Object)"charset=utf-8,username=\"user\",realm=\"TestServer\",nonce=\"288HcNYUg60jN/kEFYT/HklRVjZA6opb2if8tsja\",nc=00000001,cnonce=\"+7HQhcJThEsqZ3gor1hThC5on8hQ3DRP2esrw+km\",digest-uri=\"TestProtocol/TestServer\",maxbuf=65536,response=663997cd2a9dc34c84240430fb1be16c,qop=auth-int,authzid=\"user\"", (Object)new String(message2, "UTF-8"));
        Assert.assertFalse((boolean)client.isComplete());
        byte[] message3 = "rspauth=b3d6f9165b0bb0972adaa5778b840c3a".getBytes(StandardCharsets.UTF_8);
        byte[] message4 = client.evaluateChallenge(message3);
        Assert.assertEquals(null, (Object)message4);
        Assert.assertTrue((boolean)client.isComplete());
    }

    @Test
    public void testQopSelection2() throws Exception {
        this.mockNonce("a7YfTdcWo4L0OeurbYrT9G+01rZiNe6LSWuCSo73");
        HashMap<String, String> clientProps = new HashMap<String, String>();
        clientProps.put(QOP_PROPERTY, "auth-conf,auth,auth-int");
        CallbackHandler clientCallback = this.createClientCallbackHandler("user", "password".toCharArray(), null);
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "user", "TestProtocol", "TestServer", clientProps, clientCallback);
        Assert.assertFalse((boolean)client.isComplete());
        byte[] message1 = "realm=\"TestServer\",nonce=\"QduN0itdkfbx8VqlrWt56ZS7uRhI2Rt3P8bqfsM/\",qop=\"auth-int,auth\",charset=utf-8,algorithm=md5-sess".getBytes(StandardCharsets.UTF_8);
        byte[] message2 = client.evaluateChallenge(message1);
        Assert.assertEquals((Object)"charset=utf-8,username=\"user\",realm=\"TestServer\",nonce=\"QduN0itdkfbx8VqlrWt56ZS7uRhI2Rt3P8bqfsM/\",nc=00000001,cnonce=\"a7YfTdcWo4L0OeurbYrT9G+01rZiNe6LSWuCSo73\",digest-uri=\"TestProtocol/TestServer\",maxbuf=65536,response=636d1e3c3d73e1bfb15f85957720ce35,qop=auth,authzid=\"user\"", (Object)new String(message2, "UTF-8"));
        Assert.assertFalse((boolean)client.isComplete());
        byte[] message3 = "rspauth=a77854059f533745d50abb064b7df938".getBytes(StandardCharsets.UTF_8);
        byte[] message4 = client.evaluateChallenge(message3);
        Assert.assertEquals(null, (Object)message4);
        Assert.assertTrue((boolean)client.isComplete());
    }

    @Test
    public void testQopSelectionFail() throws Exception {
        HashMap<String, String> clientProps = new HashMap<String, String>();
        clientProps.put(QOP_PROPERTY, "auth-conf");
        CallbackHandler clientCallback = this.createClientCallbackHandler("user", "password".toCharArray(), null);
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "user", "TestProtocol", "TestServer", clientProps, clientCallback);
        Assert.assertFalse((boolean)client.isComplete());
        byte[] message1 = "realm=\"TestServer\",nonce=\"QduN0itdkfbx8VqlrWt56ZS7uRhI2Rt3P8bqfsM/\",qop=\"auth-int,auth\",charset=utf-8,algorithm=md5-sess".getBytes(StandardCharsets.UTF_8);
        try {
            client.evaluateChallenge(message1);
            Assert.fail((String)"Not thrown SaslException!");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)client.isComplete());
    }

    @Test
    public void testStaleNonce() throws Exception {
        this.mockNonce("OA6MHXh6VqTrRk");
        HashMap clientProps = new HashMap();
        CallbackHandler clientCallback = this.createClientCallbackHandler("chris", "secret".toCharArray(), null);
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, null, "imap", "elwood.innosoft.com", clientProps, clientCallback);
        Assert.assertNotNull((Object)client);
        Assert.assertFalse((boolean)client.isComplete());
        byte[] message1 = "realm=\"elwood.innosoft.com\",nonce=\"tooOldNonce\",qop=\"auth\",algorithm=md5-sess,charset=utf-8".getBytes(StandardCharsets.UTF_8);
        byte[] message2 = client.evaluateChallenge(message1);
        Assert.assertFalse((boolean)client.isComplete());
        byte[] message3 = "stale=true,realm=\"elwood.innosoft.com\",nonce=\"OA6MG9tEQGm2hh\",qop=\"auth\",algorithm=md5-sess,charset=utf-8".getBytes(StandardCharsets.UTF_8);
        byte[] message4 = client.evaluateChallenge(message3);
        Assert.assertEquals((Object)"charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA6MG9tEQGm2hh\",nc=00000001,cnonce=\"OA6MHXh6VqTrRk\",digest-uri=\"imap/elwood.innosoft.com\",maxbuf=65536,response=d388dad90d4bbd760a152321f2143af7,qop=auth", (Object)new String(message4, "UTF-8"));
        Assert.assertFalse((boolean)client.isComplete());
        byte[] message5 = "rspauth=ea40f60335c427b5527b84dbabcdfffd".getBytes(StandardCharsets.UTF_8);
        byte[] message6 = client.evaluateChallenge(message5);
        Assert.assertEquals(null, (Object)message6);
        Assert.assertTrue((boolean)client.isComplete());
    }

    private CallbackHandler createClientCallbackHandler(String username, char[] password, String realm) throws Exception {
        AuthenticationContext context = AuthenticationContext.empty().with(MatchRule.ALL, AuthenticationConfiguration.empty().useName(username).usePassword(password).useRealm(realm).setSaslMechanismSelector(SaslMechanismSelector.NONE.addMechanism(DIGEST)));
        return ClientUtils.getCallbackHandler(new URI("doesnot://matter?"), context);
    }

    private CallbackHandler createCredentialStoreBasedClientCallbackHandler(String username, String realm, String alias, String storeFileName, String storePassword, String keyPassword) throws Exception {
        CredentialStore cs;
        HashMap<String, String> csAttributes = new HashMap<String, String>();
        csAttributes.put("location", storeFileName);
        csAttributes.put("keyStoreType", "JCEKS");
        try {
            cs = CredentialStore.getInstance((String)KeyStoreCredentialStore.KEY_STORE_CREDENTIAL_STORE);
            cs.initialize(csAttributes, (CredentialStore.ProtectionParameter)new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)IdentityCredentials.NONE.withCredential((Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])storePassword.toCharArray())))));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        AuthenticationContext context = AuthenticationContext.empty().with(MatchRule.ALL, AuthenticationConfiguration.empty().useName(username).useCredentialStoreEntry(cs, alias).useRealm(realm).setSaslMechanismSelector(SaslMechanismSelector.NONE.addMechanism(DIGEST)));
        return ClientUtils.getCallbackHandler(new URI("doesnot://matter"), context);
    }
}

