/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import java.io.FilePermission;
import java.security.Permission;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.audit.SimpleSecurityEventFormatter;
import org.wildfly.security.auth.realm.SimpleMapBackedSecurityRealm;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.event.SecurityAuthenticationSuccessfulEvent;
import org.wildfly.security.auth.server.event.SecurityEvent;
import org.wildfly.security.auth.server.event.SecurityEventVisitor;
import org.wildfly.security.auth.server.event.SecurityPermissionCheckFailedEvent;

public class SimpleSecurityEventFormatterTest {
    private static SecurityEventVisitor<?, String> simpleFormatter;
    private static SecurityDomain securityDomain;

    @BeforeClass
    public static void createDomain() {
        simpleFormatter = SimpleSecurityEventFormatter.builder().build();
        securityDomain = SecurityDomain.builder().addRealm("Simple", (SecurityRealm)new SimpleMapBackedSecurityRealm()).build().setDefaultRealmName("Simple").build();
    }

    private String baseTest(SecurityEvent event) {
        String formatted = (String)event.accept(simpleFormatter, null);
        System.out.println(formatted);
        Assert.assertTrue((String)"Event Time", (boolean)formatted.contains("event-time="));
        Assert.assertTrue((String)"Security Identity", (boolean)formatted.contains("security-identity="));
        Assert.assertTrue((String)"Identity Name", (boolean)formatted.contains("name=anonymous"));
        Assert.assertTrue((String)"Identity Creation Time", (boolean)formatted.contains("creation-time="));
        return formatted;
    }

    @Test
    public void testAuthenticationSuccessful() {
        String formatted = this.baseTest((SecurityEvent)new SecurityAuthenticationSuccessfulEvent(securityDomain.getCurrentSecurityIdentity()));
        Assert.assertTrue((String)"Event", (boolean)formatted.contains("event=SecurityAuthenticationSuccessfulEvent"));
        Assert.assertTrue((String)"Success", (boolean)formatted.contains("success=true"));
    }

    @Test
    public void testPermissionCheckFailed() {
        String formatted = this.baseTest((SecurityEvent)new SecurityPermissionCheckFailedEvent(securityDomain.getCurrentSecurityIdentity(), (Permission)new FilePermission("/etc", "read")));
        Assert.assertTrue((String)"Event", (boolean)formatted.contains("event=SecurityPermissionCheckFailedEvent"));
        Assert.assertTrue((String)"Success", (boolean)formatted.contains("success=false"));
        Assert.assertTrue((String)"Permission", (boolean)formatted.contains("permission="));
        Assert.assertTrue((String)"Permission Type", (boolean)formatted.contains("type=java.io.FilePermission"));
        Assert.assertTrue((String)"Permission Actions", (boolean)formatted.contains("actions=read"));
        Assert.assertTrue((String)"Permission Name", (boolean)formatted.contains("name=/etc"));
    }
}

