/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.scram;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.spec.KeySpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.IteratedSaltedHashPasswordSpec;
import org.wildfly.security.sasl.scram.ScramCallbackHandlerUtils;
import org.wildfly.security.sasl.scram.ScramSaslClient;
import org.wildfly.security.sasl.scram.ScramSaslClientFactory;
import org.wildfly.security.sasl.scram.ScramSaslServerFactory;
import org.wildfly.security.sasl.scram.WildFlyElytronSaslScramProvider;
import org.wildfly.security.sasl.test.SaslServerBuilder;
import org.wildfly.security.sasl.test.SaslTestUtil;
import org.wildfly.security.sasl.util.AbstractSaslParticipant;
import org.wildfly.security.sasl.util.ChannelBindingSaslClientFactory;

public class BasicScramSelfTest {
    private static final Provider[] providers = new Provider[]{WildFlyElytronSaslScramProvider.getInstance()};
    private static final Map<String, Object> EMPTY = Collections.emptyMap();

    @BeforeClass
    public static void registerPasswordProvider() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                for (Provider provider : providers) {
                    Security.insertProviderAt(provider, 2);
                }
                return null;
            }
        });
    }

    @AfterClass
    public static void removePasswordProvider() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                for (Provider provider : providers) {
                    Security.removeProvider(provider.getName());
                }
                return null;
            }
        });
    }

    @Test
    public void testAuthenticationSha1ClearPassword() throws Exception {
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1").setUserName("user").setPassword("pencil".toCharArray()).build();
        CallbackHandler clientHandler = ScramCallbackHandlerUtils.createClientCallbackHandler("user", "pencil".toCharArray());
        this.testAuthentication("SCRAM-SHA-1", saslServer, clientHandler, "user", EMPTY);
    }

    @Test(expected=SaslException.class)
    public void testAuthenticationSha1ClearPasswordBadUsername() throws Exception {
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1").setUserName("user").setPassword("pencil".toCharArray()).build();
        CallbackHandler clientHandler = ScramCallbackHandlerUtils.createClientCallbackHandler("wrong", "pencil".toCharArray());
        this.testAuthentication("SCRAM-SHA-1", saslServer, clientHandler, "user", EMPTY);
    }

    @Test(expected=SaslException.class)
    public void testAuthenticationSha1ClearPasswordBadPassword() throws Exception {
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1").setUserName("user").setPassword("pencil".toCharArray()).build();
        CallbackHandler clientHandler = ScramCallbackHandlerUtils.createClientCallbackHandler("user", "wrong".toCharArray());
        this.testAuthentication("SCRAM-SHA-1", saslServer, clientHandler, "user", EMPTY);
    }

    @Test
    public void testAuthenticationSha1ClearCredentialPassword() throws Exception {
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1").setUserName("user").setPassword("pencil".toCharArray()).build();
        CallbackHandler clientHandler = ScramCallbackHandlerUtils.createClientCallbackHandler("user", "pencil".toCharArray());
        this.testAuthentication("SCRAM-SHA-1", saslServer, clientHandler, "user", EMPTY);
    }

    @Test
    public void testAuthenticationSha1ClearCredential() throws Exception {
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1").setUserName("user").setPassword("pencil".toCharArray()).build();
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"clear");
        Password password = passwordFactory.generatePassword((KeySpec)new ClearPasswordSpec("pencil".toCharArray()));
        CallbackHandler clientHandler = ScramCallbackHandlerUtils.createClientCallbackHandler("user", password);
        this.testAuthentication("SCRAM-SHA-1", saslServer, clientHandler, "user", EMPTY);
    }

    @Test
    public void testAuthenticationSha1ScramCredential() throws Exception {
        byte[] digest = new byte[]{29, -106, -18, 58, 82, -101, 90, 95, -98, 71, -64, 31, 34, -102, 44, -72, -90, -31, 95, 125};
        byte[] salt = new byte[]{65, 37, -62, 71, -28, 58, -79, -23, 60, 109, -1, 118};
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1").setUserName("user").setPassword("scram-sha-1", (KeySpec)new IteratedSaltedHashPasswordSpec(digest, salt, 4096)).build();
        CallbackHandler clientHandler = ScramCallbackHandlerUtils.createClientCallbackHandler("user", "pencil".toCharArray());
        this.testAuthentication("SCRAM-SHA-1", saslServer, clientHandler, "user", EMPTY);
    }

    @Test
    public void testAuthenticationSha1ScramCredentialBindingData() throws Exception {
        byte[] digest = new byte[]{29, -106, -18, 58, 82, -101, 90, 95, -98, 71, -64, 31, 34, -102, 44, -72, -90, -31, 95, 125};
        byte[] salt = new byte[]{65, 37, -62, 71, -28, 58, -79, -23, 60, 109, -1, 118};
        CallbackHandler clientHandler = ScramCallbackHandlerUtils.createClientCallbackHandler("user", "pencil".toCharArray());
        ChannelBindingSaslClientFactory clientFactory = new ChannelBindingSaslClientFactory(this.obtainSaslClientFactory(), "type1", new byte[]{-2, -36, 16});
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1-PLUS").setUserName("user").setPassword("scram-sha-1", (KeySpec)new IteratedSaltedHashPasswordSpec(digest, salt, 4096)).setChannelBinding("type1", new byte[]{-2, -36, 16}).build();
        this.testAuthentication("SCRAM-SHA-1-PLUS", saslServer, (SaslClientFactory)clientFactory, clientHandler, "user", EMPTY);
    }

    @Test
    public void testAuthenticationSha1ScramCredentialBindingDataRequired() throws Exception {
        byte[] digest = new byte[]{29, -106, -18, 58, 82, -101, 90, 95, -98, 71, -64, 31, 34, -102, 44, -72, -90, -31, 95, 125};
        byte[] salt = new byte[]{65, 37, -62, 71, -28, 58, -79, -23, 60, 109, -1, 118};
        CallbackHandler clientHandler = ScramCallbackHandlerUtils.createClientCallbackHandler("user", "pencil".toCharArray());
        ChannelBindingSaslClientFactory clientFactory = new ChannelBindingSaslClientFactory(this.obtainSaslClientFactory(), "same-type2", new byte[]{-2, -36, 18});
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("wildfly.sasl.channel-binding-required", "true");
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1-PLUS").setUserName("user").setPassword("scram-sha-1", (KeySpec)new IteratedSaltedHashPasswordSpec(digest, salt, 4096)).setChannelBinding("same-type2", new byte[]{-2, -36, 18}).setProperties(new HashMap<String, Object>(props)).build();
        this.testAuthentication("SCRAM-SHA-1-PLUS", saslServer, (SaslClientFactory)clientFactory, clientHandler, "user", props);
    }

    @Test
    public void testNonPlusClientWithoutBindingWithPlusServer() throws Exception {
        byte[] digest = new byte[]{29, -106, -18, 58, 82, -101, 90, 95, -98, 71, -64, 31, 34, -102, 44, -72, -90, -31, 95, 125};
        byte[] salt = new byte[]{65, 37, -62, 71, -28, 58, -79, -23, 60, 109, -1, 118};
        CallbackHandler clientHandler = ScramCallbackHandlerUtils.createClientCallbackHandler("user", "pencil".toCharArray());
        SaslClientFactory clientFactory = this.obtainSaslClientFactory();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("wildfly.sasl.channel-binding-required", "false");
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1-PLUS").setUserName("user").setPassword("scram-sha-1", (KeySpec)new IteratedSaltedHashPasswordSpec(digest, salt, 4096)).setProperties(new HashMap<String, Object>(props)).setChannelBinding("same-type2", new byte[]{-2, -36, 18}).build();
        Assert.assertNotNull((Object)clientFactory);
        SaslClient saslClient = clientFactory.createSaslClient(new String[]{"SCRAM-SHA-1"}, "user", "test", "localhost", props, clientHandler);
        Assert.assertNotNull((Object)saslClient);
        Assert.assertTrue((boolean)(saslClient instanceof ScramSaslClient));
        byte[] message = AbstractSaslParticipant.NO_BYTES;
        try {
            while ((message = saslClient.evaluateChallenge(message)) != null && (message = saslServer.evaluateResponse(message)) != null) {
            }
            Assert.fail((String)"SaslException expected");
        }
        catch (SaslException cause) {
            Assert.assertTrue((boolean)cause.getMessage().contains("server-does-support-channel-binding"));
        }
    }

    @Test
    public void testPlusClientWithBindingWithNonPlusServer() throws Exception {
        byte[] digest = new byte[]{29, -106, -18, 58, 82, -101, 90, 95, -98, 71, -64, 31, 34, -102, 44, -72, -90, -31, 95, 125};
        byte[] salt = new byte[]{65, 37, -62, 71, -28, 58, -79, -23, 60, 109, -1, 118};
        CallbackHandler clientHandler = ScramCallbackHandlerUtils.createClientCallbackHandler("user", "pencil".toCharArray());
        ChannelBindingSaslClientFactory clientFactory = new ChannelBindingSaslClientFactory(this.obtainSaslClientFactory(), "same-type2", new byte[]{-2, -36, 18});
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("wildfly.sasl.channel-binding-required", "false");
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1").setUserName("user").setPassword("scram-sha-1", (KeySpec)new IteratedSaltedHashPasswordSpec(digest, salt, 4096)).setProperties(new HashMap<String, Object>(props)).build();
        Assert.assertNotNull((Object)clientFactory);
        SaslClient saslClient = clientFactory.createSaslClient(new String[]{"SCRAM-SHA-1-PLUS"}, "user", "test", "localhost", props, clientHandler);
        Assert.assertNotNull((Object)saslClient);
        Assert.assertTrue((boolean)(saslClient instanceof ScramSaslClient));
        byte[] message = AbstractSaslParticipant.NO_BYTES;
        try {
            while ((message = saslClient.evaluateChallenge(message)) != null && (message = saslServer.evaluateResponse(message)) != null) {
            }
            Assert.fail((String)"SaslException expected");
        }
        catch (SaslException cause) {
            Assert.assertTrue((boolean)cause.getMessage().contains("server-does-not-support-channel-binding"));
        }
    }

    private void testAuthentication(String mechanism, SaslServer saslServer, CallbackHandler clientHandler, String authorizationId, Map<String, ?> clientProps) throws Exception {
        SaslClientFactory clientFactory = this.obtainSaslClientFactory();
        Assert.assertNotNull((Object)clientFactory);
        this.testAuthentication(mechanism, saslServer, clientFactory, clientHandler, authorizationId, clientProps);
    }

    private void testAuthentication(String mechanism, SaslServer saslServer, SaslClientFactory clientFactory, CallbackHandler clientHandler, String authorizationId, Map<String, ?> clientProps) throws Exception {
        Assert.assertEquals((Object)mechanism, (Object)saslServer.getMechanismName());
        Assert.assertNotNull((Object)clientFactory);
        SaslClient saslClient = clientFactory.createSaslClient(new String[]{mechanism}, authorizationId, "test", "localhost", clientProps, clientHandler);
        Assert.assertNotNull((Object)saslClient);
        Assert.assertTrue((boolean)(saslClient instanceof ScramSaslClient));
        byte[] message = AbstractSaslParticipant.NO_BYTES;
        while ((message = saslClient.evaluateChallenge(message)) != null && (message = saslServer.evaluateResponse(message)) != null) {
        }
        Assert.assertTrue((boolean)saslServer.isComplete());
        Assert.assertTrue((boolean)saslClient.isComplete());
    }

    private SaslClientFactory obtainSaslClientFactory() {
        SaslClientFactory clientFactory = SaslTestUtil.obtainSaslClientFactory(ScramSaslClientFactory.class);
        Assert.assertTrue((boolean)(clientFactory instanceof ScramSaslClientFactory));
        return clientFactory;
    }
}

