/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.WildFlyElytronProvider;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.realm.KeyStoreBackedSecurityRealm;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.permission.PermissionVerifier;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.SSLAuthenticationTest;
import org.wildfly.security.ssl.SSLContextBuilder;
import org.wildfly.security.ssl.test.util.CAGenerationTool;
import org.wildfly.security.x500.principal.X500AttributePrincipalDecoder;

public class TLS13AuthenticationTest {
    private static final char[] PASSWORD = "Elytron".toCharArray();
    private static final String CA_JKS_LOCATION = "./target/test-classes/jks";
    private static CAGenerationTool caGenerationTool = null;
    private static SecurityDomain securityDomain = null;

    @BeforeClass
    public static void setUp() throws Exception {
        Assume.assumeTrue((String)"Skipping TLS13AuthenticationTest suite, tests are not being run on JDK 11.", (boolean)System.getProperty("java.specification.version").equals("11"));
        caGenerationTool = CAGenerationTool.builder().setBaseDir(CA_JKS_LOCATION).setRequestIdentities(new CAGenerationTool.Identity[]{CAGenerationTool.Identity.LADYBIRD, CAGenerationTool.Identity.SCARAB}).build();
        KeyStoreBackedSecurityRealm securityRealm = new KeyStoreBackedSecurityRealm(TLS13AuthenticationTest.loadKeyStore("/jks/beetles.keystore"));
        securityDomain = SecurityDomain.builder().addRealm("KeystoreRealm", (SecurityRealm)securityRealm).build().setDefaultRealmName("KeystoreRealm").setPrincipalDecoder((PrincipalDecoder)new X500AttributePrincipalDecoder("2.5.4.3", 1)).setPreRealmRewriter(s -> s.toLowerCase(Locale.ENGLISH)).setPermissionMapper((permissionMappable, roles) -> PermissionVerifier.ALL).build();
    }

    @AfterClass
    public static void cleanUp() throws IOException {
        caGenerationTool.close();
    }

    @Test
    public void testTwoWayTLS13() throws Exception {
        String CIPHER_SUITE = "TLS_AES_128_GCM_SHA256";
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(securityDomain).setCipherSuiteSelector(CipherSuiteSelector.fromNamesString((String)"TLS_AES_128_GCM_SHA256")).setKeyManager(TLS13AuthenticationTest.getKeyManager("/jks/scarab.keystore")).setTrustManager(TLS13AuthenticationTest.getCATrustManager()).setNeedClientAuth(true).build().create();
        SecurityIdentity identity = this.performConnectionTest(serverContext, "protocol://test-two-way-tls13.org", "wildfly-ssl-test-config-v1_5.xml", "TLS_AES_128_GCM_SHA256", true);
        Assert.assertNotNull((Object)identity);
        Assert.assertEquals((String)"Principal Name", (Object)"ladybird", (Object)identity.getPrincipal().getName());
    }

    @Test
    public void testDifferentPreferredTLS13Suites() throws Exception {
        String REQUIRED_CIPHER_SUITE = "TLS_AES_128_GCM_SHA256";
        String PREFERRED_CIPHER_SUITE = "TLS_AES_256_GCM_SHA384";
        String SERVER_CIPHER_SUITE = String.format("%s:%s", "TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256");
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(securityDomain).setCipherSuiteSelector(CipherSuiteSelector.fromNamesString((String)SERVER_CIPHER_SUITE)).setKeyManager(TLS13AuthenticationTest.getKeyManager("/jks/scarab.keystore")).setTrustManager(TLS13AuthenticationTest.getCATrustManager()).setNeedClientAuth(true).build().create();
        SecurityIdentity identity = this.performConnectionTest(serverContext, "protocol://test-different-preferred-tls13-suites.org", "wildfly-ssl-test-config-v1_5.xml", "TLS_AES_128_GCM_SHA256", true);
        Assert.assertNotNull((Object)identity);
        Assert.assertEquals((String)"Principal Name", (Object)"ladybird", (Object)identity.getPrincipal().getName());
    }

    @Test
    public void testClientTLS12Only() throws Exception {
        String TLS13_CIPHER_SUITE = "TLS_AES_128_GCM_SHA256";
        String TLS12_CIPHER_SUITE = "TLS_RSA_WITH_AES_128_CBC_SHA256";
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(securityDomain).setCipherSuiteSelector(CipherSuiteSelector.aggregate((CipherSuiteSelector)CipherSuiteSelector.fromNamesString((String)"TLS_AES_128_GCM_SHA256"), (CipherSuiteSelector)CipherSuiteSelector.fromString((String)"TLS_RSA_WITH_AES_128_CBC_SHA256"))).setKeyManager(TLS13AuthenticationTest.getKeyManager("/jks/scarab.keystore")).setTrustManager(TLS13AuthenticationTest.getCATrustManager()).setNeedClientAuth(true).build().create();
        SecurityIdentity identity = this.performConnectionTest(serverContext, "protocol://test-client-tls12-only.org", "wildfly-ssl-test-config-v1_5.xml", "TLS_RSA_WITH_AES_128_CBC_SHA256", false);
        Assert.assertNotNull((Object)identity);
        Assert.assertEquals((String)"Principal Name", (Object)"ladybird", (Object)identity.getPrincipal().getName());
    }

    @Test
    public void testServerTLS12Only() throws Exception {
        String SERVER_CIPHER_SUITE = "TLS_RSA_WITH_AES_128_CBC_SHA256";
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(securityDomain).setCipherSuiteSelector(CipherSuiteSelector.fromString((String)"TLS_RSA_WITH_AES_128_CBC_SHA256")).setKeyManager(TLS13AuthenticationTest.getKeyManager("/jks/scarab.keystore")).setTrustManager(TLS13AuthenticationTest.getCATrustManager()).setNeedClientAuth(true).build().create();
        SecurityIdentity identity = this.performConnectionTest(serverContext, "protocol://test-server-tls12-only.org", "wildfly-ssl-test-config-v1_5.xml", "TLS_RSA_WITH_AES_128_CBC_SHA256", false);
        Assert.assertNotNull((Object)identity);
        Assert.assertEquals((String)"Principal Name", (Object)"ladybird", (Object)identity.getPrincipal().getName());
    }

    @Test
    public void testOneWayTLS13() throws Exception {
        String CIPHER_SUITE = "TLS_AES_128_GCM_SHA256";
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setCipherSuiteSelector(CipherSuiteSelector.fromNamesString((String)"TLS_AES_128_GCM_SHA256")).setKeyManager(TLS13AuthenticationTest.getKeyManager("/jks/scarab.keystore")).build().create();
        SecurityIdentity identity = this.performConnectionTest(serverContext, "protocol://test-one-way-tls13.org", "wildfly-ssl-test-config-v1_5.xml", "TLS_AES_128_GCM_SHA256", true);
        Assert.assertNull((Object)identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityIdentity performConnectionTest(SSLContext serverContext, String clientUri, String clientConfigFileName, String expectedCipherSuite, boolean expectTLS13) throws Exception {
        System.setProperty("wildfly.config.url", SSLAuthenticationTest.class.getResource(clientConfigFileName).toExternalForm());
        AccessController.doPrivileged(() -> Security.insertProviderAt((Provider)new WildFlyElytronProvider(), 1));
        AuthenticationContext context = (AuthenticationContext)AuthenticationContext.getContextManager().get();
        AuthenticationContextConfigurationClient contextConfigurationClient = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
        SSLContext clientContext = contextConfigurationClient.getSSLContext(URI.create(clientUri), context);
        SSLServerSocketFactory sslServerSocketFactory = serverContext.getServerSocketFactory();
        SSLServerSocket sslServerSocket = (SSLServerSocket)sslServerSocketFactory.createServerSocket(1111, 10, InetAddress.getLoopbackAddress());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<SSLSocket> socketFuture = executorService.submit(() -> {
            try {
                System.out.println("About to connect client");
                SSLSocket sslSocket = (SSLSocket)clientContext.getSocketFactory().createSocket(InetAddress.getLoopbackAddress(), 1111);
                sslSocket.getSession();
                SSLSocket sSLSocket = sslSocket;
                return sSLSocket;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                System.out.println("Client connected");
            }
        });
        SSLSocket serverSocket = (SSLSocket)sslServerSocket.accept();
        SSLSession serverSession = serverSocket.getSession();
        SSLSocket clientSocket = socketFuture.get();
        SSLSession clientSession = clientSocket.getSession();
        try {
            if (expectedCipherSuite != null) {
                if (expectTLS13) {
                    Assert.assertEquals((Object)"TLSv1.3", (Object)serverSession.getProtocol());
                    Assert.assertEquals((Object)"TLSv1.3", (Object)clientSession.getProtocol());
                } else {
                    Assert.assertEquals((Object)"TLSv1.2", (Object)serverSession.getProtocol());
                    Assert.assertEquals((Object)"TLSv1.2", (Object)clientSession.getProtocol());
                }
                Assert.assertEquals((Object)expectedCipherSuite, (Object)serverSession.getCipherSuite());
                Assert.assertEquals((Object)expectedCipherSuite, (Object)clientSession.getCipherSuite());
            }
            SecurityIdentity securityIdentity = (SecurityIdentity)serverSession.getValue("org.wildfly.security.ssl.identity");
            return securityIdentity;
        }
        finally {
            this.safeClose(serverSocket);
            this.safeClose(clientSocket);
            this.safeClose(sslServerSocket);
        }
    }

    private static X509ExtendedKeyManager getKeyManager(String keystorePath) throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(TLS13AuthenticationTest.loadKeyStore(keystorePath), PASSWORD);
        for (KeyManager current : keyManagerFactory.getKeyManagers()) {
            if (!(current instanceof X509ExtendedKeyManager)) continue;
            return (X509ExtendedKeyManager)current;
        }
        throw new IllegalStateException("Unable to obtain X509ExtendedKeyManager.");
    }

    private static X509TrustManager getCATrustManager() throws Exception {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(TLS13AuthenticationTest.loadKeyStore("/jks/ca.truststore"));
        for (TrustManager current : trustManagerFactory.getTrustManagers()) {
            if (!(current instanceof X509TrustManager)) continue;
            return (X509TrustManager)current;
        }
        throw new IllegalStateException("Unable to obtain X509TrustManager.");
    }

    private static KeyStore loadKeyStore(String path) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("jks");
        try (InputStream caTrustStoreFile = SSLAuthenticationTest.class.getResourceAsStream(path);){
            keyStore.load(caTrustStoreFile, PASSWORD);
        }
        return keyStore;
    }

    private void safeClose(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

