/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store;

import java.io.File;
import java.lang.reflect.Field;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Supplier;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreBuilder;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import org.wildfly.security.credential.store.WildFlyElytronCredentialStoreProvider;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;

public class KeystorePasswordStoreTest {
    private static Map<String, String> stores = new HashMap<String, String>();
    private static String BASE_STORE_DIRECTORY = "target/ks-cred-stores";

    private static void cleanCredentialStores() {
        File dir = new File(BASE_STORE_DIRECTORY);
        dir.mkdirs();
        for (String f : stores.values()) {
            File file = new File(f);
            file.delete();
        }
    }

    private static CredentialStore newCredentialStoreInstance() throws NoSuchAlgorithmException {
        return CredentialStore.getInstance((String)KeyStoreCredentialStore.KEY_STORE_CREDENTIAL_STORE, (Provider)WildFlyElytronCredentialStoreProvider.getInstance());
    }

    private PasswordCredential createCredentialFromPassword(char[] password) throws UnsupportedCredentialTypeException {
        try {
            PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"clear", (Provider)WildFlyElytronPasswordProvider.getInstance());
            return new PasswordCredential(passwordFactory.generatePassword((KeySpec)new ClearPasswordSpec(password)));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new UnsupportedCredentialTypeException((Throwable)e);
        }
    }

    private char[] getPasswordFromCredential(PasswordCredential passwordCredential) {
        Assert.assertNotNull((String)"passwordCredential parameter", (Object)passwordCredential);
        return (char[])passwordCredential.getPassword().castAndApply(ClearPassword.class, ClearPassword::getPassword);
    }

    @BeforeClass
    public static void setup() throws Exception {
        KeystorePasswordStoreTest.cleanCredentialStores();
        CredentialStoreBuilder.get().setKeyStoreFile(stores.get("TWO")).setProviders(new Provider[]{WildFlyElytronCredentialStoreProvider.getInstance()}).setKeyStoreType("JCEKS").setKeyStorePassword("secret_store_TWO").addPassword("alias1", "secret-password-1").addPassword("alias2", "secret-password-2").build();
        CredentialStoreBuilder.get().setKeyStoreFile(stores.get("THREE")).setProviders(new Provider[]{WildFlyElytronCredentialStoreProvider.getInstance()}).setKeyStoreType("JCEKS").setKeyStorePassword("secret_store_THREE").addPassword("db-pass-1", "1-secret-info").addPassword("db-pass-2", "2-secret-info").addPassword("db-pass-3", "3-secret-info").addPassword("db-pass-4", "4-secret-info").addPassword("db-pass-5", "5-secret-info").build();
        CredentialStoreBuilder.get().setKeyStoreFile(stores.get("TO_DELETE")).setProviders(new Provider[]{WildFlyElytronCredentialStoreProvider.getInstance()}).setKeyStorePassword("secret_store_DELETE").addPassword("alias1", "secret-password-1").addPassword("alias2", "secret-password-2").build();
    }

    @Test
    public void testRecreatingKSTest() throws NoSuchAlgorithmException, CredentialStoreException, UnsupportedCredentialTypeException {
        File ks = new File(stores.get("TO_DELETE"));
        if (!ks.exists()) {
            Assert.fail((String)"KeyStore must exists!");
        }
        char[] password1 = "secret-password1".toCharArray();
        char[] password2 = "secret-password2".toCharArray();
        HashMap<String, String> csAttributes = new HashMap<String, String>();
        csAttributes.put("location", stores.get("TO_DELETE"));
        csAttributes.put("keyStoreType", "JCEKS");
        String passwordAlias1 = "passAlias1";
        String passwordAlias2 = "passAlias2";
        CredentialStore cs = KeystorePasswordStoreTest.newCredentialStoreInstance();
        cs.initialize(csAttributes, (CredentialStore.ProtectionParameter)new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)IdentityCredentials.NONE.withCredential((Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])"secret_store_DELETE".toCharArray())))), new Provider[]{WildFlyElytronPasswordProvider.getInstance()});
        cs.store(passwordAlias1, (Credential)this.createCredentialFromPassword(password1));
        cs.store(passwordAlias2, (Credential)this.createCredentialFromPassword(password2));
        Assert.assertArrayEquals((char[])password1, (char[])this.getPasswordFromCredential((PasswordCredential)cs.retrieve(passwordAlias1, PasswordCredential.class)));
        if (!ks.delete()) {
            Assert.fail((String)("KeyStore [" + ks.getAbsolutePath() + "] delete fail"));
        }
        Assert.assertArrayEquals((char[])password1, (char[])this.getPasswordFromCredential((PasswordCredential)cs.retrieve(passwordAlias1, PasswordCredential.class)));
        Assert.assertArrayEquals((char[])password2, (char[])this.getPasswordFromCredential((PasswordCredential)cs.retrieve(passwordAlias2, PasswordCredential.class)));
        cs.store("abc", (Credential)this.createCredentialFromPassword(password1));
        cs.flush();
        if (!ks.exists()) {
            Assert.fail((String)("KeyStore [" + ks.getAbsolutePath() + "] must exist yet."));
        }
    }

    @Test
    public void testReadOnly() throws NoSuchAlgorithmException, CredentialStoreException, UnsupportedCredentialTypeException {
        char[] password1 = "secret-password1".toCharArray();
        HashMap<String, String> csAttributes = new HashMap<String, String>();
        csAttributes.put("location", stores.get("TWO"));
        csAttributes.put("keyStoreType", "JCEKS");
        csAttributes.put("modifiable", "false");
        String passwordAlias1 = "passAlias_readonly";
        CredentialStore cs = KeystorePasswordStoreTest.newCredentialStoreInstance();
        cs.initialize(csAttributes, (CredentialStore.ProtectionParameter)new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)IdentityCredentials.NONE.withCredential((Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])"secret_store_TWO".toCharArray())))));
        try {
            cs.store(passwordAlias1, (Credential)this.createCredentialFromPassword(password1));
            Assert.fail((String)"This Credential Store should be read-only.");
        }
        catch (CredentialStoreException credentialStoreException) {
            // empty catch block
        }
        Assert.assertNull((String)("'" + passwordAlias1 + "' must not be in this Credential Store because is read-only."), (Object)cs.retrieve(passwordAlias1, PasswordCredential.class));
    }

    @Test
    public void testCaseInsensitiveAlias() throws NoSuchAlgorithmException, CredentialStoreException, UnsupportedCredentialTypeException {
        HashMap<String, String> csAttributes = new HashMap<String, String>();
        csAttributes.put("location", stores.get("TWO"));
        csAttributes.put("keyStoreType", "JCEKS");
        CredentialStore cs = KeystorePasswordStoreTest.newCredentialStoreInstance();
        cs.initialize(csAttributes, (CredentialStore.ProtectionParameter)new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)IdentityCredentials.NONE.withCredential((Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])"secret_store_TWO".toCharArray())))), new Provider[]{WildFlyElytronPasswordProvider.getInstance()});
        String caseSensitive1 = "caseSensitiveName";
        String caseSensitive2 = caseSensitive1.toUpperCase();
        char[] newPassword1 = "new-secret-passONE".toCharArray();
        char[] newPassword2 = "new-secret-passTWO".toCharArray();
        cs.store(caseSensitive1, (Credential)this.createCredentialFromPassword(newPassword1));
        if (!cs.exists(caseSensitive1, PasswordCredential.class)) {
            Assert.fail((String)("'" + caseSensitive1 + "' must exist"));
        }
        if (!cs.exists(caseSensitive1.toLowerCase(), PasswordCredential.class)) {
            Assert.fail((String)("'" + caseSensitive1.toLowerCase() + "' in lowercase must exist"));
        }
        cs.remove(caseSensitive1, PasswordCredential.class);
        if (cs.exists(caseSensitive1, PasswordCredential.class)) {
            Assert.fail((String)(caseSensitive1 + " has been removed from the vault, but it exists"));
        }
        cs.store(caseSensitive2, (Credential)this.createCredentialFromPassword(newPassword2));
        Assert.assertArrayEquals((char[])newPassword2, (char[])this.getPasswordFromCredential((PasswordCredential)cs.retrieve(caseSensitive1, PasswordCredential.class)));
        Assert.assertArrayEquals((char[])newPassword2, (char[])this.getPasswordFromCredential((PasswordCredential)cs.retrieve(caseSensitive2, PasswordCredential.class)));
        Assert.assertArrayEquals((char[])newPassword2, (char[])this.getPasswordFromCredential((PasswordCredential)cs.retrieve(caseSensitive1.toLowerCase(), PasswordCredential.class)));
        csAttributes.put("location", stores.get("TWO"));
        csAttributes.put("keyStoreType", "JCEKS");
        csAttributes.put("modifiable", "false");
        CredentialStore csReloaded = KeystorePasswordStoreTest.newCredentialStoreInstance();
        csReloaded.initialize(csAttributes, (CredentialStore.ProtectionParameter)new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)IdentityCredentials.NONE.withCredential((Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])"secret_store_TWO".toCharArray())))));
        Assert.assertArrayEquals((char[])newPassword2, (char[])this.getPasswordFromCredential((PasswordCredential)cs.retrieve(caseSensitive1, PasswordCredential.class)));
        Assert.assertArrayEquals((char[])newPassword2, (char[])this.getPasswordFromCredential((PasswordCredential)cs.retrieve(caseSensitive2, PasswordCredential.class)));
        Assert.assertArrayEquals((char[])newPassword2, (char[])this.getPasswordFromCredential((PasswordCredential)cs.retrieve(caseSensitive1.toLowerCase(), PasswordCredential.class)));
    }

    @Test
    public void basicKeystorePasswordStoreTest() throws Exception {
        char[] password1 = "db-secret-pass1".toCharArray();
        char[] password2 = "Pangma\u0160i\u0161at\u00e1".toCharArray();
        char[] password3 = "\u010cervenav\u00fd st\u0159izl\u00ed\u010dek a \u017e\u013e\u00fava \u010fobali ve \u0161\u0165avnat\u00fdch oc\u00fanech".toCharArray();
        HashMap<String, String> csAttributes = new HashMap<String, String>();
        csAttributes.put("location", stores.get("ONE"));
        csAttributes.put("keyStoreType", "JCEKS");
        csAttributes.put("create", Boolean.TRUE.toString());
        String passwordAlias1 = "db1-password1";
        String passwordAlias2 = "db1-password2";
        String passwordAlias3 = "db1-password3";
        CredentialStore cs = KeystorePasswordStoreTest.newCredentialStoreInstance();
        cs.initialize(csAttributes, (CredentialStore.ProtectionParameter)new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)IdentityCredentials.NONE.withCredential((Credential)this.createCredentialFromPassword("test".toCharArray()))), new Provider[]{WildFlyElytronPasswordProvider.getInstance()});
        cs.store(passwordAlias1, (Credential)this.createCredentialFromPassword(password1));
        cs.store(passwordAlias2, (Credential)this.createCredentialFromPassword(password2));
        cs.store(passwordAlias3, (Credential)this.createCredentialFromPassword(password3));
        cs.flush();
        Assert.assertArrayEquals((char[])password2, (char[])this.getPasswordFromCredential((PasswordCredential)cs.retrieve(passwordAlias2, PasswordCredential.class)));
        Assert.assertArrayEquals((char[])password1, (char[])this.getPasswordFromCredential((PasswordCredential)cs.retrieve(passwordAlias1, PasswordCredential.class)));
        Assert.assertArrayEquals((char[])password3, (char[])this.getPasswordFromCredential((PasswordCredential)cs.retrieve(passwordAlias3, PasswordCredential.class)));
        char[] newPassword1 = "new-secret-pass1".toCharArray();
        cs.store(passwordAlias1, (Credential)this.createCredentialFromPassword(newPassword1));
        Assert.assertArrayEquals((char[])newPassword1, (char[])this.getPasswordFromCredential((PasswordCredential)cs.retrieve(passwordAlias1, PasswordCredential.class)));
        cs.remove(passwordAlias2, PasswordCredential.class);
        if (cs.exists(passwordAlias2, PasswordCredential.class)) {
            Assert.fail((String)(passwordAlias2 + " has been removed from the vault, but it exists"));
        }
    }

    @Test
    public void basicTestOnAlreadyCreatedKeystorePasswordStore() throws Exception {
        HashMap<String, String> csAttributes = new HashMap<String, String>();
        csAttributes.put("location", stores.get("TWO"));
        csAttributes.put("keyStoreType", "JCEKS");
        String passwordAlias1 = "alias1";
        String passwordAlias2 = "alias2";
        CredentialStore cs = KeystorePasswordStoreTest.newCredentialStoreInstance();
        cs.initialize(csAttributes, (CredentialStore.ProtectionParameter)new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)IdentityCredentials.NONE.withCredential((Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])"secret_store_TWO".toCharArray())))), new Provider[]{WildFlyElytronPasswordProvider.getInstance()});
        Assert.assertArrayEquals((char[])"secret-password-1".toCharArray(), (char[])this.getPasswordFromCredential((PasswordCredential)cs.retrieve(passwordAlias1, PasswordCredential.class)));
        Assert.assertArrayEquals((char[])"secret-password-2".toCharArray(), (char[])this.getPasswordFromCredential((PasswordCredential)cs.retrieve(passwordAlias2, PasswordCredential.class)));
        Assert.assertNull((Object)cs.retrieve("wrong_alias", PasswordCredential.class));
        cs.store("db-password", (Credential)this.createCredentialFromPassword("supersecretdbpass".toCharArray()));
        cs.remove(passwordAlias2, PasswordCredential.class);
        Set aliases = cs.getAliases();
        Assert.assertFalse((String)("Alias \"" + passwordAlias2 + "\" should be removed."), (boolean)aliases.contains(passwordAlias2));
        if (!cs.exists("db-password", PasswordCredential.class)) {
            Assert.fail((String)"'db-password' has to exist");
        }
        if (cs.exists(passwordAlias2, PasswordCredential.class)) {
            Assert.fail((String)(passwordAlias2 + " has been removed from the vault, but it exists"));
        }
        char[] newPassword1 = "new-secret-pass1".toCharArray();
        cs.store(passwordAlias1, (Credential)this.createCredentialFromPassword(newPassword1));
        Assert.assertArrayEquals((char[])newPassword1, (char[])this.getPasswordFromCredential((PasswordCredential)cs.retrieve(passwordAlias1, PasswordCredential.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParallelAccessToCS() throws UnsupportedCredentialTypeException, CredentialStoreException, NoSuchAlgorithmException {
        HashMap<String, String> csAttributes = new HashMap<String, String>();
        csAttributes.put("location", stores.get("ONE"));
        csAttributes.put("keyStoreType", "JCEKS");
        csAttributes.put("create", Boolean.TRUE.toString());
        CredentialStore cs = KeystorePasswordStoreTest.newCredentialStoreInstance();
        cs.initialize(csAttributes, (CredentialStore.ProtectionParameter)new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)IdentityCredentials.NONE.withCredential((Credential)this.createCredentialFromPassword("test".toCharArray()))), new Provider[]{WildFlyElytronPasswordProvider.getInstance()});
        cs.flush();
        ExecutorService executor = Executors.newFixedThreadPool(4);
        ReadWriteLock readWriteLock = this.getCsLock(cs);
        try {
            Supplier<Callable<Object>> storeTask = () -> this.prepareParallelCsStoreTask(cs, executor, readWriteLock);
            this.testAccessFromMultipleCredentialStores(executor, storeTask);
            Supplier<Callable<Object>> removeTask = () -> this.prepareParallelCsRemoveTask(cs, executor, readWriteLock);
            this.testAccessFromMultipleCredentialStores(executor, removeTask);
        }
        finally {
            executor.shutdown();
            if (readWriteLock.readLock().tryLock()) {
                readWriteLock.readLock().unlock();
            }
        }
    }

    private void testAccessFromMultipleCredentialStores(ExecutorService executor, Supplier<Callable<Object>> csTask) {
        try {
            Callable<Object> task = csTask.get();
            Future<Object> task1Future = executor.submit(task);
            task1Future.get(15L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Callable<Object> prepareParallelCsStoreTask(final CredentialStore cs, final ExecutorService executor, final ReadWriteLock readWriteLock) {
        Callable<Object> task1 = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                final String aliasName = KeystorePasswordStoreTest.addRandomSuffix("alias");
                readWriteLock.readLock().lock();
                Callable<Object> task2 = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        cs.store(aliasName, (Credential)KeystorePasswordStoreTest.this.createCredentialFromPassword("secret".toCharArray()));
                        return null;
                    }
                };
                Future<Object> task2Future = executor.submit(task2);
                try {
                    task2Future.get(1L, TimeUnit.SECONDS);
                    Assert.fail((String)"We expect timeout.");
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
                if (cs.exists(aliasName, PasswordCredential.class)) {
                    throw new IllegalStateException(String.format("Alias '%s' doesn't must exist yet!", aliasName));
                }
                readWriteLock.readLock().unlock();
                task2Future.get(10L, TimeUnit.SECONDS);
                if (!cs.exists(aliasName, PasswordCredential.class)) {
                    throw new IllegalStateException(String.format("Alias '%s' have to exist!", aliasName));
                }
                return null;
            }
        };
        return task1;
    }

    private Callable<Object> prepareParallelCsRemoveTask(final CredentialStore cs, final ExecutorService executor, final ReadWriteLock readWriteLock) {
        Callable<Object> task1 = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                final String aliasName = KeystorePasswordStoreTest.addRandomSuffix("alias");
                cs.store(aliasName, (Credential)KeystorePasswordStoreTest.this.createCredentialFromPassword("secret".toCharArray()));
                readWriteLock.readLock().lock();
                Callable<Object> task2 = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        cs.remove(aliasName, PasswordCredential.class);
                        return null;
                    }
                };
                Future<Object> task2Future = executor.submit(task2);
                try {
                    task2Future.get(1L, TimeUnit.SECONDS);
                    Assert.fail((String)"We expect timeout.");
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
                if (!cs.exists(aliasName, PasswordCredential.class)) {
                    throw new IllegalStateException(String.format("Alias '%s' must exist!", aliasName));
                }
                readWriteLock.readLock().unlock();
                task2Future.get(10L, TimeUnit.SECONDS);
                if (cs.exists(aliasName, PasswordCredential.class)) {
                    throw new IllegalStateException(String.format("Alias '%s' should be deleted!", aliasName));
                }
                return null;
            }
        };
        return task1;
    }

    private ReadWriteLock getCsLock(CredentialStore cs) {
        ReadWriteLock readWriteLock;
        try {
            Field f = CredentialStore.class.getDeclaredField("spi");
            f.setAccessible(true);
            KeyStoreCredentialStore csSpi = (KeyStoreCredentialStore)f.get(cs);
            f.setAccessible(false);
            f = KeyStoreCredentialStore.class.getDeclaredField("readWriteLock");
            f.setAccessible(true);
            readWriteLock = (ReadWriteLock)f.get(csSpi);
            f.setAccessible(false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return readWriteLock;
    }

    private static String addRandomSuffix(String str) {
        return str + "_" + KeystorePasswordStoreTest.getRandomString();
    }

    private static String getRandomString() {
        return RandomStringUtils.randomAlphanumeric((int)10);
    }

    static {
        stores.put("ONE", BASE_STORE_DIRECTORY + "/keystore1.jceks");
        stores.put("TWO", BASE_STORE_DIRECTORY + "/keystore2.jceks");
        stores.put("THREE", BASE_STORE_DIRECTORY + "/keystore3.jceks");
        stores.put("TO_DELETE", BASE_STORE_DIRECTORY + "/keystore4.jceks");
    }
}

