/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.gssapi;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

final class SubjectWrappingSaslServer
implements SaslServer {
    private final SaslServer wrapped;
    private final Subject subject;

    SubjectWrappingSaslServer(SaslServer toBeWrapped, Subject subject) {
        this.wrapped = toBeWrapped;
        this.subject = subject;
    }

    @Override
    public String getMechanismName() {
        return this.wrapped.getMechanismName();
    }

    @Override
    public byte[] evaluateResponse(final byte[] response) throws SaslException {
        try {
            return Subject.doAs(this.subject, new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return SubjectWrappingSaslServer.this.wrapped.evaluateResponse(response);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof SaslException) {
                throw (SaslException)e.getCause();
            }
            throw new SaslException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isComplete() {
        return this.wrapped.isComplete();
    }

    @Override
    public String getAuthorizationID() {
        return this.wrapped.getAuthorizationID();
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        return this.wrapped.unwrap(incoming, offset, len);
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        return this.wrapped.wrap(outgoing, offset, len);
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return this.wrapped.getNegotiatedProperty(propName);
    }

    @Override
    public void dispose() throws SaslException {
        this.wrapped.dispose();
    }
}

