/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest;

import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.security.spec.KeySpec;
import java.util.HashMap;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import mockit.Mock;
import mockit.MockUp;
import mockit.integration.junit4.JMockit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.sasl.digest.DigestSaslServer;
import org.wildfly.security.sasl.digest.DigestServerFactory;
import org.wildfly.security.sasl.digest.WildFlyElytronSaslDigestProvider;
import org.wildfly.security.sasl.test.SaslServerBuilder;

@RunWith(value=JMockit.class)
public class CompatibilityServerTest {
    protected static final String REALM_PROPERTY = "com.sun.security.sasl.digest.realm";
    protected static final String QOP_PROPERTY = "javax.security.sasl.qop";
    private static final Provider provider = WildFlyElytronSaslDigestProvider.getInstance();

    private void mockNonce(final String nonce) {
        new MockUp<DigestSaslServer>(){

            @Mock
            byte[] generateNonce() {
                return nonce.getBytes(StandardCharsets.UTF_8);
            }
        };
    }

    @BeforeClass
    public static void registerPasswordProvider() {
        Security.insertProviderAt(provider, 1);
    }

    @AfterClass
    public static void removePasswordProvider() {
        Security.removeProvider(provider.getName());
    }

    @Test
    public void testRfc2831example1() throws Exception {
        this.mockNonce("OA6MG9tEQGm2hh");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, "DIGEST-MD5").setUserName("chris").setPassword("clear", (KeySpec)new ClearPasswordSpec("secret".toCharArray())).setProtocol("imap").setServerName("elwood.innosoft.com").addMechanismRealm("elwood.innosoft.com").build();
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message1 = server.evaluateResponse(new byte[0]);
        Assert.assertEquals((Object)"realm=\"elwood.innosoft.com\",nonce=\"OA6MG9tEQGm2hh\",charset=utf-8,algorithm=md5-sess", (Object)new String(message1, "UTF-8"));
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message2 = "charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA6MG9tEQGm2hh\",nc=00000001,cnonce=\"OA6MHXh6VqTrRk\",digest-uri=\"imap/elwood.innosoft.com\",response=d388dad90d4bbd760a152321f2143af7,qop=auth".getBytes(StandardCharsets.UTF_8);
        byte[] message3 = server.evaluateResponse(message2);
        Assert.assertEquals((Object)"rspauth=ea40f60335c427b5527b84dbabcdfffd", (Object)new String(message3, "UTF-8"));
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertEquals((Object)"chris", (Object)server.getAuthorizationID());
    }

    @Test
    public void testRfc2831example2() throws Exception {
        this.mockNonce("OA9BSXrbuRhWay");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, "DIGEST-MD5").setUserName("chris").setPassword("clear", (KeySpec)new ClearPasswordSpec("secret".toCharArray())).setProtocol("acap").setServerName("elwood.innosoft.com").addMechanismRealm("elwood.innosoft.com").build();
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message1 = server.evaluateResponse(new byte[0]);
        Assert.assertEquals((Object)"realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",charset=utf-8,algorithm=md5-sess", (Object)new String(message1, "UTF-8"));
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message2 = "charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA9BSuZWMSpW8m\",digest-uri=\"acap/elwood.innosoft.com\",response=6084c6db3fede7352c551284490fd0fc,qop=auth".getBytes(StandardCharsets.UTF_8);
        byte[] message3 = server.evaluateResponse(message2);
        Assert.assertEquals((Object)"rspauth=2f0b3d7c3c2e486600ef710726aa2eae", (Object)new String(message3, "UTF-8"));
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertEquals((Object)"chris", (Object)server.getAuthorizationID());
    }

    private SaslServer testCommonInitSaslServer() throws Exception {
        this.mockNonce("OA9BSXrbuRhWay");
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(REALM_PROPERTY, "elwood.innosoft.com");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, "DIGEST-MD5").setUserName("chris").setPassword("clear", (KeySpec)new ClearPasswordSpec("secret".toCharArray())).setProtocol("acap").setServerName("elwood.innosoft.com").setProperties(serverProps).build();
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message1 = server.evaluateResponse(new byte[0]);
        Assert.assertEquals((Object)"realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",charset=utf-8,algorithm=md5-sess", (Object)new String(message1, "UTF-8"));
        Assert.assertFalse((boolean)server.isComplete());
        return server;
    }

    @Test
    public void testUnauthorizedAuthorizationId() throws Exception {
        SaslServer server = this.testCommonInitSaslServer();
        byte[] message2 = "charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA9BSuZWMSpW8m\",digest-uri=\"acap/elwood.innosoft.com\",maxbuf=65536,response=0d071450228e395e2c0999e02b6aa665,qop=auth,authzid=\"george\"".getBytes(StandardCharsets.UTF_8);
        try {
            server.evaluateResponse(message2);
            Assert.fail((String)"Not throwed SaslException!");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)server.isComplete());
    }

    @Test
    public void testAuthorizedAuthorizationId() throws Exception {
        this.mockNonce("OA9BSXrbuRhWay");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, "DIGEST-MD5").setUserName("chris").setPassword("clear", (KeySpec)new ClearPasswordSpec("secret".toCharArray())).setProtocol("acap").setServerName("elwood.innosoft.com").addMechanismRealm("elwood.innosoft.com").build();
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message1 = server.evaluateResponse(new byte[0]);
        Assert.assertEquals((Object)"realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",charset=utf-8,algorithm=md5-sess", (Object)new String(message1, "UTF-8"));
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message2 = "charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA9BSuZWMSpW8m\",digest-uri=\"acap/elwood.innosoft.com\",response=aa4e81f1c6656350f7bce05d436665de,qop=auth,authzid=\"chris\"".getBytes(StandardCharsets.UTF_8);
        byte[] message3 = server.evaluateResponse(message2);
        Assert.assertEquals((Object)"rspauth=af3ca83a805d4cfa00675a17315475c4", (Object)new String(message3, "UTF-8"));
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertEquals((Object)"chris", (Object)server.getAuthorizationID());
    }

    @Test
    public void testQopAuthInt() throws Exception {
        this.mockNonce("OA9BSXrbuRhWay");
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(QOP_PROPERTY, "auth-int");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, "DIGEST-MD5").setUserName("chris").setPassword("clear", (KeySpec)new ClearPasswordSpec("secret".toCharArray())).setProtocol("acap").setServerName("elwood.innosoft.com").setProperties(serverProps).addMechanismRealm("elwood.innosoft.com").build();
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message1 = server.evaluateResponse(new byte[0]);
        Assert.assertEquals((Object)"realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",qop=\"auth-int\",charset=utf-8,algorithm=md5-sess", (Object)new String(message1, "UTF-8"));
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message2 = "charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA9BSuZWMSpW8m\",digest-uri=\"acap/elwood.innosoft.com\",maxbuf=65536,response=d8b17f55b410208c6ebb22f89f9d6cbb,qop=auth-int,authzid=\"chris\"".getBytes(StandardCharsets.UTF_8);
        byte[] message3 = server.evaluateResponse(message2);
        Assert.assertEquals((Object)"rspauth=7a8794654d6d6de607e9143d52b554a8", (Object)new String(message3, "UTF-8"));
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertEquals((Object)"chris", (Object)server.getAuthorizationID());
        byte[] incoming1 = CodePointIterator.ofString((String)"1122334499191be7952a49d8549b000100000000").hexDecode().drain();
        byte[] incoming1unwrapped = server.unwrap(incoming1, 0, incoming1.length);
        Assert.assertEquals((Object)"11223344", (Object)ByteIterator.ofBytes((byte[])incoming1unwrapped).hexEncode().drainToString());
        byte[] outcoming1 = CodePointIterator.ofString((String)"55667788").hexDecode().drain();
        byte[] outcoming1wrapped = server.wrap(outcoming1, 0, outcoming1.length);
        Assert.assertEquals((Object)"55667788cf5e02ad15987d9076b8000100000000", (Object)ByteIterator.ofBytes((byte[])outcoming1wrapped).hexEncode().drainToString());
        byte[] incoming2 = CodePointIterator.ofString((String)"aabbcc7e845ed48b0474447543000100000001").hexDecode().drain();
        byte[] incoming2unwrapped = server.unwrap(incoming2, 0, incoming2.length);
        Assert.assertEquals((Object)"aabbcc", (Object)ByteIterator.ofBytes((byte[])incoming2unwrapped).hexEncode().drainToString());
        byte[] outcoming2 = new byte[]{};
        byte[] outcoming2wrapped = server.wrap(outcoming2, 0, outcoming2.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])outcoming2wrapped).hexEncode().drainToString());
        byte[] incoming3 = CodePointIterator.ofString((String)"0188034ce1b414194c1c822a55000100000002").hexDecode().drain();
        byte[] incoming3unwrapped = server.unwrap(incoming3, 0, incoming3.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])incoming3unwrapped).hexEncode().drainToString());
        try {
            byte[] incoming4 = CodePointIterator.ofString((String)"0102032cf12c67e4318ebd624e000100000003").hexDecode().drain();
            server.unwrap(incoming4, 0, incoming4.length);
            Assert.fail((String)"Out of order sequencing SaslException expected!");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testQopAuthConf() throws Exception {
        this.mockNonce("OA9BSXrbuRhWay");
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(QOP_PROPERTY, "auth-conf");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, "DIGEST-MD5").setUserName("chris").setPassword("clear", (KeySpec)new ClearPasswordSpec("secret".toCharArray())).setProtocol("acap").setServerName("elwood.innosoft.com").setProperties(serverProps).addMechanismRealm("elwood.innosoft.com").build();
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message1 = server.evaluateResponse(new byte[0]);
        Assert.assertEquals((Object)"realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",qop=\"auth-conf\",charset=utf-8,cipher=\"3des,rc4,des,rc4-56,rc4-40\",algorithm=md5-sess", (Object)new String(message1, "UTF-8"));
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message2 = "charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA9BSuZWMSpW8m\",digest-uri=\"acap/elwood.innosoft.com\",maxbuf=65536,response=4520cf48234bb93b95548a25cd56601b,qop=auth-conf,cipher=\"3des\",authzid=\"chris\"".getBytes(StandardCharsets.UTF_8);
        byte[] message3 = server.evaluateResponse(message2);
        Assert.assertEquals((Object)"rspauth=a804fda66588e2d911bbacd1b1163bc1", (Object)new String(message3, "UTF-8"));
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertEquals((Object)"chris", (Object)server.getAuthorizationID());
        Assert.assertEquals((Object)"auth-conf", (Object)server.getNegotiatedProperty(QOP_PROPERTY));
        Assert.assertEquals((Object)"high", (Object)server.getNegotiatedProperty("javax.security.sasl.strength"));
        byte[] incoming1 = CodePointIterator.ofString((String)"13f7644f8c783501177522c1a455cb1f000100000000").hexDecode().drain();
        byte[] incoming1unwrapped = server.unwrap(incoming1, 0, incoming1.length);
        Assert.assertEquals((Object)"11223344", (Object)ByteIterator.ofBytes((byte[])incoming1unwrapped).hexEncode().drainToString());
        byte[] outcoming1 = CodePointIterator.ofString((String)"55667788").hexDecode().drain();
        byte[] outcoming1wrapped = server.wrap(outcoming1, 0, outcoming1.length);
        Assert.assertEquals((Object)"93ce33409e0fe5187e07c16fc3041f64000100000000", (Object)ByteIterator.ofBytes((byte[])outcoming1wrapped).hexEncode().drainToString());
        byte[] incoming2 = CodePointIterator.ofString((String)"ec426d9cd3276f22285ab5da8df8f26b000100000001").hexDecode().drain();
        byte[] incoming2unwrapped = server.unwrap(incoming2, 0, incoming2.length);
        Assert.assertEquals((Object)"aabbcc", (Object)ByteIterator.ofBytes((byte[])incoming2unwrapped).hexEncode().drainToString());
        byte[] outcoming2 = new byte[]{};
        byte[] outcoming2wrapped = server.wrap(outcoming2, 0, outcoming2.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])outcoming2wrapped).hexEncode().drainToString());
        byte[] incoming3 = CodePointIterator.ofString((String)"b0acad3c969d091251666f91070166f5000100000002").hexDecode().drain();
        byte[] incoming3unwrapped = server.unwrap(incoming3, 0, incoming3.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])incoming3unwrapped).hexEncode().drainToString());
        try {
            byte[] incoming4 = CodePointIterator.ofString((String)"2cfa9bced5b960763953c4f9838b7022000100000003").hexDecode().drain();
            server.unwrap(incoming4, 0, incoming4.length);
            Assert.fail((String)"Out of order sequencing SaslException expected!");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testQopAuthConfRc4() throws Exception {
        this.mockNonce("OA9BSXrbuRhWay");
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(QOP_PROPERTY, "auth-conf");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, "DIGEST-MD5").setUserName("chris").setPassword("clear", (KeySpec)new ClearPasswordSpec("secret".toCharArray())).setProtocol("acap").setServerName("elwood.innosoft.com").addMechanismRealm("elwood.innosoft.com").setProperties(serverProps).build();
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message1 = server.evaluateResponse(new byte[0]);
        Assert.assertEquals((Object)"realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",qop=\"auth-conf\",charset=utf-8,cipher=\"3des,rc4,des,rc4-56,rc4-40\",algorithm=md5-sess", (Object)new String(message1, "UTF-8"));
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message2 = "charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA9BSuZWMSpW8m\",digest-uri=\"acap/elwood.innosoft.com\",maxbuf=65536,response=4520cf48234bb93b95548a25cd56601b,qop=auth-conf,cipher=\"rc4\",authzid=\"chris\"".getBytes(StandardCharsets.UTF_8);
        byte[] message3 = server.evaluateResponse(message2);
        Assert.assertEquals((Object)"rspauth=a804fda66588e2d911bbacd1b1163bc1", (Object)new String(message3, "UTF-8"));
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertEquals((Object)"chris", (Object)server.getAuthorizationID());
        byte[] incoming1 = CodePointIterator.ofString((String)"6a9328ca634e47c8d1ecc3c3f6e6000100000000").hexDecode().drain();
        byte[] incoming1unwrapped = server.unwrap(incoming1, 0, incoming1.length);
        Assert.assertEquals((Object)"11223344", (Object)ByteIterator.ofBytes((byte[])incoming1unwrapped).hexEncode().drainToString());
        byte[] outcoming1 = CodePointIterator.ofString((String)"55667788").hexDecode().drain();
        byte[] outcoming1wrapped = server.wrap(outcoming1, 0, outcoming1.length);
        Assert.assertEquals((Object)"9fc7eb1c3c9e04b52df6e347a389000100000000", (Object)ByteIterator.ofBytes((byte[])outcoming1wrapped).hexEncode().drainToString());
        byte[] incoming2 = CodePointIterator.ofString((String)"7e15b940fccbb58a5612f54da7000100000001").hexDecode().drain();
        byte[] incoming2unwrapped = server.unwrap(incoming2, 0, incoming2.length);
        Assert.assertEquals((Object)"aabbcc", (Object)ByteIterator.ofBytes((byte[])incoming2unwrapped).hexEncode().drainToString());
        byte[] outcoming2 = new byte[]{};
        byte[] outcoming2wrapped = server.wrap(outcoming2, 0, outcoming2.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])outcoming2wrapped).hexEncode().drainToString());
        byte[] incoming3 = CodePointIterator.ofString((String)"84468595614f4ac73fabe47cc4000100000002").hexDecode().drain();
        byte[] incoming3unwrapped = server.unwrap(incoming3, 0, incoming3.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])incoming3unwrapped).hexEncode().drainToString());
        try {
            byte[] incoming4 = CodePointIterator.ofString((String)"4a206df4178a9b7d091dec3527000100000003").hexDecode().drain();
            server.unwrap(incoming4, 0, incoming4.length);
            Assert.fail((String)"Out of order sequencing SaslException expected!");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testQopAuthConfDes() throws Exception {
        this.mockNonce("OA9BSXrbuRhWay");
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(QOP_PROPERTY, "auth-conf");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, "DIGEST-MD5").setUserName("chris").setPassword("clear", (KeySpec)new ClearPasswordSpec("secret".toCharArray())).setProtocol("acap").setServerName("elwood.innosoft.com").addMechanismRealm("elwood.innosoft.com").setProperties(serverProps).build();
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message1 = server.evaluateResponse(new byte[0]);
        Assert.assertEquals((Object)"realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",qop=\"auth-conf\",charset=utf-8,cipher=\"3des,rc4,des,rc4-56,rc4-40\",algorithm=md5-sess", (Object)new String(message1, "UTF-8"));
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message2 = "charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA9BSuZWMSpW8m\",digest-uri=\"acap/elwood.innosoft.com\",maxbuf=65536,response=4520cf48234bb93b95548a25cd56601b,qop=auth-conf,cipher=\"des\",authzid=\"chris\"".getBytes(StandardCharsets.UTF_8);
        byte[] message3 = server.evaluateResponse(message2);
        Assert.assertEquals((Object)"rspauth=a804fda66588e2d911bbacd1b1163bc1", (Object)new String(message3, "UTF-8"));
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertEquals((Object)"chris", (Object)server.getAuthorizationID());
        byte[] incoming1 = CodePointIterator.ofString((String)"b2a12ba8ccd1030e7da4bac57a224197000100000000").hexDecode().drain();
        byte[] incoming1unwrapped = server.unwrap(incoming1, 0, incoming1.length);
        Assert.assertEquals((Object)"11223344", (Object)ByteIterator.ofBytes((byte[])incoming1unwrapped).hexEncode().drainToString());
        byte[] outcoming1 = CodePointIterator.ofString((String)"55667788").hexDecode().drain();
        byte[] outcoming1wrapped = server.wrap(outcoming1, 0, outcoming1.length);
        Assert.assertEquals((Object)"8bc1267e71a769456f0c60f030e13f32000100000000", (Object)ByteIterator.ofBytes((byte[])outcoming1wrapped).hexEncode().drainToString());
        byte[] incoming2 = CodePointIterator.ofString((String)"13144fc90ca65d3838d3547cca43e8ad000100000001").hexDecode().drain();
        byte[] incoming2unwrapped = server.unwrap(incoming2, 0, incoming2.length);
        Assert.assertEquals((Object)"aabbcc", (Object)ByteIterator.ofBytes((byte[])incoming2unwrapped).hexEncode().drainToString());
        byte[] outcoming2 = new byte[]{};
        byte[] outcoming2wrapped = server.wrap(outcoming2, 0, outcoming2.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])outcoming2wrapped).hexEncode().drainToString());
        byte[] incoming3 = CodePointIterator.ofString((String)"7022412985dbee1d261ecb8850486c6e000100000002").hexDecode().drain();
        byte[] incoming3unwrapped = server.unwrap(incoming3, 0, incoming3.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])incoming3unwrapped).hexEncode().drainToString());
        try {
            byte[] incoming4 = CodePointIterator.ofString((String)"3457275b036fa15042e41aeda83a563b000100000003").hexDecode().drain();
            server.unwrap(incoming4, 0, incoming4.length);
            Assert.fail((String)"Out of order sequencing SaslException expected!");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testQopAuthConfRc456() throws Exception {
        this.mockNonce("OA9BSXrbuRhWay");
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(QOP_PROPERTY, "auth-conf");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, "DIGEST-MD5").setUserName("chris").setPassword("clear", (KeySpec)new ClearPasswordSpec("secret".toCharArray())).setProtocol("acap").setServerName("elwood.innosoft.com").setProperties(serverProps).addMechanismRealm("elwood.innosoft.com").build();
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message1 = server.evaluateResponse(new byte[0]);
        Assert.assertEquals((Object)"realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",qop=\"auth-conf\",charset=utf-8,cipher=\"3des,rc4,des,rc4-56,rc4-40\",algorithm=md5-sess", (Object)new String(message1, "UTF-8"));
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message2 = "charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA9BSuZWMSpW8m\",digest-uri=\"acap/elwood.innosoft.com\",maxbuf=65536,response=4520cf48234bb93b95548a25cd56601b,qop=auth-conf,cipher=\"rc4-56\",authzid=\"chris\"".getBytes(StandardCharsets.UTF_8);
        byte[] message3 = server.evaluateResponse(message2);
        Assert.assertEquals((Object)"rspauth=a804fda66588e2d911bbacd1b1163bc1", (Object)new String(message3, "UTF-8"));
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertEquals((Object)"chris", (Object)server.getAuthorizationID());
        byte[] incoming1 = CodePointIterator.ofString((String)"7a77c4b8b20208e502e5dc09bbfc000100000000").hexDecode().drain();
        byte[] incoming1unwrapped = server.unwrap(incoming1, 0, incoming1.length);
        Assert.assertEquals((Object)"11223344", (Object)ByteIterator.ofBytes((byte[])incoming1unwrapped).hexEncode().drainToString());
        byte[] outcoming1 = CodePointIterator.ofString((String)"55667788").hexDecode().drain();
        byte[] outcoming1wrapped = server.wrap(outcoming1, 0, outcoming1.length);
        Assert.assertEquals((Object)"c10acbf737cdebf2298df53417bc000100000000", (Object)ByteIterator.ofBytes((byte[])outcoming1wrapped).hexEncode().drainToString());
        byte[] incoming2 = CodePointIterator.ofString((String)"efcb8662925427788b0ffeab2c000100000001").hexDecode().drain();
        byte[] incoming2unwrapped = server.unwrap(incoming2, 0, incoming2.length);
        Assert.assertEquals((Object)"aabbcc", (Object)ByteIterator.ofBytes((byte[])incoming2unwrapped).hexEncode().drainToString());
        byte[] outcoming2 = new byte[]{};
        byte[] outcoming2wrapped = server.wrap(outcoming2, 0, outcoming2.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])outcoming2wrapped).hexEncode().drainToString());
        byte[] incoming3 = CodePointIterator.ofString((String)"03c8fa9cb28ecf4a99561e5ac3000100000002").hexDecode().drain();
        byte[] incoming3unwrapped = server.unwrap(incoming3, 0, incoming3.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])incoming3unwrapped).hexEncode().drainToString());
        try {
            byte[] incoming4 = CodePointIterator.ofString((String)"4daa261a6afb77f0b1d1d3d4eb000100000003").hexDecode().drain();
            server.unwrap(incoming4, 0, incoming4.length);
            Assert.fail((String)"Out of order sequencing SaslException expected!");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testQopAuthConfRc440() throws Exception {
        this.mockNonce("OA9BSXrbuRhWay");
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(QOP_PROPERTY, "auth-conf");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, "DIGEST-MD5").setUserName("chris").setPassword("clear", (KeySpec)new ClearPasswordSpec("secret".toCharArray())).setProtocol("acap").setServerName("elwood.innosoft.com").addMechanismRealm("elwood.innosoft.com").setProperties(serverProps).build();
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message1 = server.evaluateResponse(new byte[0]);
        Assert.assertEquals((Object)"realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",qop=\"auth-conf\",charset=utf-8,cipher=\"3des,rc4,des,rc4-56,rc4-40\",algorithm=md5-sess", (Object)new String(message1, "UTF-8"));
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message2 = "charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA9BSuZWMSpW8m\",digest-uri=\"acap/elwood.innosoft.com\",maxbuf=65536,response=4520cf48234bb93b95548a25cd56601b,qop=auth-conf,cipher=\"rc4-40\",authzid=\"chris\"".getBytes(StandardCharsets.UTF_8);
        byte[] message3 = server.evaluateResponse(message2);
        Assert.assertEquals((Object)"rspauth=a804fda66588e2d911bbacd1b1163bc1", (Object)new String(message3, "UTF-8"));
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertEquals((Object)"chris", (Object)server.getAuthorizationID());
        byte[] incoming1 = CodePointIterator.ofString((String)"ed46c6b0d38acb719aad661f9625000100000000").hexDecode().drain();
        byte[] incoming1unwrapped = server.unwrap(incoming1, 0, incoming1.length);
        Assert.assertEquals((Object)"11223344", (Object)ByteIterator.ofBytes((byte[])incoming1unwrapped).hexEncode().drainToString());
        byte[] outcoming1 = CodePointIterator.ofString((String)"55667788").hexDecode().drain();
        byte[] outcoming1wrapped = server.wrap(outcoming1, 0, outcoming1.length);
        Assert.assertEquals((Object)"44aca6145a89353d26258e524724000100000000", (Object)ByteIterator.ofBytes((byte[])outcoming1wrapped).hexEncode().drainToString());
        byte[] incoming2 = CodePointIterator.ofString((String)"b7bdc8f08733182154289e7f3d000100000001").hexDecode().drain();
        byte[] incoming2unwrapped = server.unwrap(incoming2, 0, incoming2.length);
        Assert.assertEquals((Object)"aabbcc", (Object)ByteIterator.ofBytes((byte[])incoming2unwrapped).hexEncode().drainToString());
        byte[] outcoming2 = new byte[]{};
        byte[] outcoming2wrapped = server.wrap(outcoming2, 0, outcoming2.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])outcoming2wrapped).hexEncode().drainToString());
        byte[] incoming3 = CodePointIterator.ofString((String)"34968ede3148eb0d3affe15656000100000002").hexDecode().drain();
        byte[] incoming3unwrapped = server.unwrap(incoming3, 0, incoming3.length);
        Assert.assertEquals((Object)"", (Object)ByteIterator.ofBytes((byte[])incoming3unwrapped).hexEncode().drainToString());
        try {
            byte[] incoming4 = CodePointIterator.ofString((String)"8e497ee789076071cf3b5bb9e1000100000003").hexDecode().drain();
            server.unwrap(incoming4, 0, incoming4.length);
            Assert.fail((String)"Out of order sequencing SaslException expected!");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testReplayAttack() throws Exception {
        SaslServer server = this.testCommonInitSaslServer();
        byte[] message2 = "charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA6MG9tEQGm2hh\",nc=00000001,cnonce=\"OA6MHXh6VqTrRk\",digest-uri=\"imap/elwood.innosoft.com\",response=d388dad90d4bbd760a152321f2143af7,qop=auth".getBytes(StandardCharsets.UTF_8);
        try {
            server.evaluateResponse(message2);
            Assert.fail((String)"Not throwed SaslException!");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)server.isComplete());
    }

    @Test
    public void testBadResponse() throws Exception {
        SaslServer server = this.testCommonInitSaslServer();
        byte[] message2 = "charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA9BSuZWMSpW8m\",digest-uri=\"acap/elwood.innosoft.com\",response=d388dad90d4bbd760a152321f2143af7,qop=auth".getBytes(StandardCharsets.UTF_8);
        try {
            server.evaluateResponse(message2);
            Assert.fail((String)"Not throwed SaslException!");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)server.isComplete());
    }

    @Test
    public void testMoreRealmsFromServer() throws Exception {
        this.mockNonce("OA9BSXrbuRhWay");
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(REALM_PROPERTY, "other-realm elwood.innosoft.com next-realm");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, "DIGEST-MD5").setUserName("chris").setPassword("clear", (KeySpec)new ClearPasswordSpec("secret".toCharArray())).setProtocol("acap").setServerName("elwood.innosoft.com").setProperties(serverProps).build();
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message1 = server.evaluateResponse(new byte[0]);
        Assert.assertEquals((Object)"realm=\"other-realm\",realm=\"elwood.innosoft.com\",realm=\"next-realm\",nonce=\"OA9BSXrbuRhWay\",charset=utf-8,algorithm=md5-sess", (Object)new String(message1, "UTF-8"));
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message2 = "charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA9BSuZWMSpW8m\",digest-uri=\"acap/elwood.innosoft.com\",response=d388dad90d4bbd760a152321f2143af7,qop=auth".getBytes(StandardCharsets.UTF_8);
        try {
            server.evaluateResponse(message2);
            Assert.fail((String)"Not throwed SaslException!");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)server.isComplete());
    }

    @Test
    public void testBlankClientNonce() throws Exception {
        this.mockNonce("OA9BSXrbuRhWay");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, "DIGEST-MD5").setUserName("chris").setPassword("clear", (KeySpec)new ClearPasswordSpec("secret".toCharArray())).setProtocol("acap").setServerName("elwood.innosoft.com").addMechanismRealm("other-realm").addMechanismRealm("elwood.innosoft.com").addMechanismRealm("next-realm").build();
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message1 = server.evaluateResponse(new byte[0]);
        Assert.assertEquals((Object)"realm=\"other-realm\",realm=\"elwood.innosoft.com\",realm=\"next-realm\",nonce=\"OA9BSXrbuRhWay\",charset=utf-8,algorithm=md5-sess", (Object)new String(message1, "UTF-8"));
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message2 = "charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"\",digest-uri=\"acap/elwood.innosoft.com\",response=0ca21eafddf586f954909d2fd95b1ee7,qop=auth".getBytes(StandardCharsets.UTF_8);
        byte[] message3 = server.evaluateResponse(message2);
        Assert.assertEquals((Object)"rspauth=2bf631e48acb9863e9f5518ccc804b3b", (Object)new String(message3, "UTF-8"));
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertEquals((Object)"chris", (Object)server.getAuthorizationID());
    }

    @Test
    public void testUtf8Charset() throws Exception {
        this.mockNonce("sn\u0438\u4f60\ud83c\udca1");
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, "DIGEST-MD5").setUserName("\u0438\u4f60\ud83c\udca1").setPassword("clear", (KeySpec)new ClearPasswordSpec("\u0438\u4f60\ud83c\udca1".toCharArray())).setProtocol("\u0438\u4f60\ud83c\udca1").setServerName("realm.\u0438\u4f60\ud83c\udca1.com").setProperties(serverProps).addMechanismRealm("realm.\u0438\u4f60\ud83c\udca1.com").build();
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message1 = server.evaluateResponse(new byte[0]);
        Assert.assertEquals((Object)"realm=\"realm.\u0438\u4f60\ud83c\udca1.com\",nonce=\"sn\u0438\u4f60\ud83c\udca1\",charset=utf-8,algorithm=md5-sess", (Object)new String(message1, "UTF-8"));
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message2 = "charset=utf-8,username=\"\u0438\u4f60\ud83c\udca1\",realm=\"realm.\u0438\u4f60\ud83c\udca1.com\",nonce=\"sn\u0438\u4f60\ud83c\udca1\",nc=00000001,cnonce=\"cn\u0438\u4f60\ud83c\udca1\",digest-uri=\"\u0438\u4f60\ud83c\udca1/realm.\u0438\u4f60\ud83c\udca1.com\",maxbuf=65536,response=420939e06d2d748c157c5e33499b41a9,qop=auth".getBytes(StandardCharsets.UTF_8);
        byte[] message3 = server.evaluateResponse(message2);
        Assert.assertEquals((Object)"rspauth=9c4d137545617ba98c11aaea939b4381", (Object)new String(message3, "UTF-8"));
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertEquals((Object)"\u0438\u4f60\ud83c\udca1", (Object)server.getAuthorizationID());
    }

    @Test
    public void testMoreRealmsWithEscapedDelimiters() throws Exception {
        this.mockNonce("OA9BSXrbuRhWay");
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(REALM_PROPERTY, "first\\ realm second\\\\\\ realm \\ with\\ spaces\\  \\ ");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, "DIGEST-MD5").setUserName("chris").setPassword("clear", (KeySpec)new ClearPasswordSpec("secret".toCharArray())).setProtocol("protocol name").setServerName("server name").addMechanismRealm("first realm").addMechanismRealm("second\\ realm").addMechanismRealm(" with spaces ").addMechanismRealm(" ").setProperties(serverProps).build();
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message1 = server.evaluateResponse(new byte[0]);
        Assert.assertEquals((Object)"realm=\"first realm\",realm=\"second\\\\ realm\",realm=\" with spaces \",realm=\" \",nonce=\"OA9BSXrbuRhWay\",charset=utf-8,algorithm=md5-sess", (Object)new String(message1, "UTF-8"));
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message2 = "charset=utf-8,username=\"chris\",realm=\"first realm\",nonce=\"OA9BSXrbuRhWay\",nc=00000001,cnonce=\"OA6MHXh6VqTrRk\",digest-uri=\"protocol name/server name\",maxbuf=65536,response=bf3dd710ee08b05c663456975c156075,qop=auth".getBytes(StandardCharsets.UTF_8);
        byte[] message3 = server.evaluateResponse(message2);
        Assert.assertEquals((Object)"rspauth=05a18aff49b22e373bb91af7396ce345", (Object)new String(message3, "UTF-8"));
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertEquals((Object)"chris", (Object)server.getAuthorizationID());
    }

    @Test
    public void testIncorrectResponseField() throws Exception {
        this.mockNonce("OA6MG9tEQGm2hh");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, "DIGEST-MD5").setUserName("chris").setPassword("clear", (KeySpec)new ClearPasswordSpec("secret".toCharArray())).setProtocol("imap").setServerName("elwood.innosoft.com").addMechanismRealm("elwood.innosoft.com").build();
        Assert.assertFalse((boolean)server.isComplete());
        byte[] message = server.evaluateResponse(new byte[0]);
        Assert.assertEquals((Object)"realm=\"elwood.innosoft.com\",nonce=\"OA6MG9tEQGm2hh\",charset=utf-8,algorithm=md5-sess", (Object)new String(message, "UTF-8"));
        Assert.assertFalse((boolean)server.isComplete());
        byte[] invalidMessage = "charset=utf-8,username=\"chris\",realm=\"elwood.innosoft.com\",nonce=\"OA6MG9tEQGm2hh\",nc=00000001,cnonce=\"OA6MHXh6VqTrRk\",digest-uri=\"imap/elwood.innosoft.com\",response=incorrectResponse,qop=auth".getBytes(StandardCharsets.UTF_8);
        try {
            server.evaluateResponse(invalidMessage);
        }
        catch (SaslException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("invalid proof"));
        }
    }
}

