/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.auth.server.ServerUtils;
import org.wildfly.security.auth.util.CaseNameRewriter;

public class CaseNameRewriterTest {
    private static final String LOWER_CASE_USER_NAME = "hellouser";
    private static final String UPPER_CASE_USER_NAME = "HELLOUSER";

    @Test
    public void testUpperCaseNameRewriter() {
        CaseNameRewriter rewriter = new CaseNameRewriter(true);
        String adjustedName = rewriter.rewriteName(LOWER_CASE_USER_NAME);
        Assert.assertEquals((Object)UPPER_CASE_USER_NAME, (Object)adjustedName);
    }

    @Test
    public void testUpperCaseNameRewriterDefaultBehaviour() {
        CaseNameRewriter rewriter = new CaseNameRewriter();
        String adjustedName = rewriter.rewriteName(LOWER_CASE_USER_NAME);
        Assert.assertEquals((Object)UPPER_CASE_USER_NAME, (Object)adjustedName);
    }

    @Test
    public void testLowerCaseNameRewriter() {
        CaseNameRewriter rewriter = new CaseNameRewriter(false);
        String adjustedName = rewriter.rewriteName(UPPER_CASE_USER_NAME);
        Assert.assertEquals((Object)LOWER_CASE_USER_NAME, (Object)adjustedName);
    }

    @Test
    public void testCaseNameRewriterExistingUserUpperCase() throws Exception {
        FileSystemSecurityRealm fileSystemSecurityRealm = this.createSecurityRealm();
        CaseNameRewriter rewriter = new CaseNameRewriter(true);
        SecurityDomain domainWithRewriter = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).setPreRealmRewriter((NameRewriter)rewriter).build();
        ServerAuthenticationContext sac1 = domainWithRewriter.createNewAuthenticationContext();
        sac1.setAuthenticationName("alice");
        Assert.assertTrue((boolean)sac1.authorize());
        SecurityDomain domainWithoutRewriter = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
        ServerAuthenticationContext sac2 = domainWithoutRewriter.createNewAuthenticationContext();
        sac2.setAuthenticationName("alice");
        Assert.assertFalse((boolean)sac2.authorize());
    }

    @Test
    public void testCaseNameRewriterExistingUserLowerCase() throws Exception {
        FileSystemSecurityRealm fileSystemSecurityRealm = this.createSecurityRealm();
        CaseNameRewriter rewriter = new CaseNameRewriter(false);
        SecurityDomain domainWithRewriter = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).setPreRealmRewriter((NameRewriter)rewriter).build();
        ServerAuthenticationContext sac1 = domainWithRewriter.createNewAuthenticationContext();
        sac1.setAuthenticationName("JOHN");
        Assert.assertTrue((boolean)sac1.authorize());
        SecurityDomain domainWithoutRewriter = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
        ServerAuthenticationContext sac2 = domainWithoutRewriter.createNewAuthenticationContext();
        sac2.setAuthenticationName("JOHN");
        Assert.assertFalse((boolean)sac2.authorize());
    }

    @Test
    public void testCaseNameRewriterNonExistingUser() throws Exception {
        FileSystemSecurityRealm fileSystemSecurityRealm = this.createSecurityRealm();
        CaseNameRewriter rewriter = new CaseNameRewriter(true);
        SecurityDomain securityDomain = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).setPreRealmRewriter((NameRewriter)rewriter).build();
        ServerAuthenticationContext sac = securityDomain.createNewAuthenticationContext();
        sac.setAuthenticationName("bob");
        Assert.assertFalse((boolean)sac.authorize());
    }

    private FileSystemSecurityRealm createSecurityRealm() throws Exception {
        FileSystemSecurityRealm realm = new FileSystemSecurityRealm(ServerUtils.getRootPath(true, this.getClass()));
        ServerUtils.addUser((ModifiableSecurityRealm)realm, "ALICE");
        ServerUtils.addUser((ModifiableSecurityRealm)realm, "john");
        return realm;
    }
}

