/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.auth.server.ServerUtils;

public class CustomNameRewriterTest {
    private static final String BEFORE_USER_NAME = "Bob";
    private static final String AFTER_USER_NAME = "Robert";

    @Test
    public void testCustomNameRewriter() {
        CustomNameRewriter rewriter = new CustomNameRewriter();
        String adjustedName = rewriter.rewriteName(BEFORE_USER_NAME);
        Assert.assertEquals((Object)AFTER_USER_NAME, (Object)adjustedName);
    }

    @Test
    public void testCustomNameRewriterAuthentication() throws Exception {
        FileSystemSecurityRealm fileSystemSecurityRealm = this.createSecurityRealm();
        CustomNameRewriter rewriter = new CustomNameRewriter();
        SecurityDomain domainWithRewriter = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).setPreRealmRewriter((NameRewriter)rewriter).build();
        ServerAuthenticationContext sac1 = domainWithRewriter.createNewAuthenticationContext();
        sac1.setAuthenticationName(BEFORE_USER_NAME);
        Assert.assertTrue((boolean)sac1.authorize());
        SecurityDomain domainWithoutRewriter = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
        ServerAuthenticationContext sac2 = domainWithoutRewriter.createNewAuthenticationContext();
        sac2.setAuthenticationName(BEFORE_USER_NAME);
        Assert.assertFalse((boolean)sac2.authorize());
    }

    @Test
    public void testCustomNameRewriterNonExistingUser() throws Exception {
        FileSystemSecurityRealm fileSystemSecurityRealm = this.createSecurityRealm();
        CustomNameRewriter rewriter = new CustomNameRewriter();
        SecurityDomain securityDomain = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).setPreRealmRewriter((NameRewriter)rewriter).build();
        ServerAuthenticationContext sac = securityDomain.createNewAuthenticationContext();
        sac.setAuthenticationName("John");
        Assert.assertFalse((boolean)sac.authorize());
    }

    private FileSystemSecurityRealm createSecurityRealm() throws Exception {
        FileSystemSecurityRealm realm = new FileSystemSecurityRealm(ServerUtils.getRootPath(true, this.getClass()));
        ServerUtils.addUser((ModifiableSecurityRealm)realm, AFTER_USER_NAME);
        return realm;
    }

    private final class CustomNameRewriter
    implements NameRewriter {
        private CustomNameRewriter() {
        }

        public String rewriteName(String original) {
            if (original == null) {
                return null;
            }
            if (original.equals(CustomNameRewriterTest.BEFORE_USER_NAME)) {
                return CustomNameRewriterTest.AFTER_USER_NAME;
            }
            return original;
        }
    }
}

