/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.scram;

import java.net.URI;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.ClientUtils;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.password.Password;
import org.wildfly.security.sasl.SaslMechanismSelector;

class ScramCallbackHandlerUtils {
    ScramCallbackHandlerUtils() {
    }

    static CallbackHandler createClientCallbackHandler(String username, char[] password) throws Exception {
        AuthenticationContext context = AuthenticationContext.empty().with(MatchRule.ALL, AuthenticationConfiguration.empty().useName(username).usePassword(password).setSaslMechanismSelector(SaslMechanismSelector.NONE.addMechanism("SCRAM-SHA-256")));
        return ClientUtils.getCallbackHandler(new URI("remote://localhost"), context);
    }

    static CallbackHandler createClientCallbackHandler(String username, Password password) throws Exception {
        AuthenticationContext context = AuthenticationContext.empty().with(MatchRule.ALL, AuthenticationConfiguration.empty().useName(username).usePassword(password).setSaslMechanismSelector(SaslMechanismSelector.NONE.addMechanism("SCRAM-SHA-256")));
        return ClientUtils.getCallbackHandler(new URI("remote://localhost"), context);
    }
}

