/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ldap;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Date;
import java.util.Enumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapName;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.keystore.LdapKeyStore;
import org.wildfly.security.ldap.LdapTestSuite;

public class KeyStoreSuiteChild {
    private static KeyStore keyStore;

    @BeforeClass
    public static void createKeyStore() throws Exception {
        BasicAttributes createAttributes = new BasicAttributes();
        createAttributes.put(new BasicAttribute("objectClass", "inetOrgPerson"));
        createAttributes.put(new BasicAttribute("sn", "newCert"));
        keyStore = LdapKeyStore.builder().setDirContextSupplier(LdapTestSuite.dirContextFactory.create()).setSearchPath("ou=keystore,dc=elytron,dc=wildfly,dc=org").setFilterAlias("(&(objectClass=inetOrgPerson)(cn={0}))").setFilterCertificate("(&(objectClass=inetOrgPerson)(usercertificate={0}))").setFilterIterate("(objectClass=inetOrgPerson)").setCreatePath(new LdapName("ou=keystore,dc=elytron,dc=wildfly,dc=org")).setCreateAttributes((Attributes)createAttributes).setCreateRdn("cn").build();
        keyStore.load(null, null);
    }

    @Test
    public void testAliases() throws Exception {
        Enumeration<String> enumeration = keyStore.aliases();
        Assert.assertNotNull(enumeration);
        int count = 0;
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement());
            ++count;
        }
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIs() throws Exception {
        Assert.assertTrue((boolean)keyStore.isCertificateEntry("firefly"));
        Assert.assertTrue((boolean)keyStore.isCertificateEntry("binary"));
        Assert.assertFalse((boolean)keyStore.isCertificateEntry("nonexisting"));
        Assert.assertTrue((boolean)keyStore.isKeyEntry("firefly"));
        Assert.assertTrue((boolean)keyStore.isKeyEntry("binary"));
        Assert.assertFalse((boolean)keyStore.isKeyEntry("nonexisting"));
    }

    @Test
    public void testGetCertificate() throws Exception {
        X509Certificate cert = (X509Certificate)keyStore.getCertificate("firefly");
        Assert.assertNotNull((Object)cert);
        Assert.assertEquals((Object)"OU=Elytron, O=Elytron, C=UK, ST=Elytron, CN=Firefly", (Object)cert.getSubjectDN().toString());
    }

    @Test
    public void testGetCertificateBinary() throws Exception {
        X509Certificate cert = (X509Certificate)keyStore.getCertificate("binary");
        Assert.assertNotNull((Object)cert);
        Assert.assertEquals((Object)"OU=Elytron, O=Elytron, C=UK, ST=Elytron, CN=Binary", (Object)cert.getSubjectDN().toString());
    }

    @Test
    public void testGetAlias() throws Exception {
        X509Certificate cert = (X509Certificate)keyStore.getCertificate("firefly");
        Assert.assertNotNull((Object)cert);
        String alias = keyStore.getCertificateAlias(cert);
        Assert.assertEquals((Object)"firefly", (Object)alias);
    }

    @Test
    public void testGetAliasBinary() throws Exception {
        X509Certificate cert = (X509Certificate)keyStore.getCertificate("binary");
        Assert.assertNotNull((Object)cert);
        String alias = keyStore.getCertificateAlias(cert);
        Assert.assertEquals((Object)"binary", (Object)alias);
    }

    @Test
    public void testGetCertificateChain() throws Exception {
        Certificate[] chain = keyStore.getCertificateChain("firefly");
        Assert.assertNotNull((Object)chain);
        Assert.assertEquals((long)2L, (long)chain.length);
        Assert.assertEquals((Object)"OU=Elytron, O=Elytron, C=UK, ST=Elytron, CN=Firefly", (Object)((X509Certificate)chain[0]).getSubjectDN().toString());
        Assert.assertEquals((Object)"O=Root Certificate Authority, EMAILADDRESS=elytron@wildfly.org, C=UK, ST=Elytron, CN=Elytron CA", (Object)((X509Certificate)chain[1]).getSubjectDN().toString());
    }

    @Test
    public void testGetCertificateChainBinary() throws Exception {
        Certificate[] chain = keyStore.getCertificateChain("binary");
        Assert.assertNotNull((Object)chain);
        Assert.assertEquals((long)2L, (long)chain.length);
        Assert.assertEquals((Object)"OU=Elytron, O=Elytron, C=UK, ST=Elytron, CN=Binary", (Object)((X509Certificate)chain[0]).getSubjectDN().toString());
        Assert.assertEquals((Object)"O=Root Certificate Authority, EMAILADDRESS=elytron@wildfly.org, C=UK, ST=Elytron, CN=Elytron CA", (Object)((X509Certificate)chain[1]).getSubjectDN().toString());
    }

    @Test
    public void testGetKey() throws Exception {
        RSAPrivateCrtKey key = (RSAPrivateCrtKey)keyStore.getKey("firefly", "Elytron".toCharArray());
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((Object)BigInteger.valueOf(65537L), (Object)key.getPublicExponent());
    }

    @Test
    public void testGetKeyBinary() throws Exception {
        RSAPrivateCrtKey key = (RSAPrivateCrtKey)keyStore.getKey("binary", "Elytron".toCharArray());
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((Object)BigInteger.valueOf(65537L), (Object)key.getPublicExponent());
    }

    @Test
    public void testGetCreationTime() throws Exception {
        Date date = keyStore.getCreationDate("firefly");
        Assert.assertNotNull((Object)date);
        System.out.println(date.toString());
        Assert.assertTrue((date.getTime() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testSetCertificateEntryCreateRemove() throws Exception {
        X509Certificate cert = (X509Certificate)keyStore.getCertificate("firefly");
        keyStore.setCertificateEntry("newcert", cert);
        X509Certificate newcert = (X509Certificate)keyStore.getCertificate("newcert");
        Assert.assertEquals((Object)cert, (Object)newcert);
        Assert.assertTrue((boolean)keyStore.isCertificateEntry("newcert"));
        keyStore.deleteEntry("newcert");
        Assert.assertFalse((boolean)keyStore.isCertificateEntry("newcert"));
    }

    @Test
    public void testSetCertificateEntryUpdate() throws Exception {
        X509Certificate cert = (X509Certificate)keyStore.getCertificate("firefly");
        Date oldDate = keyStore.getCreationDate("firefly");
        keyStore.setCertificateEntry("firefly", cert);
        X509Certificate newcert = (X509Certificate)keyStore.getCertificate("firefly");
        Assert.assertEquals((Object)cert, (Object)newcert);
        Date newDate = keyStore.getCreationDate("firefly");
        Assert.assertNotEquals((Object)oldDate, (Object)newDate);
    }

    @Test
    public void testSetKeyEntry() throws Exception {
        keyStore.load(null, null);
        Object[] chain = keyStore.getCertificateChain("firefly");
        Key key = keyStore.getKey("firefly", "Elytron".toCharArray());
        keyStore.setKeyEntry("newkey", key, "Elytron".toCharArray(), (Certificate[])chain);
        Object[] newchain = keyStore.getCertificateChain("newkey");
        Key newkey = keyStore.getKey("newkey", "Elytron".toCharArray());
        X509Certificate cert = (X509Certificate)keyStore.getCertificate("newkey");
        Assert.assertArrayEquals((Object[])chain, (Object[])newchain);
        Assert.assertEquals((Object)key, (Object)newkey);
        Assert.assertEquals((Object)"OU=Elytron, O=Elytron, C=UK, ST=Elytron, CN=Firefly", (Object)cert.getSubjectDN().toString());
    }
}

