/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.token;

import com.nimbusds.jose.Payload;
import com.nimbusds.jose.PlainHeader;
import com.nimbusds.jose.PlainObject;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import mockit.integration.junit4.JMockit;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.QueueDispatcher;
import okhttp3.mockwebserver.RecordedRequest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.token.TokenSecurityRealm;
import org.wildfly.security.auth.realm.token.TokenValidator;
import org.wildfly.security.auth.realm.token.validator.JwtValidator;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.evidence.BearerTokenEvidence;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.pem.Pem;
import org.wildfly.security.realm.token.test.util.JwtTestUtil;
import org.wildfly.security.realm.token.test.util.RsaJwk;
import org.wildfly.security.ssl.SSLContextBuilder;
import org.wildfly.security.x500.cert.SelfSignedX509CertificateAndSigningKey;

@RunWith(value=JMockit.class)
public class JwtSecurityRealmTest {
    private static final MockWebServer server = new MockWebServer();
    private static final MockWebServer nonTlsServer = new MockWebServer();
    private static final String CA_JKS_LOCATION = "./target/test-classes/jwt/ca/jks/";
    private static char[] PASSWORD = "password".toCharArray();
    private static KeyPair keyPair1;
    private static KeyPair keyPair2;
    private static KeyPair keyPair3;
    private static RsaJwk jwk1;
    private static RsaJwk jwk2;
    private static RsaJwk jwk3;
    private static File trustStoreFile;
    private static String jwksResponse;

    @BeforeClass
    public static void setup() throws GeneralSecurityException, IOException {
        System.setProperty("wildfly.config.url", JwtSecurityRealmTest.class.getResource("wildfly-jwt-test-config.xml").toExternalForm());
        keyPair1 = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        jwk1 = JwtTestUtil.createRsaJwk((KeyPair)keyPair1, (String)"1");
        keyPair2 = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        jwk2 = JwtTestUtil.createRsaJwk((KeyPair)keyPair2, (String)"2");
        keyPair3 = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        jwk3 = JwtTestUtil.createRsaJwk((KeyPair)keyPair3, (String)"3");
        JsonObject jwks = JwtTestUtil.jwksToJson((RsaJwk[])new RsaJwk[]{jwk1, jwk2});
        File dir = new File(CA_JKS_LOCATION);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((trustStoreFile = new File("./target/test-classes/jwt/ca/jks/ca.truststore")).exists()) {
            trustStoreFile.delete();
        }
        KeyStore mockKeyStore = KeyStore.getInstance("JKS");
        KeyStore trustStore = KeyStore.getInstance("JKS");
        mockKeyStore.load(null, null);
        trustStore.load(null, null);
        String alg = KeyManagerFactory.getDefaultAlgorithm();
        SelfSignedX509CertificateAndSigningKey issuerSelfSignedX509CertificateAndSigningKey = SelfSignedX509CertificateAndSigningKey.builder().setDn(new X500Principal("CN=localhost, ST=Elytron, C=UK, EMAILADDRESS=elytron@wildfly.org, O=Root Certificate Authority")).setKeyAlgorithmName("RSA").setSignatureAlgorithmName("SHA256withRSA").addExtension(false, "BasicConstraints", "CA:true,pathlen:2147483647").build();
        X509Certificate issuerCertificate = issuerSelfSignedX509CertificateAndSigningKey.getSelfSignedCertificate();
        mockKeyStore.setKeyEntry("ca", issuerSelfSignedX509CertificateAndSigningKey.getSigningKey(), PASSWORD, new X509Certificate[]{issuerCertificate});
        trustStore.setCertificateEntry("ca", issuerCertificate);
        trustStore.store(new FileOutputStream(trustStoreFile), PASSWORD);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(alg);
        keyManagerFactory.init(mockKeyStore, PASSWORD);
        X509ExtendedKeyManager keyManager = null;
        for (KeyManager km : keyManagerFactory.getKeyManagers()) {
            if (!(km instanceof X509ExtendedKeyManager)) continue;
            keyManager = (X509ExtendedKeyManager)X509ExtendedKeyManager.class.cast(km);
            break;
        }
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setKeyManager(keyManager).build().create();
        jwksResponse = jwks.toString();
        server.useHttps(sslContext.getSocketFactory(), false);
        server.setDispatcher(JwtTestUtil.createTokenDispatcher((String)jwksResponse));
        nonTlsServer.setDispatcher(JwtTestUtil.createTokenDispatcher((String)jwksResponse));
        server.start(50831);
        nonTlsServer.start(50832);
    }

    @AfterClass
    public static void cleanup() throws IOException {
        server.shutdown();
        nonTlsServer.shutdown();
    }

    @Test
    public void testChangedKeys() throws Exception {
        QueueDispatcher dispatcher = new QueueDispatcher();
        dispatcher.enqueueResponse(new MockResponse().setBody(JwtTestUtil.jwksToJson((RsaJwk[])new RsaJwk[]{jwk1}).toString()));
        dispatcher.enqueueResponse(new MockResponse().setBody(JwtTestUtil.jwksToJson((RsaJwk[])new RsaJwk[]{jwk1}).toString()));
        dispatcher.enqueueResponse(new MockResponse().setBody(JwtTestUtil.jwksToJson((RsaJwk[])new RsaJwk[]{jwk2}).toString()));
        dispatcher.enqueueResponse(new MockResponse().setBody(JwtTestUtil.jwksToJson((RsaJwk[])new RsaJwk[]{jwk2}).toString()));
        dispatcher.enqueueResponse(new MockResponse().setBody(JwtTestUtil.jwksToJson((RsaJwk[])new RsaJwk[]{jwk3.setKid("1")}).toString()));
        dispatcher.enqueueResponse(new MockResponse().setBody(JwtTestUtil.jwksToJson((RsaJwk[])new RsaJwk[]{jwk3}).toString()));
        jwk3.setKid("3");
        server.setDispatcher((Dispatcher)dispatcher);
        BearerTokenEvidence evidence1 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair1, (int)60, (int)-1, (String)"1", (URI)new URI("https://localhost:50831")));
        BearerTokenEvidence evidence2 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair2, (int)60, (int)-1, (String)"2", (URI)new URI("https://localhost:50831")));
        BearerTokenEvidence evidence3 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair3, (int)60, (int)-1, (String)"1", (URI)new URI("https://localhost:50831")));
        X509TrustManager tm = this.getTrustManager();
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setTrustManager(tm).setClientMode(true).setSessionTimeout(10).build().create();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).setAllowedJkuValues(new String[]{"https://localhost:50831"}).setJkuTimeout(0L).setJkuMinTimeBetweenRequests(0).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence1);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence2);
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence2);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence3);
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence3);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence1);
        server.setDispatcher(JwtTestUtil.createTokenDispatcher((String)jwksResponse));
    }

    @Test
    public void testNewRotationKeys() throws Exception {
        server.setDispatcher(JwtTestUtil.createTokenDispatcher((String)JwtTestUtil.jwksToJson((RsaJwk[])new RsaJwk[]{jwk1}).toString()));
        BearerTokenEvidence evidence1 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair1, (int)60, (int)-1, (String)"1", (URI)new URI("https://localhost:50831")));
        X509TrustManager tm = this.getTrustManager();
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setTrustManager(tm).setClientMode(true).setSessionTimeout(10).build().create();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).setAllowedJkuValues(new String[]{"https://localhost:50831"}).setJkuTimeout(60000L).setJkuMinTimeBetweenRequests(0).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence1);
        server.setDispatcher(JwtTestUtil.createTokenDispatcher((String)jwksResponse));
        BearerTokenEvidence evidence2 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair2, (int)60, (int)-1, (String)"2", (URI)new URI("https://localhost:50831")));
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence1);
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence2);
    }

    @Test
    public void testNewRotationKeysTimeBetweenRequests() throws Exception {
        server.setDispatcher(JwtTestUtil.createTokenDispatcher((String)JwtTestUtil.jwksToJson((RsaJwk[])new RsaJwk[]{jwk1}).toString()));
        BearerTokenEvidence evidence1 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair1, (int)60, (int)-1, (String)"1", (URI)new URI("https://localhost:50831")));
        X509TrustManager tm = this.getTrustManager();
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setTrustManager(tm).setClientMode(true).setSessionTimeout(10).build().create();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).setAllowedJkuValues(new String[]{"https://localhost:50831"}).setJkuTimeout(60000L).setJkuMinTimeBetweenRequests(10000).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence1);
        server.setDispatcher(JwtTestUtil.createTokenDispatcher((String)jwksResponse));
        BearerTokenEvidence evidence2 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair2, (int)60, (int)-1, (String)"2", (URI)new URI("https://localhost:50831")));
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence1);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence2);
    }

    @Test
    public void testMultipleTokenTypes() throws Exception {
        BearerTokenEvidence evidence1 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair3, (int)60, (int)-1, (String)"1", null));
        BearerTokenEvidence evidence2 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair3, (int)60, (int)-1, (String)"2", null));
        BearerTokenEvidence evidence3 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair2, (int)60, (int)-1, (String)"1", null));
        BearerTokenEvidence evidence4 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair2, (int)60, (int)-1, (String)"2", (URI)new URI("https://localhost:50831")));
        BearerTokenEvidence evidence5 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair3, (int)60, (int)-1, (String)"2", (URI)new URI("https://localhost:50831")));
        BearerTokenEvidence evidence6 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair2, (int)60, (int)-1, (String)"1", (URI)new URI("https://localhost:50831")));
        BearerTokenEvidence evidence7 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair1, (int)60, (int)-1, (String)"3", null));
        BearerTokenEvidence evidence8 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair3, (int)60, (int)-1));
        BearerTokenEvidence evidence9 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair1, (int)60, (int)-1));
        LinkedHashMap<String, PublicKey> namedKeys = new LinkedHashMap<String, PublicKey>();
        namedKeys.put("1", keyPair3.getPublic());
        X509TrustManager tm = this.getTrustManager();
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setTrustManager(tm).setClientMode(true).setSessionTimeout(10).build().create();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).setAllowedJkuValues(new String[]{"https://localhost:50831"}).publicKeys(namedKeys).publicKey(keyPair3.getPublic()).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence1);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence2);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence3);
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence4);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence5);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence6);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence7);
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence8);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence9);
    }

    @Test
    public void testUnsecuredJkuEndpoint() throws Exception {
        this.checkIdentityDoesNotExist("1", 50832);
        BearerTokenEvidence evidence = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair1, (int)60, (int)-1, (String)"1", (URI)new URI("https://localhost:50832")));
        X509TrustManager tm = this.getTrustManager();
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setTrustManager(tm).setClientMode(true).setSessionTimeout(10).build().create();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).setAllowedJkuValues(new String[]{"https://localhost:50832"}).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
    }

    @Test
    public void testKid() throws Exception {
        BearerTokenEvidence evidence1 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair1, (int)60, (int)-1, (String)"1", null));
        BearerTokenEvidence evidence2 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair2, (int)60, (int)-1, (String)"2", null));
        BearerTokenEvidence evidence3 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair2, (int)60, (int)-1, (String)"3", null));
        LinkedHashMap<String, PublicKey> namedKeys = new LinkedHashMap<String, PublicKey>();
        namedKeys.put("1", keyPair1.getPublic());
        namedKeys.put("2", keyPair2.getPublic());
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).publicKeys(namedKeys).build()).build();
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence1);
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence2);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence3);
    }

    @Test
    public void testStoppedJkuEndpoint() throws Exception {
        server.setDispatcher(JwtSecurityRealmTest.createOneTimeDispatcher(jwksResponse));
        BearerTokenEvidence evidence = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair1, (int)60, (int)-1, (String)"1", (URI)new URI("https://localhost:50831")));
        X509TrustManager tm = this.getTrustManager();
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setTrustManager(tm).setClientMode(true).setSessionTimeout(10).build().create();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).setAllowedJkuValues(new String[]{"https://localhost:50831"}).setJkuTimeout(0L).setJkuMinTimeBetweenRequests(0).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
        server.setDispatcher(JwtTestUtil.createTokenDispatcher((String)jwksResponse));
    }

    @Test
    public void testJkuMultipleKeys() throws Exception {
        BearerTokenEvidence evidence1 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair1, (int)60, (int)-1, (String)"1", (URI)new URI("https://localhost:50831")));
        BearerTokenEvidence evidence2 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair2, (int)60, (int)-1, (String)"2", (URI)new URI("https://localhost:50831")));
        X509TrustManager tm = this.getTrustManager();
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setTrustManager(tm).setClientMode(true).setSessionTimeout(10).build().create();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).setAllowedJkuValues(new String[]{"https://localhost:50831"}).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence1);
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence2);
    }

    @Test
    public void testInvalidJku() throws Exception {
        this.checkIdentityDoesNotExist("1", 80);
        BearerTokenEvidence evidence = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair1, (int)60, (int)-1, (String)"1", (URI)new URI("https://localhost:80")));
        X509TrustManager tm = this.getTrustManager();
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setTrustManager(tm).setClientMode(true).setSessionTimeout(10).build().create();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).setAllowedJkuValues(new String[]{"https://localhost:80"}).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
    }

    @Test
    public void testInvalidKid() throws Exception {
        this.checkIdentityDoesNotExist("badkid", 50831);
        BearerTokenEvidence evidence = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair1, (int)60, (int)-1, (String)"badkid", (URI)new URI("https://localhost:50831")));
        X509TrustManager tm = this.getTrustManager();
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setTrustManager(tm).setClientMode(true).setSessionTimeout(10).build().create();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).setAllowedJkuValues(new String[]{"https://localhost:50831"}).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
    }

    @Test
    public void testUsingGeneratedPublicKey() throws Exception {
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        ByteStringBuilder publicKeyPem = new ByteStringBuilder();
        Pem.generatePemPublicKey((ByteStringBuilder)publicKeyPem, (PublicKey)keyPair.getPublic());
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).publicKey(publicKeyPem.toArray()).build()).build();
        RealmIdentity realmIdentity = securityRealm.getRealmIdentity((Evidence)new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair, (int)10, (int)0)));
        Assert.assertNotNull((Object)realmIdentity);
        Assert.assertTrue((boolean)realmIdentity.exists());
        Assert.assertEquals((Object)"elytron@jboss.org", (Object)realmIdentity.getRealmIdentityPrincipal().getName());
    }

    @Test
    public void testEmptyConfiguration() throws Exception {
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        ByteStringBuilder publicKeyPem = new ByteStringBuilder();
        Pem.generatePemPublicKey((ByteStringBuilder)publicKeyPem, (PublicKey)keyPair.getPublic());
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().build()).build();
        RealmIdentity realmIdentity = securityRealm.getRealmIdentity((Evidence)new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair, (int)10, (int)0)));
        Assert.assertNotNull((Object)realmIdentity);
        Assert.assertTrue((boolean)realmIdentity.exists());
        Assert.assertEquals((Object)"elytron@jboss.org", (Object)realmIdentity.getRealmIdentityPrincipal().getName());
    }

    @Test
    public void testWithMultipleAudience() throws Exception {
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"third-app", "another-app-valid", "my-app"}).publicKey(keyPair.getPublic()).build()).build();
        RealmIdentity realmIdentity = securityRealm.getRealmIdentity((Evidence)new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair)));
        Assert.assertNotNull((Object)realmIdentity);
        Assert.assertTrue((boolean)realmIdentity.exists());
        Assert.assertEquals((Object)"elytron@jboss.org", (Object)realmIdentity.getRealmIdentityPrincipal().getName());
    }

    @Test
    public void testInvalidSignature() throws Exception {
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        BearerTokenEvidence evidence = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair));
        KeyPair anotherKeyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).publicKey(anotherKeyPair.getPublic()).build()).build();
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
    }

    @Test
    public void testInvalidIssuer() throws Exception {
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        BearerTokenEvidence evidence = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair));
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"different-issuer"}).audience(new String[]{"my-app-valid"}).publicKey(keyPair.getPublic()).build()).build();
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
    }

    @Test
    public void testInvalidAudience() throws Exception {
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        BearerTokenEvidence evidence = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair));
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"different-audience"}).publicKey(keyPair.getPublic()).build()).build();
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
    }

    @Test
    public void testTokenExpired() throws Exception {
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        BearerTokenEvidence evidence = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair, (int)-1));
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"different-audience"}).publicKey(keyPair.getPublic()).build()).build();
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
    }

    @Test
    public void testTokenNotBefore() throws Exception {
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        BearerTokenEvidence evidence = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair, (int)10, (int)10));
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"different-audience"}).publicKey(keyPair.getPublic()).build()).build();
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
    }

    @Test
    public void testUnsecuredJwt() throws Exception {
        PlainObject plainObject = new PlainObject(new PlainHeader(), new Payload(JwtTestUtil.createClaims((int)10, (int)0).build().toString()));
        BearerTokenEvidence evidence = new BearerTokenEvidence(plainObject.serialize());
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).build()).build();
        RealmIdentity realmIdentity = securityRealm.getRealmIdentity((Evidence)evidence);
        Assert.assertNotNull((Object)realmIdentity);
        Assert.assertTrue((boolean)realmIdentity.exists());
        Assert.assertEquals((Object)"elytron@jboss.org", (Object)realmIdentity.getRealmIdentityPrincipal().getName());
    }

    @Test
    public void testAltPrincipaNames() throws Exception {
        JsonObjectBuilder altBuilder = Json.createObjectBuilder().add("upn", "upn:elytron@jboss.org");
        PlainObject plainObject = new PlainObject(new PlainHeader(), new Payload(JwtTestUtil.createClaims((int)10, (int)0, (JsonObject)altBuilder.build()).build().toString()));
        BearerTokenEvidence evidence = new BearerTokenEvidence(plainObject.serialize());
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().claimToPrincipal(claims -> {
            String pn = claims.getFirst("upn");
            if (pn == null) {
                pn = claims.getFirst("preferred_name");
            }
            if (pn == null) {
                pn = claims.getFirst("sub");
            }
            return new NamePrincipal(pn);
        }).validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).build()).build();
        RealmIdentity realmIdentity = securityRealm.getRealmIdentity((Evidence)evidence);
        Assert.assertNotNull((Object)realmIdentity);
        Assert.assertTrue((boolean)realmIdentity.exists());
        Assert.assertEquals((Object)"upn:elytron@jboss.org", (Object)realmIdentity.getRealmIdentityPrincipal().getName());
    }

    @Test
    public void testAltPrincipaNamesSubFallback() throws Exception {
        PlainObject plainObject = new PlainObject(new PlainHeader(), new Payload(JwtTestUtil.createClaims((int)10, (int)0).build().toString()));
        BearerTokenEvidence evidence = new BearerTokenEvidence(plainObject.serialize());
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).build()).build();
        RealmIdentity realmIdentity = securityRealm.getRealmIdentity((Evidence)evidence);
        Assert.assertNotNull((Object)realmIdentity);
        Assert.assertTrue((boolean)realmIdentity.exists());
        Assert.assertEquals((Object)"elytron@jboss.org", (Object)realmIdentity.getRealmIdentityPrincipal().getName());
    }

    @Test
    public void testTokenWithJkuValueAllowed() throws Exception {
        BearerTokenEvidence evidence = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair1, (int)60, (int)-1, (String)"1", (URI)new URI("https://localhost:50831")));
        SSLContext sslContext = this.getSSLContext();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).setAllowedJkuValues(new String[]{"https://localhost:50832", "https://localhost:50831"}).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence);
    }

    @Test
    public void testTokenWithJkuValueNotAllowed() throws Exception {
        BearerTokenEvidence evidence = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair1, (int)60, (int)-1, (String)"1", (URI)new URI("https://localhost:50834")));
        SSLContext sslContext = this.getSSLContext();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).setAllowedJkuValues(new String[]{"https://localhost:50832", "https://localhost:50831"}).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
    }

    @Test
    public void testAllowedJkuValuesNotConfigured() throws Exception {
        BearerTokenEvidence evidence = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair1, (int)60, (int)-1, (String)"1", (URI)new URI("https://localhost:50831")));
        SSLContext sslContext = this.getSSLContext();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
    }

    @Test
    public void testTokenWithoutJkuValue() throws Exception {
        BearerTokenEvidence evidence1 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair1, (int)60, (int)-1, (String)"1", null));
        BearerTokenEvidence evidence2 = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair2, (int)60, (int)-1, (String)"2", null));
        LinkedHashMap<String, PublicKey> namedKeys = new LinkedHashMap<String, PublicKey>();
        namedKeys.put("1", keyPair1.getPublic());
        namedKeys.put("2", keyPair2.getPublic());
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).setAllowedJkuValues(new String[]{"https://localhost:50832", "https://localhost:50831"}).publicKeys(namedKeys).build()).build();
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence1);
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence2);
    }

    private void assertIdentityNotExist(SecurityRealm realm, Evidence evidence) throws RealmUnavailableException {
        RealmIdentity identity = realm.getRealmIdentity(evidence);
        Assert.assertNotNull((Object)identity);
        Assert.assertFalse((boolean)identity.exists());
    }

    private void assertIdentityExist(SecurityRealm realm, Evidence evidence) throws RealmUnavailableException {
        RealmIdentity identity = realm.getRealmIdentity(evidence);
        Assert.assertNotNull((Object)identity);
        Assert.assertTrue((boolean)identity.exists());
    }

    private X509TrustManager getTrustManager() throws Exception {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(new FileInputStream(trustStoreFile), PASSWORD);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustStore);
        X509TrustManager tm = null;
        for (TrustManager tm1 : tmf.getTrustManagers()) {
            if (!(tm1 instanceof X509TrustManager)) continue;
            tm = (X509TrustManager)X509TrustManager.class.cast(tm1);
            break;
        }
        Assert.assertNotNull(tm);
        return tm;
    }

    private SSLContext getSSLContext() throws Exception {
        X509TrustManager trustManager = this.getTrustManager();
        return (SSLContext)new SSLContextBuilder().setTrustManager(trustManager).setClientMode(true).setSessionTimeout(10).build().create();
    }

    private static Dispatcher createOneTimeDispatcher(final String response) {
        return new Dispatcher(){
            boolean used = false;

            public MockResponse dispatch(RecordedRequest recordedRequest) {
                if (!this.used) {
                    this.used = true;
                    return new MockResponse().setBody(response);
                }
                return new MockResponse().setResponseCode(404);
            }
        };
    }

    private void checkIdentityDoesNotExist(String kid, int port) throws Exception {
        BearerTokenEvidence evidence = new BearerTokenEvidence(JwtTestUtil.createJwt((KeyPair)keyPair1, (int)60, (int)-1, (String)kid, (URI)new URI("https://localhost:" + port)));
        X509TrustManager tm = this.getTrustManager();
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setTrustManager(tm).setClientMode(true).setSessionTimeout(10).build().create();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
    }

    static {
        jwk1 = new RsaJwk();
        jwk2 = new RsaJwk();
        jwk3 = new RsaJwk();
    }
}

