/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.keystore;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.auth.server.ServerUtils;
import org.wildfly.security.keystore.PasswordEntry;
import org.wildfly.security.keystore.WildFlyElytronKeyStoreProvider;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;
import org.wildfly.security.password.spec.SaltedPasswordAlgorithmSpec;

public class PasswordFileKeyStoreTest {
    @Test
    public void testGetPut() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"crypt-md5", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        byte[] b = new byte[16];
        ThreadLocalRandom.current().nextBytes(b);
        Password password = passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec("swordfish".toCharArray(), (AlgorithmParameterSpec)new SaltedPasswordAlgorithmSpec(b)));
        KeyStore keyStore = KeyStore.getInstance("PasswordFile", (Provider)WildFlyElytronKeyStoreProvider.getInstance());
        keyStore.load(new InputStream(){

            @Override
            public int read() throws IOException {
                return -1;
            }
        }, null);
        keyStore.setEntry("bob", (KeyStore.Entry)new PasswordEntry(password), null);
        KeyStore.Entry entry = keyStore.getEntry("bob", null);
        Assert.assertNotNull((String)"Missing entry", (Object)entry);
        Assert.assertTrue((String)"Wrong entry type", (boolean)(entry instanceof PasswordEntry));
        Password storedPassword = ((PasswordEntry)entry).getPassword();
        Assert.assertNotNull((Object)storedPassword);
        Assert.assertSame((Object)password, (Object)storedPassword);
    }
}

